/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import cpw.mods.fml.common.FMLLog;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeInternalHandler;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.event.EventBus;

public class MinecraftForge {
    public static final EventBus EVENT_BUS = new EventBus();
    public static boolean SPAWNER_ALLOW_ON_INVERTED = false;
    private static final ForgeInternalHandler INTERNAL_HANDLER = new ForgeInternalHandler();

    public static void addGrassPlant(ale block, int metadata, int weight) {
        ForgeHooks.grassList.add(new ForgeHooks.GrassEntry(block, metadata, weight));
    }

    public static void addGrassSeed(tu seed, int weight) {
        ForgeHooks.seedList.add(new ForgeHooks.SeedEntry(seed, weight));
    }

    public static void setToolClass(ts tool, String toolClass, int harvestLevel) {
        ForgeHooks.toolClasses.put(tool, Arrays.asList(toolClass, harvestLevel));
    }

    public static void setBlockHarvestLevel(ale block, int metadata, String toolClass, int harvestLevel) {
        List<Object> key = Arrays.asList(block, metadata, toolClass);
        ForgeHooks.toolHarvestLevels.put(key, harvestLevel);
        ForgeHooks.toolEffectiveness.add(key);
    }

    public static void removeBlockEffectiveness(ale block, int metadata, String toolClass) {
        List<Object> key = Arrays.asList(block, metadata, toolClass);
        ForgeHooks.toolEffectiveness.remove(key);
    }

    public static void setBlockHarvestLevel(ale block, String toolClass, int harvestLevel) {
        for (int metadata = 0; metadata < 16; ++metadata) {
            List<Object> key = Arrays.asList(block, metadata, toolClass);
            ForgeHooks.toolHarvestLevels.put(key, harvestLevel);
            ForgeHooks.toolEffectiveness.add(key);
        }
    }

    public static int getBlockHarvestLevel(ale block, int metadata, String toolClass) {
        ForgeHooks.initTools();
        List<Object> key = Arrays.asList(block, metadata, toolClass);
        Integer harvestLevel = ForgeHooks.toolHarvestLevels.get(key);
        if (harvestLevel == null) {
            return -1;
        }
        return harvestLevel;
    }

    public static void removeBlockEffectiveness(ale block, String toolClass) {
        for (int metadata = 0; metadata < 16; ++metadata) {
            List<Object> key = Arrays.asList(block, metadata, toolClass);
            ForgeHooks.toolEffectiveness.remove(key);
        }
    }

    public static void initialize() {
        System.out.printf("MinecraftForge v%s Initialized\n", ForgeVersion.getVersion());
        FMLLog.info("MinecraftForge v%s Initialized", ForgeVersion.getVersion());
        ale filler = new ale(0, aff.a);
        ale.p[0] = null;
        ale.q[0] = false;
        ale.r[0] = 0;
        for (int x = 256; x < 4096; ++x) {
            if (ts.e[x] == null) continue;
            ale.p[x] = filler;
        }
        boolean[] temp = new boolean[4096];
        for (int x = 0; x < pl.d.length; ++x) {
            temp[x] = pl.d[x];
        }
        pl.d = temp;
        EVENT_BUS.register(INTERNAL_HANDLER);
    }

    public static String getBrandingVersion() {
        return "Minecraft Forge " + ForgeVersion.getVersion();
    }
}

