/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class OreDictionary {
    private static int maxID = 0;
    private static HashMap<String, Integer> oreIDs = new HashMap();
    private static HashMap<Integer, ArrayList<tu>> oreStacks = new HashMap();

    public static int getOreID(String name) {
        Integer val = oreIDs.get(name);
        if (val == null) {
            val = maxID++;
            oreIDs.put(name, val);
            oreStacks.put(val, new ArrayList());
        }
        return val;
    }

    public static String getOreName(int id2) {
        for (Map.Entry<String, Integer> entry : oreIDs.entrySet()) {
            if (id2 != entry.getValue()) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static ArrayList<tu> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreIDs.keySet().toArray(new String[0]);
    }

    public static ArrayList<tu> getOres(Integer id2) {
        ArrayList<Object> val = oreStacks.get(id2);
        if (val == null) {
            val = new ArrayList();
            oreStacks.put(id2, val);
        }
        return val;
    }

    public static void registerOre(String name, ts ore) {
        OreDictionary.registerOre(name, new tu(ore));
    }

    public static void registerOre(String name, ale ore) {
        OreDictionary.registerOre(name, new tu(ore));
    }

    public static void registerOre(String name, tu ore) {
        OreDictionary.registerOre(name, OreDictionary.getOreID(name), ore);
    }

    public static void registerOre(int id2, ts ore) {
        OreDictionary.registerOre(id2, new tu(ore));
    }

    public static void registerOre(int id2, ale ore) {
        OreDictionary.registerOre(id2, new tu(ore));
    }

    public static void registerOre(int id2, tu ore) {
        OreDictionary.registerOre(OreDictionary.getOreName(id2), id2, ore);
    }

    private static void registerOre(String name, int id2, tu ore) {
        ArrayList<tu> ores = OreDictionary.getOres(id2);
        ore = ore.l();
        ores.add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final tu Ore;

        public OreRegisterEvent(String name, tu ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

