/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedOreRecipe
implements vr {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private tu output = null;
    private Object[] input = null;
    private int width = 0;
    private int height = 0;
    private boolean mirriored = true;

    public ShapedOreRecipe(ale result, Object ... recipe) {
        this(result, true, recipe);
    }

    public ShapedOreRecipe(ts result, Object ... recipe) {
        this(result, true, recipe);
    }

    public ShapedOreRecipe(tu result, Object ... recipe) {
        this(result, true, recipe);
    }

    public ShapedOreRecipe(ale result, boolean mirrior, Object ... recipe) {
        this(new tu(result), mirrior, recipe);
    }

    public ShapedOreRecipe(ts result, boolean mirrior, Object ... recipe) {
        this(new tu(result), mirrior, recipe);
    }

    public ShapedOreRecipe(tu result, boolean mirrior, Object ... recipe) {
        this.output = result.l();
        this.mirriored = mirrior;
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            Object val = null;
            if (in instanceof tu) {
                itemMap.put(chr, ((tu)in).l());
            } else if (in instanceof ts) {
                itemMap.put(chr, new tu((ts)in));
            } else if (in instanceof ale) {
                itemMap.put(chr, new tu((ale)in, 1, -1));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)in));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    public tu a(rf var1) {
        return this.output.l();
    }

    public int a() {
        return this.input.length;
    }

    public tu b() {
        return this.output;
    }

    public boolean a(rf inv, xd world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, true)) {
                    return true;
                }
                if (!this.mirriored || !this.checkMatch(inv, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(rf inv, int startX, int startY, boolean mirrior) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirrior ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                tu slot = inv.b(x, y);
                if (target instanceof tu) {
                    if (this.checkItemEquals((tu)target, slot)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    for (tu item : (ArrayList)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(tu target, tu input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.c == input.c && (target.j() == -1 || target.j() == input.j());
    }

    public void setMirriored(boolean mirrior) {
        this.mirriored = mirrior;
    }
}

