/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.launcher;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class FMLTweaker
implements ITweaker {
    private List<String> args;
    private File gameDir;
    private File assetsDir;
    private String profile;
    private static URI jarLocation;
    private String[] array;
    private List<ITweaker> cascadedTweaks;
    private String profileName;
    private OptionSet parsedOptions;
    private ArgumentAcceptingOptionSpec<String> cascadedTweaksOption;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.gameDir = gameDir == null ? new File(".") : gameDir;
        this.assetsDir = assetsDir;
        this.profile = profile;
        try {
            jarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            Logger.getLogger("FMLTWEAK").log(Level.SEVERE, "Missing URI information for FML tweak");
            throw Throwables.propagate((Throwable)e);
        }
        OptionParser optionParser = new OptionParser();
        this.cascadedTweaksOption = optionParser.accepts("cascadedTweaks", "Additional tweaks to be called by FML, implementing ITweaker").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',');
        ArgumentAcceptingOptionSpec profileNameOption = optionParser.accepts("profileName", "A profile name, parsed by FML to control mod loading and such").withRequiredArg().ofType(String.class);
        optionParser.allowsUnrecognizedOptions();
        NonOptionArgumentSpec nonOptions = optionParser.nonOptions();
        this.parsedOptions = optionParser.parse(args.toArray(new String[args.size()]));
        if (this.parsedOptions.has((OptionSpec)profileNameOption)) {
            this.profileName = (String)profileNameOption.value(this.parsedOptions);
        }
        this.args = this.parsedOptions.valuesOf((OptionSpec)nonOptions);
        this.cascadedTweaks = Lists.newArrayList();
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        this.computeCascadedTweaks(classLoader);
        classLoader.addTransformerExclusion("cpw.mods.fml.repackage.");
        classLoader.addTransformerExclusion("cpw.mods.fml.relauncher.");
        classLoader.addTransformerExclusion("cpw.mods.fml.common.asm.transformers.");
        classLoader.addClassLoaderExclusion("LZMA.");
        FMLLaunchHandler.configureForClientLaunch(classLoader, this);
        this.runAdditionalTweaks(classLoader);
        FMLLaunchHandler.appendCoreMods();
    }

    void computeCascadedTweaks(LaunchClassLoader classLoader) {
        if (this.parsedOptions.has(this.cascadedTweaksOption)) {
            for (String tweaker : this.cascadedTweaksOption.values(this.parsedOptions)) {
                try {
                    classLoader.addClassLoaderExclusion(tweaker.substring(0, tweaker.lastIndexOf(46)));
                    Class<?> tweakClass = Class.forName(tweaker, true, (ClassLoader)classLoader);
                    ITweaker additionalTweak = (ITweaker)tweakClass.newInstance();
                    this.cascadedTweaks.add(additionalTweak);
                }
                catch (Exception e) {
                    Logger.getLogger("FMLTWEAK").log(Level.INFO, "Missing additional tweak class " + tweaker);
                }
            }
        }
    }

    void runAdditionalTweaks(LaunchClassLoader classLoader) {
        ArrayList fmlArgs = Lists.newArrayList(this.args);
        fmlArgs.add("--fmlIsPresent");
        for (ITweaker tweak : this.cascadedTweaks) {
            tweak.acceptOptions((List)fmlArgs, this.gameDir, this.assetsDir, this.profile);
            tweak.injectIntoClassLoader(classLoader);
        }
    }

    public String getLaunchTarget() {
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        Object[] array = this.args.toArray(new String[this.args.size()]);
        if (this.gameDir != null) {
            array = (String[])ObjectArrays.concat((Object)this.gameDir.getAbsolutePath(), (Object[])array);
            array = (String[])ObjectArrays.concat((Object)"--gameDir", (Object[])array);
        }
        if (this.assetsDir != null) {
            array = (String[])ObjectArrays.concat((Object)this.assetsDir.getAbsolutePath(), (Object[])array);
            array = (String[])ObjectArrays.concat((Object)"--assetsDir", (Object[])array);
        }
        if (this.profile != null) {
            array = (String[])ObjectArrays.concat((Object)this.profile, (Object[])array);
            array = (String[])ObjectArrays.concat((Object)"--version", (Object[])array);
        } else {
            array = (String[])ObjectArrays.concat((Object)"UnknownFMLProfile", (Object[])array);
            array = (String[])ObjectArrays.concat((Object)"--version", (Object[])array);
        }
        for (ITweaker tweak : this.cascadedTweaks) {
            array = (String[])ObjectArrays.concat((Object[])tweak.getLaunchArguments(), (Object[])array, String.class);
        }
        return array;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public static URI getJarLocation() {
        return jarLocation;
    }

    public void injectCascadingTweak(ITweaker tweaker) {
        this.cascadedTweaks.add(tweaker);
    }
}

