/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class FluidTank
implements IFluidTank {
    protected FluidStack fluid;
    protected int capacity;
    protected aor tile;

    public FluidTank(int capacity) {
        this(null, capacity);
    }

    public FluidTank(FluidStack stack, int capacity) {
        this.fluid = stack;
        this.capacity = capacity;
    }

    public FluidTank(Fluid fluid, int amount, int capacity) {
        this(new FluidStack(fluid, amount), capacity);
    }

    public FluidTank readFromNBT(dh nbt) {
        FluidStack fluid;
        if (!nbt.c("Empty") && (fluid = FluidStack.loadFluidStackFromNBT(nbt)) != null) {
            this.setFluid(fluid);
        }
        return this;
    }

    public dh writeToNBT(dh nbt) {
        if (this.fluid != null) {
            this.fluid.writeToNBT(nbt);
        } else {
            nbt.a("Empty", "");
        }
        return nbt;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public int getFluidAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this);
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (this.fluid == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.amount, resource.amount);
        }
        if (this.fluid == null) {
            this.fluid = new FluidStack(resource, Math.min(this.capacity, resource.amount));
            if (this.tile != null) {
                FluidEvent.fireEvent(new FluidEvent.FluidFillingEvent(this.fluid, this.tile.w(), this.tile.c, this.tile.d, this.tile.e, this, this.fluid.amount));
            }
            return this.fluid.amount;
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.amount;
        if (resource.amount < filled) {
            this.fluid.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluid.amount = this.capacity;
        }
        if (this.tile != null) {
            FluidEvent.fireEvent(new FluidEvent.FluidFillingEvent(this.fluid, this.tile.w(), this.tile.c, this.tile.d, this.tile.e, this, filled));
        }
        return filled;
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluid.amount < drained) {
            drained = this.fluid.amount;
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (doDrain) {
            this.fluid.amount -= drained;
            if (this.fluid.amount <= 0) {
                this.fluid = null;
            }
            if (this.tile != null) {
                FluidEvent.fireEvent(new FluidEvent.FluidDrainingEvent(this.fluid, this.tile.w(), this.tile.c, this.tile.d, this.tile.e, this, drained));
            }
        }
        return stack;
    }
}

