/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.network.ForgeNetworkHandler;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.server.command.ForgeCommand;

public class ForgeModContainer
extends DummyModContainer
implements WorldAccessContainer {
    public static int clumpingThreshold = 64;
    public static boolean removeErroringEntities = false;
    public static boolean removeErroringTileEntities = false;
    public static boolean disableStitchedFileSaving = false;
    public static boolean fullBoundingBoxLadders = false;
    public static double zombieSummonBaseChance = 0.1;
    public static int[] blendRanges = new int[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34};
    public static float zombieBabyChance = 0.05f;
    public static boolean shouldSortRecipies = true;
    public static boolean disableVersionCheck = false;
    public static int defaultSpawnFuzz = 20;
    public static boolean defaultHasSpawnFuzz = true;
    private static Configuration config;

    public ForgeModContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "Forge";
        meta.name = "Minecraft Forge";
        meta.version = String.format("%d.%d.%d.%d", 10, 13, 3, 1385);
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("LexManos", "Eloraam", "Spacetoad");
        meta.description = "Minecraft Forge is a common open source API allowing a broad range of mods to work cooperatively together. It allows many mods to be created without them editing the main Minecraft code.";
        meta.url = "http://MinecraftForge.net";
        meta.updateUrl = "http://MinecraftForge.net/forum/index.php/topic,5.0.html";
        meta.screenshots = new String[0];
        meta.logoFile = "/forge_logo.png";
        config = null;
        File cfgFile = new File(Loader.instance().getConfigDir(), "forge.cfg");
        config = new Configuration(cfgFile);
        ForgeModContainer.syncConfig(true);
    }

    @Override
    public String getGuiClassName() {
        return "net.minecraftforge.client.gui.ForgeGuiFactory";
    }

    public static Configuration getConfig() {
        return config;
    }

    private static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        if (!ForgeModContainer.config.isChild) {
            Property enableGlobalCfg;
            if (load) {
                config.load();
            }
            if ((enableGlobalCfg = config.get("general", "enableGlobalConfig", false).setShowInGui(false)).getBoolean(false)) {
                Configuration.enableGlobalConfig();
            }
        }
        Property prop = config.get("general", "disableVersionCheck", false);
        prop.comment = "Set to true to disable Forge's version check mechanics. Forge queries a small json file on our server for version information. For more details see the ForgeVersion class in our github.";
        prop.setLanguageKey("forge.configgui.disableVersionCheck");
        disableVersionCheck = prop.getBoolean(disableVersionCheck);
        propOrder.add(prop.getName());
        prop = config.get("general", "clumpingThreshold", 64, "Controls the number threshold at which Packet51 is preferred over Packet52, default and minimum 64, maximum 1024", 64, 1024);
        prop.setLanguageKey("forge.configgui.clumpingThreshold").setRequiresWorldRestart(true);
        clumpingThreshold = prop.getInt(64);
        if (clumpingThreshold > 1024 || clumpingThreshold < 64) {
            clumpingThreshold = 64;
            prop.set(64);
        }
        propOrder.add(prop.getName());
        prop = config.get("general", "sortRecipies", true);
        prop.comment = "Set to true to enable the post initialization sorting of crafting recipes using Forge's sorter. May cause desyncing on conflicting recipies. MUST RESTART MINECRAFT IF CHANGED FROM THE CONFIG GUI.";
        prop.setLanguageKey("forge.configgui.sortRecipies").setRequiresMcRestart(true);
        shouldSortRecipies = prop.getBoolean(shouldSortRecipies);
        propOrder.add(prop.getName());
        prop = config.get("general", "removeErroringEntities", false);
        prop.comment = "Set this to true to remove any Entity that throws an error in its update method instead of closing the server and reporting a crash log. BE WARNED THIS COULD SCREW UP EVERYTHING USE SPARINGLY WE ARE NOT RESPONSIBLE FOR DAMAGES.";
        prop.setLanguageKey("forge.configgui.removeErroringEntities").setRequiresWorldRestart(true);
        removeErroringEntities = prop.getBoolean(false);
        propOrder.add(prop.getName());
        if (removeErroringEntities) {
            FMLLog.warning("Enabling removal of erroring Entities - USE AT YOUR OWN RISK", new Object[0]);
        }
        prop = config.get("general", "removeErroringTileEntities", false);
        prop.comment = "Set this to true to remove any TileEntity that throws an error in its update method instead of closing the server and reporting a crash log. BE WARNED THIS COULD SCREW UP EVERYTHING USE SPARINGLY WE ARE NOT RESPONSIBLE FOR DAMAGES.";
        prop.setLanguageKey("forge.configgui.removeErroringTileEntities").setRequiresWorldRestart(true);
        removeErroringTileEntities = prop.getBoolean(false);
        propOrder.add(prop.getName());
        if (removeErroringTileEntities) {
            FMLLog.warning("Enabling removal of erroring Tile Entities - USE AT YOUR OWN RISK", new Object[0]);
        }
        prop = config.get("general", "fullBoundingBoxLadders", false);
        prop.comment = "Set this to true to check the entire entity's collision bounding box for ladders instead of just the block they are in. Causes noticable differences in mechanics so default is vanilla behavior. Default: false";
        prop.setLanguageKey("forge.configgui.fullBoundingBoxLadders").setRequiresWorldRestart(true);
        fullBoundingBoxLadders = prop.getBoolean(false);
        propOrder.add(prop.getName());
        prop = config.get("general", "biomeSkyBlendRange", new int[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34});
        prop.comment = "Control the range of sky blending for colored skies in biomes.";
        prop.setLanguageKey("forge.configgui.biomeSkyBlendRange");
        blendRanges = prop.getIntList();
        propOrder.add(prop.getName());
        prop = config.get("general", "zombieBaseSummonChance", 0.1, "Base zombie summoning spawn chance. Allows changing the bonus zombie summoning mechanic.", 0.0, 1.0);
        prop.setLanguageKey("forge.configgui.zombieBaseSummonChance").setRequiresWorldRestart(true);
        zombieSummonBaseChance = prop.getDouble(0.1);
        propOrder.add(prop.getName());
        prop = config.get("general", "zombieBabyChance", 0.05, "Chance that a zombie (or subclass) is a baby. Allows changing the zombie spawning mechanic.", 0.0, 1.0);
        prop.setLanguageKey("forge.configgui.zombieBabyChance").setRequiresWorldRestart(true);
        zombieBabyChance = (float)prop.getDouble(0.05);
        propOrder.add(prop.getName());
        prop = config.get("general", "defaultSpawnFuzz", 20, "The spawn fuzz when a player respawns in the world, this is controlable by WorldType, this config option is for the default overworld.", 1, Integer.MAX_VALUE);
        prop.setLanguageKey("forge.configgui.spawnfuzz").setRequiresWorldRestart(false);
        defaultSpawnFuzz = prop.getInt(20);
        propOrder.add(prop.getName());
        prop = config.get("general", "spawnHasFuzz", Boolean.TRUE, "If the overworld has ANY spawn fuzz at all. If not, the spawn will always be the exact same location.");
        prop.setLanguageKey("forge.configgui.hasspawnfuzz").setRequiresWorldRestart(false);
        defaultHasSpawnFuzz = prop.getBoolean(Boolean.TRUE);
        propOrder.add(prop.getName());
        config.setCategoryPropertyOrder("general", propOrder);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (this.getMetadata().modId.equals(event.modID) && !event.isWorldRunning) {
            if ("general".equals(event.configID)) {
                ForgeModContainer.syncConfig(false);
            } else if ("chunkLoader".equals(event.configID)) {
                ForgeChunkManager.syncConfigDefaults();
                ForgeChunkManager.loadConfiguration();
            }
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        UsernameCache.setUsername(event.player.bJ().getId(), event.player.bJ().getName());
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), "*", evt.getASMHarvestedData());
        ForgeNetworkHandler.registerChannel(this, evt.getSide());
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register(MinecraftForge.INTERNAL_HANDLER);
        ForgeChunkManager.captureConfig(evt.getModConfigurationDirectory());
        FMLCommonHandler.instance().bus().register(this);
        if (!disableVersionCheck) {
            ForgeVersion.startVersionCheck();
        }
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent evt) {
        BiomeDictionary.registerAllBiomesAndGenerateEvents();
        ForgeChunkManager.loadConfiguration();
    }

    @Subscribe
    public void onAvailable(FMLLoadCompleteEvent evt) {
        if (shouldSortRecipies) {
            RecipeSorter.sortCraftManager();
        }
        FluidRegistry.validateFluidRegistry();
    }

    @Subscribe
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((aa)new ForgeCommand(evt.getServer()));
    }

    @Override
    public dh getDataForWriting(ayq handler, ays info) {
        dh forgeData = new dh();
        dh dimData = DimensionManager.saveDimensionDataMap();
        forgeData.a("DimensionData", (dy)dimData);
        FluidRegistry.writeDefaultFluidList(forgeData);
        return forgeData;
    }

    @Override
    public void readData(ayq handler, ays info, Map<String, dy> propertyMap, dh tag) {
        DimensionManager.loadDimensionDataMap(tag.c("DimensionData") ? tag.m("DimensionData") : null);
        FluidRegistry.loadFluidDefaults(tag);
    }

    @Subscribe
    public void mappingChanged(FMLModIdMappingEvent evt) {
        ajn.ab.rebuildFireInfo();
        OreDictionary.rebakeMap();
    }

    @Override
    public File getSource() {
        return FMLForgePlugin.forgeLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        if (this.getSource().isDirectory()) {
            return FMLFolderResourcePack.class;
        }
        return FMLFileResourcePack.class;
    }

    @Override
    public List<String> getOwnedPackages() {
        return ImmutableList.of((Object)"net.minecraftforge.classloading", (Object)"net.minecraftforge.client", (Object)"net.minecraftforge.client.event", (Object)"net.minecraftforge.client.event.sound", (Object)"net.minecraftforge.client.model", (Object)"net.minecraftforge.client.model.obj", (Object)"net.minecraftforge.client.model.techne", (Object)"net.minecraftforge.common", (Object)"net.minecraftforge.common.config", (Object)"net.minecraftforge.common.network", (Object)"net.minecraftforge.common.util", (Object)"net.minecraftforge.event", (Object[])new String[]{"net.minecraftforge.event.brewing", "net.minecraftforge.event.entity", "net.minecraftforge.event.entity.item", "net.minecraftforge.event.entity.living", "net.minecraftforge.event.entity.minecart", "net.minecraftforge.event.entity.player", "net.minecraftforge.event.terraingen", "net.minecraftforge.event.world", "net.minecraftforge.fluids", "net.minecraftforge.oredict", "net.minecraftforge.server", "net.minecraftforge.server.command", "net.minecraftforge.transformers"});
    }
}

