/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.IdentityHashMap;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;

public class MinecraftForgeClient {
    private static IdentityHashMap<alq, IItemRenderer> customItemRenderers = Maps.newIdentityHashMap();
    private static BitSet stencilBits = new BitSet(8);

    public static void registerItemRenderer(alq item, IItemRenderer renderer) {
        customItemRenderers.put(item, renderer);
    }

    public static IItemRenderer getItemRenderer(amj item, IItemRenderer.ItemRenderType type) {
        IItemRenderer renderer = customItemRenderers.get(item.b());
        if (renderer != null && renderer.handleRenderType(item, type)) {
            return renderer;
        }
        return null;
    }

    public static int getRenderPass() {
        return ForgeHooksClient.renderPass;
    }

    public static aql getRenderLayer() {
        return ForgeHooksClient.renderLayer;
    }

    public static int reserveStencilBit() {
        int bit = stencilBits.nextSetBit(0);
        if (bit >= 0) {
            stencilBits.clear(bit);
        }
        return bit;
    }

    public static void releaseStencilBit(int bit) {
        if (bit >= 0 && bit < stencilBits.length()) {
            stencilBits.set(bit);
        }
    }

    static {
        stencilBits.set(0, 8);
    }
}

