/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.terraingen.DeferredBiomeDecorator;
import net.minecraftforge.fml.common.FMLLog;

public class BiomeDictionary {
    private static final int BIOME_LIST_SIZE = arm.n().length;
    private static BiomeInfo[] biomeList = new BiomeInfo[BIOME_LIST_SIZE];
    private static ArrayList<arm>[] typeInfoList = new ArrayList[Type.values().length];

    public static boolean registerBiomeType(arm biome, Type ... types) {
        types = BiomeDictionary.listSubTags(types);
        if (arm.n()[biome.az] != null) {
            for (Type type : types) {
                if (typeInfoList[type.ordinal()] == null) {
                    BiomeDictionary.typeInfoList[type.ordinal()] = new ArrayList();
                }
                typeInfoList[type.ordinal()].add(biome);
            }
            if (biomeList[biome.az] == null) {
                BiomeDictionary.biomeList[biome.az] = new BiomeInfo(types);
            } else {
                for (Type type : types) {
                    BiomeDictionary.biomeList[biome.az].typeList.add(type);
                }
            }
            return true;
        }
        return false;
    }

    public static arm[] getBiomesForType(Type type) {
        if (typeInfoList[type.ordinal()] != null) {
            return typeInfoList[type.ordinal()].toArray(new arm[0]);
        }
        return new arm[0];
    }

    public static Type[] getTypesForBiome(arm biome) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.az] != null) {
            return BiomeDictionary.biomeList[biome.az].typeList.toArray(new Type[0]);
        }
        return new Type[0];
    }

    public static boolean areBiomesEquivalent(arm biomeA, arm biomeB) {
        int a2 = biomeA.az;
        int b = biomeB.az;
        BiomeDictionary.checkRegistration(biomeA);
        BiomeDictionary.checkRegistration(biomeB);
        if (biomeList[a2] != null && biomeList[b] != null) {
            for (Type type : BiomeDictionary.biomeList[a2].typeList) {
                if (!BiomeDictionary.containsType(biomeList[b], type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBiomeOfType(arm biome, Type type) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.az] != null) {
            return BiomeDictionary.containsType(biomeList[biome.az], type);
        }
        return false;
    }

    public static boolean isBiomeRegistered(arm biome) {
        return biomeList[biome.az] != null;
    }

    public static boolean isBiomeRegistered(int biomeID) {
        return biomeList[biomeID] != null;
    }

    public static void registerAllBiomes() {
        FMLLog.warning("Redundant call to BiomeDictionary.registerAllBiomes ignored", new Object[0]);
    }

    public static void registerAllBiomesAndGenerateEvents() {
        for (int i = 0; i < arm.n().length; ++i) {
            arm biome = arm.n()[i];
            if (biome == null) continue;
            if (biome.as instanceof DeferredBiomeDecorator) {
                DeferredBiomeDecorator decorator = (DeferredBiomeDecorator)biome.as;
                decorator.fireCreateEventAndReplace(biome);
            }
            BiomeDictionary.checkRegistration(biome);
        }
    }

    public static void makeBestGuess(arm biome) {
        if (biome.as.A >= 3) {
            if (biome.f() && biome.ap >= 0.9f) {
                BiomeDictionary.registerBiomeType(biome, Type.JUNGLE);
            } else if (!biome.f()) {
                BiomeDictionary.registerBiomeType(biome, Type.FOREST);
                if (biome.ap <= 0.2f) {
                    BiomeDictionary.registerBiomeType(biome, Type.CONIFEROUS);
                }
            }
        } else if (biome.ao <= 0.3f && biome.ao >= 0.0f && (!biome.f() || biome.an >= 0.0f)) {
            BiomeDictionary.registerBiomeType(biome, Type.PLAINS);
        }
        if (biome.aq > 0.85f) {
            BiomeDictionary.registerBiomeType(biome, Type.WET);
        }
        if (biome.aq < 0.15f) {
            BiomeDictionary.registerBiomeType(biome, Type.DRY);
        }
        if (biome.ap > 0.85f) {
            BiomeDictionary.registerBiomeType(biome, Type.HOT);
        }
        if (biome.ap < 0.15f) {
            BiomeDictionary.registerBiomeType(biome, Type.COLD);
        }
        if (biome.as.A > 0 && biome.as.A < 3) {
            BiomeDictionary.registerBiomeType(biome, Type.SPARSE);
        } else if (biome.as.A >= 10) {
            BiomeDictionary.registerBiomeType(biome, Type.DENSE);
        }
        if (biome.f() && biome.an < 0.0f && biome.ao <= 0.3f && biome.ao >= 0.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.SWAMP);
        }
        if (biome.an <= -0.5f) {
            if (biome.ao == 0.0f) {
                BiomeDictionary.registerBiomeType(biome, Type.RIVER);
            } else {
                BiomeDictionary.registerBiomeType(biome, Type.OCEAN);
            }
        }
        if (biome.ao >= 0.4f && biome.ao < 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.HILLS);
        }
        if (biome.ao >= 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.MOUNTAIN);
        }
        if (biome.d()) {
            BiomeDictionary.registerBiomeType(biome, Type.SNOWY);
        }
        if (biome.ak != aty.m && biome.ap >= 1.0f && biome.aq < 0.2f) {
            BiomeDictionary.registerBiomeType(biome, Type.SAVANNA);
        }
        if (biome.ak == aty.m) {
            BiomeDictionary.registerBiomeType(biome, Type.SANDY);
        } else if (biome.ak == aty.cz) {
            BiomeDictionary.registerBiomeType(biome, Type.MESA);
        } else if (biome.ak == aty.bw) {
            BiomeDictionary.registerBiomeType(biome, Type.MUSHROOM);
        }
    }

    private static void checkRegistration(arm biome) {
        if (!BiomeDictionary.isBiomeRegistered(biome)) {
            BiomeDictionary.makeBestGuess(biome);
        }
    }

    private static boolean containsType(BiomeInfo info, Type type) {
        if (type.hasSubTags()) {
            for (Type remappedType : BiomeDictionary.listSubTags(type)) {
                if (!info.typeList.contains((Object)remappedType)) continue;
                return true;
            }
            return false;
        }
        return info.typeList.contains((Object)type);
    }

    private static Type[] listSubTags(Type ... types) {
        ArrayList<Type> subTags = new ArrayList<Type>();
        for (Type type : types) {
            if (type.hasSubTags()) {
                subTags.addAll(type.subTags);
                continue;
            }
            subTags.add(type);
        }
        return subTags.toArray(new Type[subTags.size()]);
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.registerBiomeType(arm.p, Type.OCEAN);
        BiomeDictionary.registerBiomeType(arm.q, Type.PLAINS);
        BiomeDictionary.registerBiomeType(arm.r, Type.HOT, Type.DRY, Type.SANDY);
        BiomeDictionary.registerBiomeType(arm.s, Type.MOUNTAIN, Type.HILLS);
        BiomeDictionary.registerBiomeType(arm.t, Type.FOREST);
        BiomeDictionary.registerBiomeType(arm.u, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.registerBiomeType(arm.I, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(arm.v, Type.WET, Type.SWAMP);
        BiomeDictionary.registerBiomeType(arm.w, Type.RIVER);
        BiomeDictionary.registerBiomeType(arm.z, Type.COLD, Type.OCEAN, Type.SNOWY);
        BiomeDictionary.registerBiomeType(arm.A, Type.COLD, Type.RIVER, Type.SNOWY);
        BiomeDictionary.registerBiomeType(arm.B, Type.COLD, Type.SNOWY, Type.WASTELAND);
        BiomeDictionary.registerBiomeType(arm.C, Type.COLD, Type.SNOWY, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(arm.F, Type.BEACH);
        BiomeDictionary.registerBiomeType(arm.G, Type.HOT, Type.DRY, Type.SANDY, Type.HILLS);
        BiomeDictionary.registerBiomeType(arm.K, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(arm.L, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.HILLS);
        BiomeDictionary.registerBiomeType(arm.H, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(arm.y, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.registerBiomeType(arm.x, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.registerBiomeType(arm.D, Type.MUSHROOM);
        BiomeDictionary.registerBiomeType(arm.J, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(arm.E, Type.MUSHROOM, Type.BEACH);
        BiomeDictionary.registerBiomeType(arm.M, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST);
        BiomeDictionary.registerBiomeType(arm.N, Type.OCEAN);
        BiomeDictionary.registerBiomeType(arm.O, Type.BEACH);
        BiomeDictionary.registerBiomeType(arm.P, Type.COLD, Type.BEACH, Type.SNOWY);
        BiomeDictionary.registerBiomeType(arm.Q, Type.FOREST);
        BiomeDictionary.registerBiomeType(arm.R, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(arm.S, Type.SPOOKY, Type.DENSE, Type.FOREST);
        BiomeDictionary.registerBiomeType(arm.T, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY);
        BiomeDictionary.registerBiomeType(arm.U, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.HILLS);
        BiomeDictionary.registerBiomeType(arm.V, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.registerBiomeType(arm.W, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(arm.X, Type.MOUNTAIN, Type.FOREST, Type.SPARSE);
        BiomeDictionary.registerBiomeType(arm.Y, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.registerBiomeType(arm.Z, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.registerBiomeType(arm.aa, Type.MESA, Type.SANDY);
        BiomeDictionary.registerBiomeType(arm.ab, Type.MESA, Type.SPARSE, Type.SANDY);
        BiomeDictionary.registerBiomeType(arm.ac, Type.MESA, Type.SANDY);
    }

    static /* synthetic */ ArrayList[] access$002(ArrayList[] x0) {
        typeInfoList = x0;
        return x0;
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        public EnumSet<Type> typeList = EnumSet.noneOf(Type.class);

        public BiomeInfo(Type[] types) {
            for (Type t : types) {
                this.typeList.add(t);
            }
        }
    }

    public static enum Type {
        HOT(new Type[0]),
        COLD(new Type[0]),
        SPARSE(new Type[0]),
        DENSE(new Type[0]),
        WET(new Type[0]),
        DRY(new Type[0]),
        SAVANNA(new Type[0]),
        CONIFEROUS(new Type[0]),
        JUNGLE(new Type[0]),
        SPOOKY(new Type[0]),
        DEAD(new Type[0]),
        LUSH(new Type[0]),
        NETHER(new Type[0]),
        END(new Type[0]),
        MUSHROOM(new Type[0]),
        MAGICAL(new Type[0]),
        OCEAN(new Type[0]),
        RIVER(new Type[0]),
        WATER(OCEAN, RIVER),
        MESA(new Type[0]),
        FOREST(new Type[0]),
        PLAINS(new Type[0]),
        MOUNTAIN(new Type[0]),
        HILLS(new Type[0]),
        SWAMP(new Type[0]),
        SANDY(new Type[0]),
        SNOWY(new Type[0]),
        WASTELAND(new Type[0]),
        BEACH(new Type[0]),
        DESERT(SANDY),
        FROZEN(SNOWY);

        private List<Type> subTags;

        private Type(Type ... subTags) {
            this.subTags = Arrays.asList(subTags);
        }

        private boolean hasSubTags() {
            return this.subTags != null && !this.subTags.isEmpty();
        }

        public static Type getType(String name, Type ... subTypes) {
            name = name.toUpperCase();
            for (Type t : Type.values()) {
                if (!t.name().equals(name)) continue;
                return t;
            }
            Type ret = EnumHelper.addEnum(Type.class, name, new Class[]{Type[].class}, new Object[]{subTypes});
            if (ret.ordinal() >= typeInfoList.length) {
                BiomeDictionary.access$002(Arrays.copyOf(typeInfoList, ret.ordinal()));
            }
            return ret;
        }
    }
}

