/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;

public class Fluid {
    protected final String fluidName;
    protected String unlocalizedName;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int temperature = 295;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected amx rarity = amx.a;
    protected atr block = null;
    private static Map<String, String> legacyNames = Maps.newHashMap();

    public Fluid(String fluidName) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlock(atr block) {
        if (this.block == null || this.block == block) {
            this.block = block;
        } else if (!ForgeModContainer.forceDuplicateFluidBlockCrash) {
            FMLLog.warning("A mod has attempted to assign Block " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.block + ". Configure your mods to prevent this from happening.", new Object[0]);
        } else {
            FMLLog.severe("A mod has attempted to assign BlockID " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.block + ". Configure your mods to prevent this from happening.", new Object[0]);
            throw new LoaderException(new RuntimeException("A mod has attempted to assign BlockID " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.block + ". Configure your mods to prevent this from happening."));
        }
        return this;
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public Fluid setRarity(amx rarity) {
        this.rarity = rarity;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final int getID() {
        return FluidRegistry.getFluidID(this.fluidName);
    }

    public final atr getBlock() {
        return this.block;
    }

    public final boolean canBePlacedInWorld() {
        return this.block != null;
    }

    public String getLocalizedName(FluidStack stack) {
        return this.getLocalizedName();
    }

    @Deprecated
    public String getLocalizedName() {
        String s = this.getUnlocalizedName();
        return s == null ? "" : fi.a((String)s);
    }

    public String getUnlocalizedName(FluidStack stack) {
        return this.getUnlocalizedName();
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getSpriteNumber() {
        return 0;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public amx getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public amx getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public int getLuminosity(aqu world, dt pos) {
        return this.getLuminosity();
    }

    public int getDensity(aqu world, dt pos) {
        return this.getDensity();
    }

    public int getTemperature(aqu world, dt pos) {
        return this.getTemperature();
    }

    public int getViscosity(aqu world, dt pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(aqu world, dt pos) {
        return this.isGaseous();
    }

    public amx getRarity(aqu world, dt pos) {
        return this.getRarity();
    }

    public int getColor(aqu world, dt pos) {
        return this.getColor();
    }

    static String convertLegacyName(String fluidName) {
        return fluidName != null && legacyNames.containsKey(fluidName) ? legacyNames.get(fluidName) : fluidName;
    }

    public static void registerLegacyName(String legacyName, String canonicalName) {
        legacyNames.put(legacyName.toLowerCase(Locale.ENGLISH), canonicalName);
    }
}

