/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class FluidRegistry {
    static int maxID = 0;
    static HashMap<String, Fluid> fluids = Maps.newHashMap();
    static BiMap<String, Integer> fluidIDs = HashBiMap.create();
    static BiMap<atr, Fluid> fluidBlocks;
    public static final Fluid WATER;
    public static final Fluid LAVA;
    public static int renderIdFluid;

    private FluidRegistry() {
    }

    public static void initFluidIDs(BiMap<String, Integer> newfluidIDs) {
        maxID = newfluidIDs.size();
        fluidIDs.clear();
        fluidIDs.putAll(newfluidIDs);
    }

    public static boolean registerFluid(Fluid fluid) {
        if (fluidIDs.containsKey((Object)fluid.getName())) {
            return false;
        }
        fluids.put(fluid.getName(), fluid);
        fluidIDs.put((Object)fluid.getName(), (Object)(++maxID));
        MinecraftForge.EVENT_BUS.post(new FluidRegisterEvent(fluid.getName(), maxID));
        return true;
    }

    public static boolean isFluidRegistered(Fluid fluid) {
        return fluidIDs.containsKey((Object)fluid.getName());
    }

    public static boolean isFluidRegistered(String fluidName) {
        return fluidIDs.containsKey((Object)fluidName);
    }

    public static Fluid getFluid(String fluidName) {
        return fluids.get(fluidName);
    }

    public static Fluid getFluid(int fluidID) {
        return fluids.get(FluidRegistry.getFluidName(fluidID));
    }

    public static String getFluidName(int fluidID) {
        return (String)fluidIDs.inverse().get((Object)fluidID);
    }

    public static String getFluidName(FluidStack stack) {
        return FluidRegistry.getFluidName(stack.fluidID);
    }

    public static int getFluidID(String fluidName) {
        return (Integer)fluidIDs.get((Object)fluidName);
    }

    public static FluidStack getFluidStack(String fluidName, int amount) {
        if (!fluidIDs.containsKey((Object)fluidName)) {
            return null;
        }
        return new FluidStack(FluidRegistry.getFluidID(fluidName), amount);
    }

    public static Map<String, Fluid> getRegisteredFluids() {
        return ImmutableMap.copyOf(fluids);
    }

    public static Map<String, Integer> getRegisteredFluidIDs() {
        return ImmutableMap.copyOf(fluidIDs);
    }

    public static Fluid lookupFluidForBlock(atr block) {
        if (fluidBlocks == null) {
            HashBiMap tmp = HashBiMap.create();
            for (Fluid fluid : fluids.values()) {
                if (!fluid.canBePlacedInWorld() || fluid.getBlock() == null) continue;
                tmp.put((Object)fluid.getBlock(), (Object)fluid);
            }
            fluidBlocks = tmp;
        }
        return (Fluid)fluidBlocks.get((Object)block);
    }

    public static int getMaxID() {
        return maxID;
    }

    static {
        WATER = new Fluid("water"){

            @Override
            public String getLocalizedName() {
                return fi.a((String)"tile.water.name");
            }
        }.setBlock((atr)aty.j).setUnlocalizedName(aty.j.a());
        LAVA = new Fluid("lava"){

            @Override
            public String getLocalizedName() {
                return fi.a((String)"tile.lava.name");
            }
        }.setBlock((atr)aty.l).setLuminosity(15).setDensity(3000).setViscosity(6000).setTemperature(1300).setUnlocalizedName(aty.l.a());
        renderIdFluid = -1;
        FluidRegistry.registerFluid(WATER);
        FluidRegistry.registerFluid(LAVA);
    }

    public static class FluidRegisterEvent
    extends Event {
        public final String fluidName;
        public final int fluidID;

        public FluidRegisterEvent(String fluidName, int fluidID) {
            this.fluidName = fluidName;
            this.fluidID = fluidID;
        }
    }
}

