/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.eventhandler;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.ListenerList;

public class Event {
    private boolean isCanceled = false;
    private final boolean isCancelable;
    private Result result = Result.DEFAULT;
    private final boolean hasResult;
    private static ListenerList listeners = new ListenerList();
    private EventPriority phase = null;
    private static final Map<Class<?>, Map<Class<?>, Boolean>> annotationMap = new ConcurrentHashMap();

    public Event() {
        this.setup();
        this.isCancelable = this.hasAnnotation(Cancelable.class);
        this.hasResult = this.hasAnnotation(HasResult.class);
    }

    private boolean hasAnnotation(Class<? extends Annotation> annotation) {
        Boolean cached;
        Class<?> me = this.getClass();
        Map<Class<?>, Boolean> list = annotationMap.get(me);
        if (list == null) {
            list = new ConcurrentHashMap();
            annotationMap.put(me, list);
        }
        if ((cached = list.get(annotation)) != null) {
            return cached;
        }
        for (Class<?> cls = me; cls != Event.class; cls = cls.getSuperclass()) {
            if (!cls.isAnnotationPresent(annotation)) continue;
            list.put(annotation, true);
            return true;
        }
        list.put(annotation, false);
        return false;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean cancel) {
        if (!this.isCancelable()) {
            throw new IllegalArgumentException("Attempted to cancel a uncancelable event");
        }
        this.isCanceled = cancel;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result value) {
        this.result = value;
    }

    protected void setup() {
    }

    public ListenerList getListenerList() {
        return listeners;
    }

    @Nullable
    public EventPriority getPhase() {
        return this.phase;
    }

    public void setPhase(@Nonnull EventPriority value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"setPhase argument must not be null");
        int prev = this.phase == null ? -1 : this.phase.ordinal();
        Preconditions.checkArgument((prev < value.ordinal() ? 1 : 0) != 0, (String)"Attempted to set event phase to %s when already %s", (Object[])new Object[]{value, this.phase});
        this.phase = value;
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HasResult {
    }
}

