/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.eventhandler;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.MapMaker;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.ASMEventHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventExceptionHandler;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.ListenerList;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class EventBus
implements IEventExceptionHandler {
    private static int maxID = 0;
    private ConcurrentHashMap<Object, ArrayList<IEventListener>> listeners = new ConcurrentHashMap();
    private Map<Object, ModContainer> listenerOwners = new MapMaker().weakKeys().weakValues().makeMap();
    private final int busID = maxID++;
    private IEventExceptionHandler exceptionHandler;

    public EventBus() {
        ListenerList.resize(this.busID + 1);
        this.exceptionHandler = this;
    }

    public EventBus(@Nonnull IEventExceptionHandler handler) {
        this();
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"EventBus exception handler can not be null");
        this.exceptionHandler = handler;
    }

    public void register(Object target) {
        if (this.listeners.containsKey(target)) {
            return;
        }
        ModContainer activeModContainer = Loader.instance().activeModContainer();
        if (activeModContainer == null) {
            FMLLog.log(Level.ERROR, new Throwable(), "Unable to determine registrant mod for %s. This is a critical error and should be impossible", target);
            activeModContainer = Loader.instance().getMinecraftModContainer();
        }
        this.listenerOwners.put(target, activeModContainer);
        Set supers = TypeToken.of(target.getClass()).getTypes().rawTypes();
        block2: for (Method method : target.getClass().getMethods()) {
            for (Class cls : supers) {
                try {
                    Method real = cls.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    if (!real.isAnnotationPresent(SubscribeEvent.class)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1) {
                        throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but requires " + parameterTypes.length + " arguments.  Event handler methods must require a single argument.");
                    }
                    Class<?> eventType = parameterTypes[0];
                    if (!Event.class.isAssignableFrom(eventType)) {
                        throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes a argument that is not an Event " + eventType);
                    }
                    this.register(eventType, target, method, activeModContainer);
                    continue block2;
                }
                catch (NoSuchMethodException e) {
                }
            }
        }
    }

    private void register(Class<?> eventType, Object target, Method method, ModContainer owner) {
        try {
            Constructor<?> ctr = eventType.getConstructor(new Class[0]);
            ctr.setAccessible(true);
            Event event = (Event)ctr.newInstance(new Object[0]);
            ASMEventHandler listener = new ASMEventHandler(target, method, owner);
            event.getListenerList().register(this.busID, listener.getPriority(), listener);
            ArrayList<IEventListener> others = this.listeners.get(target);
            if (others == null) {
                others = new ArrayList();
                this.listeners.put(target, others);
            }
            others.add(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregister(Object object) {
        ArrayList<IEventListener> list = this.listeners.remove(object);
        for (IEventListener listener : list) {
            ListenerList.unregisterAll(this.busID, listener);
        }
    }

    public boolean post(Event event) {
        int index;
        IEventListener[] listeners = event.getListenerList().getListeners(this.busID);
        try {
            for (index = 0; index < listeners.length; ++index) {
                listeners[index].invoke(event);
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(this, event, listeners, index, throwable);
            Throwables.propagate((Throwable)throwable);
        }
        return event.isCancelable() ? event.isCanceled() : false;
    }

    @Override
    public void handleException(EventBus bus, Event event, IEventListener[] listeners, int index, Throwable throwable) {
        FMLLog.log(Level.ERROR, throwable, "Exception caught during firing event %s:", event);
        FMLLog.log(Level.ERROR, "Index: %d Listeners:", index);
        for (int x2 = 0; x2 < listeners.length; ++x2) {
            FMLLog.log(Level.ERROR, "%d: %s", x2, listeners[x2]);
        }
    }
}

