/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.logging.log4j.Level;

public class PacketLoggingHandler {
    public static void register(gr manager) {
        ChannelPipeline pipeline = manager.channel().pipeline();
        final ie direction = manager.getDirection();
        if (manager.c()) {
            pipeline.addBefore("packet_handler", "splitter", (ChannelHandler)new SimpleChannelInboundHandler<id>(){

                protected void channelRead0(ChannelHandlerContext ctx, id msg) throws Exception {
                    hd buf2 = new hd(Unpooled.buffer());
                    msg.b(buf2);
                    FMLLog.log(Level.DEBUG, "$s $s:\n%s", msg.getClass().getSimpleName(), ByteBufUtils.getContentDump((ByteBuf)buf2));
                    ctx.fireChannelRead((Object)msg);
                }
            });
            pipeline.addBefore("splitter", "prepender", (ChannelHandler)new ChannelOutboundHandlerAdapter(){

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                    if (msg instanceof id) {
                        hd buf2 = new hd(Unpooled.buffer());
                        ((id)msg).b(buf2);
                        FMLLog.log(Level.DEBUG, "$s $s:\n%s", msg.getClass().getSimpleName(), ByteBufUtils.getContentDump((ByteBuf)buf2));
                    }
                    ctx.write(msg, promise);
                }
            });
        } else {
            pipeline.replace("splitter", "splitter", (ChannelHandler)new hh(){
                String prefix;
                {
                    this.prefix = direction == ie.a ? "SERVER: C->S" : "CLIENT: S->C";
                }

                protected void decode(ChannelHandlerContext context, ByteBuf input, List output) {
                    super.decode(context, input, output);
                    for (ByteBuf pkt : output) {
                        pkt.markReaderIndex();
                        FMLLog.log(Level.DEBUG, "%s:\n%s", this.prefix, ByteBufUtils.getContentDump(pkt));
                        pkt.resetReaderIndex();
                    }
                }
            });
            pipeline.replace("prepender", "prepender", (ChannelHandler)new hi(){
                String prefix;
                {
                    this.prefix = direction == ie.a ? "SERVER: S->C" : "CLIENT: C->S";
                }

                protected void a(ChannelHandlerContext context, ByteBuf input, ByteBuf output) {
                    input.markReaderIndex();
                    FMLLog.log(Level.DEBUG, "%s:\n%s", this.prefix, ByteBufUtils.getContentDump(input));
                    input.resetReaderIndex();
                    super.a(context, input, output);
                }
            });
        }
    }
}

