/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.base.Throwables;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import org.apache.logging.log4j.Level;

public class EntitySpawnHandler
extends SimpleChannelInboundHandler<FMLMessage.EntityMessage> {
    protected void channelRead0(ChannelHandlerContext ctx, final FMLMessage.EntityMessage msg) throws Exception {
        vn thread = FMLCommonHandler.instance().getWorldThread((hg)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get());
        if (thread.aH()) {
            this.process(msg);
        } else {
            thread.a(new Runnable(){

                @Override
                public void run() {
                    EntitySpawnHandler.this.process(msg);
                }
            });
        }
    }

    private void process(FMLMessage.EntityMessage msg) {
        if (msg.getClass().equals(FMLMessage.EntitySpawnMessage.class)) {
            this.spawnEntity((FMLMessage.EntitySpawnMessage)msg);
        } else if (msg.getClass().equals(FMLMessage.EntityAdjustMessage.class)) {
            this.adjustEntity((FMLMessage.EntityAdjustMessage)msg);
        }
    }

    private void adjustEntity(FMLMessage.EntityAdjustMessage msg) {
        wv ent = FMLClientHandler.instance().getWorldClient().a(msg.entityId);
        if (ent != null) {
            ent.bU = msg.serverX;
            ent.bV = msg.serverY;
            ent.bW = msg.serverZ;
        } else {
            FMLLog.fine("Attempted to adjust the position of entity %d which is not present on the client", msg.entityId);
        }
    }

    private void spawnEntity(FMLMessage.EntitySpawnMessage spawnMsg) {
        ModContainer mc2 = Loader.instance().getIndexedModList().get(spawnMsg.modId);
        EntityRegistry.EntityRegistration er2 = EntityRegistry.instance().lookupModSpawn(mc2, spawnMsg.modEntityTypeId);
        cen wc = FMLClientHandler.instance().getWorldClient();
        Class<? extends wv> cls = er2.getEntityClass();
        try {
            wv entity;
            if (er2.hasCustomSpawning()) {
                entity = er2.doCustomSpawning(spawnMsg);
            } else {
                wv[] parts;
                entity = cls.getConstructor(aqu.class).newInstance(wc);
                int offset = spawnMsg.entityId - entity.F();
                entity.d(spawnMsg.entityId);
                entity.b(spawnMsg.scaledX, spawnMsg.scaledY, spawnMsg.scaledZ, spawnMsg.scaledYaw, spawnMsg.scaledPitch);
                if (entity instanceof xn) {
                    ((xn)entity).aI = spawnMsg.scaledHeadYaw;
                }
                if ((parts = entity.aC()) != null) {
                    for (int j2 = 0; j2 < parts.length; ++j2) {
                        parts[j2].d(parts[j2].F() + offset);
                    }
                }
            }
            entity.bU = spawnMsg.rawX;
            entity.bV = spawnMsg.rawY;
            entity.bW = spawnMsg.rawZ;
            cio clientPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (entity instanceof IThrowableEntity) {
                cio thrower = clientPlayer.F() == spawnMsg.throwerId ? clientPlayer : wc.a(spawnMsg.throwerId);
                ((IThrowableEntity)entity).setThrower((wv)thrower);
            }
            if (spawnMsg.dataWatcherList != null) {
                entity.H().a(spawnMsg.dataWatcherList);
            }
            if (spawnMsg.throwerId > 0) {
                entity.i(spawnMsg.speedScaledX, spawnMsg.speedScaledY, spawnMsg.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)entity).readSpawnData(spawnMsg.dataStream);
            }
            wc.a(spawnMsg.entityId, entity);
        }
        catch (Exception e) {
            FMLLog.log(Level.ERROR, e, "A severe problem occurred during the spawning of an entity", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log(Level.ERROR, cause, "EntitySpawnHandler exception", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

