/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.MapModelState;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class ModelLoader
extends cxh {
    private final Map<cxl, IModel> stateModels = new HashMap<cxl, IModel>();
    private final Set<oa> textures = new HashSet<oa>();
    private final Set<oa> loadingModels = new HashSet<oa>();
    private final Set<cxl> missingVariants = Sets.newHashSet();
    private boolean isLoading = false;
    private static final Map<RegistryDelegate<atr>, cni> customStateMappers = Maps.newHashMap();
    private static final Map<RegistryDelegate<alq>, ckl> customMeshDefinitions = Maps.newHashMap();
    private static final Map<Pair<RegistryDelegate<alq>, Integer>, cxl> customModels = Maps.newHashMap();

    public boolean isLoading() {
        return this.isLoading;
    }

    public ModelLoader(cvk manager, cua map, clc shapes) {
        super(manager, map, shapes);
        VanillaLoader.instance.setLoader(this);
        ModelLoaderRegistry.clearModelCache();
    }

    public ez a() {
        this.isLoading = true;
        this.loadBlocks();
        this.loadItems();
        this.stateModels.put(a, this.getModel(new oa(a.b(), a.a())));
        this.textures.remove(cua.f);
        this.textures.addAll(b);
        this.j.a(this.f, new cts(){

            public void a(cua map) {
                for (oa t : ModelLoader.this.textures) {
                    ModelLoader.this.g.put(t, map.a(t));
                }
            }
        });
        this.g.put(new oa("missingno"), this.j.f());
        Function textureGetter = Functions.forMap((Map)this.g, (Object)this.j.f());
        for (Map.Entry<cxl, IModel> e : this.stateModels.entrySet()) {
            this.n.a((Object)e.getKey(), (Object)e.getValue().bake(e.getValue().getDefaultState(), Attributes.DEFAULT_BAKED_FORMAT, (Function<oa, cue>)textureGetter));
        }
        return this.n;
    }

    private void loadBlocks() {
        Map stateMap = this.k.a().a();
        ArrayList variants = Lists.newArrayList(stateMap.values());
        variants.add(new cxl("minecraft:item_frame", "normal"));
        variants.add(new cxl("minecraft:item_frame", "map"));
        this.a(variants);
    }

    protected void a(cmh definition, cxl location) {
        cmm variants = null;
        try {
            variants = definition.b(location.c());
        }
        catch (cmj e) {
            this.missingVariants.add(location);
        }
        if (variants != null && !variants.b().isEmpty()) {
            try {
                this.stateModels.put(location, new WeightedRandomModel(variants));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void loadItems() {
        this.e();
        for (alq item : GameData.getItemRegistry().typeSafeIterable()) {
            for (String s : this.a(item)) {
                oa file = this.a(s);
                cxl memory = new cxl(s, "inventory");
                IModel model = this.getModel(file);
                if (model == null || model == this.getMissingModel()) {
                    this.missingVariants.add(memory);
                    continue;
                }
                this.stateModels.put(memory, model);
            }
        }
    }

    public IModel getModel(oa location) {
        if (!ModelLoaderRegistry.loaded(location)) {
            this.loadAnyModel(location);
        }
        return ModelLoaderRegistry.getModel(location);
    }

    protected oa d(oa model) {
        return new oa(model.b(), model.a() + ".json");
    }

    private void loadAnyModel(oa location) {
        if (this.loadingModels.contains(location)) {
            throw new IllegalStateException("circular model dependencies involving model " + location);
        }
        this.loadingModels.add(location);
        IModel model = ModelLoaderRegistry.getModel(location);
        for (oa dep : model.getDependencies()) {
            this.getModel(dep);
        }
        this.textures.addAll(model.getTextures());
        this.loadingModels.remove(location);
    }

    private boolean isBuiltinModel(cmc model) {
        return model == o || model == p || model == q || model == r;
    }

    public IModel getMissingModel() {
        return this.getModel(new oa(a.b(), a.a()));
    }

    public void onPostBakeEvent(ez modelRegistry) {
        for (cxl missing : this.missingVariants) {
            if (modelRegistry.a((Object)missing) != null) continue;
            FMLLog.severe("Model definition for location %s not found", missing);
        }
        this.isLoading = false;
    }

    public static void setCustomStateMapper(atr block, cni mapper) {
        customStateMappers.put(block.delegate, mapper);
    }

    public static void onRegisterAllBlocks(clc shapes) {
        for (Map.Entry<RegistryDelegate<atr>, cni> e : customStateMappers.entrySet()) {
            shapes.a(e.getKey().get(), e.getValue());
        }
    }

    public static void setCustomModelResourceLocation(alq item, int metadata, cxl model) {
        customModels.put((Pair<RegistryDelegate<alq>, Integer>)Pair.of((Object)item.delegate, (Object)metadata), model);
    }

    public static void setCustomMeshDefinition(alq item, ckl meshDefinition) {
        customMeshDefinitions.put(item.delegate, meshDefinition);
    }

    public static void onRegisterItems(ckk mesher) {
        for (Map.Entry<RegistryDelegate<alq>, ckl> entry : customMeshDefinitions.entrySet()) {
            mesher.a(entry.getKey().get(), entry.getValue());
        }
        for (Map.Entry<RegistryDelegate<alq>, ckl> entry : customModels.entrySet()) {
            mesher.a((alq)((RegistryDelegate)((Pair)entry.getKey()).getLeft()).get(), ((Integer)((Pair)entry.getKey()).getRight()).intValue(), (cxl)entry.getValue());
        }
    }

    public static class White
    extends cue {
        public static oa loc = new oa("white");
        public static White instance = new White();

        protected White() {
            super(loc.toString());
        }

        public boolean hasCustomLoader(cvk manager, oa location) {
            return true;
        }

        public boolean load(cvk manager, oa location) {
            BufferedImage image = new BufferedImage(1, 1, 2);
            image.setRGB(0, 0, -1);
            BufferedImage[] images = new BufferedImage[bsu.z().t.I + 1];
            images[0] = image;
            this.a(images, null);
            return false;
        }

        public void register(cua map) {
            map.setTextureEntry(loc.toString(), (cue)instance);
        }
    }

    static enum VanillaLoader implements ICustomModelLoader
    {
        instance;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        ModelLoader getLoader() {
            return this.loader;
        }

        public void a(cvk resourceManager) {
        }

        @Override
        public boolean accepts(oa modelLocation) {
            return true;
        }

        @Override
        public IModel loadModel(oa modelLocation) {
            try {
                ModelLoader modelLoader = this.loader;
                ((Object)((Object)modelLoader)).getClass();
                return modelLoader.new VanillaModelWrapper(modelLocation, this.loader.c(modelLocation));
            }
            catch (IOException e) {
                if (!this.loader.isLoading) {
                    FMLLog.log(Level.ERROR, e, "Exception loading model %s with vanilla loader, skipping", modelLocation);
                }
                return this.loader.getMissingModel();
            }
        }
    }

    private static class FlexibleWeightedBakedModel
    extends cxo
    implements IFlexibleBakedModel {
        private final cxo parent;
        private final cus format;

        public FlexibleWeightedBakedModel(cxo parent, cus format) {
            super(parent.b);
            this.parent = parent;
            this.format = format;
        }

        @Override
        public cus getFormat() {
            return this.format;
        }
    }

    private class WeightedRandomModel
    implements IModel {
        private final List<cmk> variants;
        private final List<oa> locations = new ArrayList<oa>();
        private final List<IModel> models = new ArrayList<IModel>();
        private final IModelState defaultState;

        public WeightedRandomModel(cmm variants) {
            this.variants = variants.b();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (cmk v : variants.b()) {
                oa loc = v.a();
                this.locations.add(loc);
                WeightedPartWrapper model = new WeightedPartWrapper(ModelLoader.this.getModel(loc));
                this.models.add(model);
                builder.put((Object)model, (Object)new TRSRTransformation(v.b()));
            }
            this.defaultState = new MapModelState((Map<IModelPart, TRSRTransformation>)builder.build());
        }

        @Override
        public Collection<oa> getDependencies() {
            return ImmutableList.copyOf(this.locations);
        }

        @Override
        public Collection<oa> getTextures() {
            return Collections.emptyList();
        }

        private IModelState addUV(boolean uv2, IModelState state) {
            if (uv2) {
                return new UVLock(state);
            }
            return state;
        }

        @Override
        public IFlexibleBakedModel bake(IModelState state, cus format, Function<oa, cue> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla weighted models to the format that doesn't fit into the default one: " + format);
            }
            if (this.variants.size() == 1) {
                cmk v = this.variants.get(0);
                IModel model = this.models.get(0);
                return model.bake(this.addUV(v.c(), state.apply(model)), format, bakedTextureGetter);
            }
            cxp builder = new cxp();
            for (int i = 0; i < this.variants.size(); ++i) {
                IModel model = this.models.get(i);
                cmk v = this.variants.get(i);
                builder.a((cxe)model.bake(this.addUV(v.c(), state.apply(model)), format, bakedTextureGetter), this.variants.get(i).d());
            }
            return new FlexibleWeightedBakedModel(builder.a(), Attributes.DEFAULT_BAKED_FORMAT);
        }

        @Override
        public IModelState getDefaultState() {
            return this.defaultState;
        }
    }

    private static class WeightedPartWrapper
    implements IModel {
        private final IModel model;

        public WeightedPartWrapper(IModel model) {
            this.model = model;
        }

        @Override
        public Collection<oa> getDependencies() {
            return this.model.getDependencies();
        }

        @Override
        public Collection<oa> getTextures() {
            return this.model.getTextures();
        }

        @Override
        public IFlexibleBakedModel bake(IModelState state, cus format, Function<oa, cue> bakedTextureGetter) {
            return this.model.bake(state, format, bakedTextureGetter);
        }

        @Override
        public IModelState getDefaultState() {
            return this.model.getDefaultState();
        }
    }

    public static class UVLock
    implements IModelState {
        private final IModelState state;

        public UVLock(IModelState state) {
            this.state = state;
        }

        @Override
        public TRSRTransformation apply(IModelPart part) {
            return this.state.apply(part);
        }
    }

    private class VanillaModelWrapper
    implements IModel {
        private final oa location;
        private final cmc model;

        public VanillaModelWrapper(oa location, cmc model) {
            this.location = location;
            this.model = model;
        }

        @Override
        public Collection<oa> getDependencies() {
            if (this.model.e() == null || this.model.e().a().startsWith("builtin/")) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.model.e());
        }

        @Override
        public Collection<oa> getTextures() {
            if (this.model.e() != null) {
                IModel parent = ModelLoader.this.getModel(this.model.e());
                if (parent instanceof VanillaModelWrapper) {
                    this.model.d = ((VanillaModelWrapper)parent).model;
                } else {
                    throw new IllegalStateException("vanilla model" + this.model + "can't have non-vanilla parent");
                }
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ModelLoader.this.b(this.model)) {
                for (String s : cmr.a) {
                    String r = this.model.c(s);
                    oa loc = new oa(r);
                    if (!r.equals(s)) {
                        builder.add((Object)loc);
                    }
                    if (this.model.f() == p && !loc.equals((Object)cua.f)) {
                        cue.b((String)loc.toString());
                        continue;
                    }
                    if (this.model.f() != q || loc.equals((Object)cua.f)) continue;
                    cue.a((String)loc.toString());
                }
            }
            for (String s : this.model.c.values()) {
                if (s.startsWith("#")) continue;
                builder.add((Object)new oa(s));
            }
            return builder.build();
        }

        @Override
        public IFlexibleBakedModel bake(IModelState state, cus format, Function<oa, cue> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
            }
            cmc model = this.model;
            if (ModelLoader.this.b(model)) {
                model = ModelLoader.this.d(model);
            }
            if (ModelLoader.this.c(model)) {
                return new IFlexibleBakedModel.Wrapper((cxe)new cxg(new cmx(model.g(), model.h(), model.i(), model.j())), Attributes.DEFAULT_BAKED_FORMAT);
            }
            return new IFlexibleBakedModel.Wrapper(ModelLoader.this.bakeModel(model, state.apply(this), state instanceof UVLock), Attributes.DEFAULT_BAKED_FORMAT);
        }

        @Override
        public IModelState getDefaultState() {
            return cxf.a;
        }
    }
}

