/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class MultiModel
implements IModel {
    protected final jy location;
    protected final IModel base;
    protected final IModelState baseState;
    protected final Map<String, Pair<IModel, IModelState>> parts;

    public MultiModel(jy location, IModel base, IModelState baseState, ImmutableMap<String, Pair<IModel, IModelState>> parts) {
        this.location = location;
        this.base = base;
        this.baseState = baseState;
        this.parts = parts;
    }

    public MultiModel(IModel base, IModelState baseState, ImmutableMap<String, Pair<IModel, IModelState>> parts) {
        this(null, base, baseState, parts);
    }

    public MultiModel(IModel base, IModelState baseState, Map<String, Pair<IModel, IModelState>> parts) {
        this(null, base, baseState, (ImmutableMap<String, Pair<IModel, IModelState>>)ImmutableMap.copyOf(parts));
    }

    public MultiModel(jy location, IModel base, IModelState baseState, Map<String, Pair<IModel, IModelState>> parts) {
        this(location, base, baseState, (ImmutableMap<String, Pair<IModel, IModelState>>)ImmutableMap.copyOf(parts));
    }

    @Override
    public Collection<jy> getDependencies() {
        HashSet deps = Sets.newHashSet();
        if (this.base != null) {
            deps.addAll(this.base.getDependencies());
        }
        for (Pair<IModel, IModelState> pair : this.parts.values()) {
            deps.addAll(((IModel)pair.getLeft()).getDependencies());
        }
        return deps;
    }

    @Override
    public Collection<jy> getTextures() {
        HashSet deps = Sets.newHashSet();
        if (this.base != null) {
            deps.addAll(this.base.getTextures());
        }
        for (Pair<IModel, IModelState> pair : this.parts.values()) {
            deps.addAll(((IModel)pair.getLeft()).getTextures());
        }
        return deps;
    }

    @Override
    public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
        IFlexibleBakedModel bakedBase = null;
        if (this.base != null) {
            bakedBase = this.base.bake(state, format, bakedTextureGetter);
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Pair<IModel, IModelState>> entry : this.parts.entrySet()) {
            Pair<IModel, IModelState> pair = entry.getValue();
            mapBuilder.put((Object)entry.getKey(), (Object)((IModel)pair.getLeft()).bake((IModelState)pair.getRight(), format, bakedTextureGetter));
        }
        if (bakedBase == null && this.parts.isEmpty()) {
            FMLLog.log(Level.ERROR, "MultiModel %s is empty (no base model or parts were provided/resolved)", this.location);
            IModel missing = ModelLoaderRegistry.getMissingModel();
            return missing.bake(missing.getDefaultState(), format, bakedTextureGetter);
        }
        return new Baked(this.location, true, bakedBase, (ImmutableMap<String, IFlexibleBakedModel>)mapBuilder.build());
    }

    @Override
    public IModelState getDefaultState() {
        return this.baseState;
    }

    public IModel getBaseModel() {
        return this.base;
    }

    public Map<String, Pair<IModel, IModelState>> getParts() {
        return this.parts;
    }

    public static class Baked
    implements IFlexibleBakedModel,
    IPerspectiveAwareModel {
        protected final IFlexibleBakedModel base;
        protected final ImmutableMap<String, IFlexibleBakedModel> parts;
        protected final IFlexibleBakedModel internalBase;
        protected final ImmutableList<bgg> general;
        protected final ImmutableMap<cq, ImmutableList<bgg>> faces;
        protected final ImmutableMap<bgr.b, Pair<Baked, TRSRTransformation>> transforms;

        public Baked(IFlexibleBakedModel base, ImmutableMap<String, IFlexibleBakedModel> parts) {
            this(null, false, base, parts);
        }

        public Baked(jy location, boolean perspective, IFlexibleBakedModel base, ImmutableMap<String, IFlexibleBakedModel> parts) {
            this.base = base;
            this.parts = parts;
            if (base != null) {
                this.internalBase = base;
            } else {
                UnmodifiableIterator iter = parts.values().iterator();
                if (iter.hasNext()) {
                    this.internalBase = (IFlexibleBakedModel)iter.next();
                } else {
                    throw new IllegalArgumentException("No base model or submodel provided for MultiModel.Baked " + location + ".");
                }
            }
            EnumMap faces = Maps.newEnumMap(cq.class);
            for (cq face : cq.values()) {
                ImmutableList.Builder faceQuads = ImmutableList.builder();
                if (base != null) {
                    faceQuads.addAll((Iterable)base.a(face));
                }
                for (IFlexibleBakedModel bakedPart : parts.values()) {
                    faceQuads.addAll((Iterable)bakedPart.a(face));
                }
                faces.put(face, faceQuads.build());
            }
            this.faces = Maps.immutableEnumMap((Map)faces);
            ImmutableList.Builder genQuads = ImmutableList.builder();
            if (base != null) {
                genQuads.addAll((Iterable)base.a());
            }
            for (IFlexibleBakedModel bakedPart : parts.values()) {
                genQuads.addAll((Iterable)bakedPart.a());
            }
            this.general = genQuads.build();
            if (perspective && base instanceof IPerspectiveAwareModel) {
                IPerspectiveAwareModel perBase = (IPerspectiveAwareModel)((Object)base);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (bgr.b type : bgr.b.values()) {
                    Pair<boq, Matrix4f> p2 = perBase.handlePerspective(type);
                    IFlexibleBakedModel newBase = p2.getLeft() instanceof IFlexibleBakedModel ? (IFlexibleBakedModel)p2.getLeft() : new IFlexibleBakedModel.Wrapper((boq)p2.getLeft(), base.getFormat());
                    builder.put((Object)type, (Object)Pair.of((Object)new Baked(location, false, newBase, parts), (Object)new TRSRTransformation((Matrix4f)p2.getRight())));
                }
                this.transforms = builder.build();
            } else {
                this.transforms = ImmutableMap.of();
            }
        }

        public boolean b() {
            return this.internalBase.b();
        }

        public boolean c() {
            return this.internalBase.c();
        }

        public boolean d() {
            return this.internalBase.d();
        }

        public bmi e() {
            return this.internalBase.e();
        }

        public bgr f() {
            return this.internalBase.f();
        }

        public List<bgg> a(cq side) {
            return (List)this.faces.get((Object)side);
        }

        public List<bgg> a() {
            return this.general;
        }

        @Override
        public bmu getFormat() {
            return this.internalBase.getFormat();
        }

        public IFlexibleBakedModel getBaseModel() {
            return this.base;
        }

        public Map<String, IFlexibleBakedModel> getParts() {
            return this.parts;
        }

        @Override
        public Pair<boq, Matrix4f> handlePerspective(bgr.b cameraTransformType) {
            if (this.transforms.isEmpty()) {
                return Pair.of((Object)this, null);
            }
            Pair p2 = (Pair)this.transforms.get((Object)cameraTransformType);
            return Pair.of((Object)((boq)p2.getLeft()), (Object)((TRSRTransformation)p2.getRight()).getMatrix());
        }
    }
}

