/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import net.minecraftforge.client.model.IColoredBakedQuad;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class UnpackedBakedQuad
extends bgg {
    protected final float[][][] unpackedData;
    protected final bmu format;
    protected boolean packed = false;

    public UnpackedBakedQuad(float[][][] unpackedData, int tint, cq orientation, bmu format) {
        super(new int[format.g()], tint, orientation);
        this.unpackedData = unpackedData;
        this.format = format;
    }

    public int[] a() {
        if (!this.packed) {
            this.packed = true;
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < this.format.i(); ++e) {
                    LightUtil.pack(this.unpackedData[v][e], this.a, this.format, v, e);
                }
            }
        }
        return this.a;
    }

    public void pipe(IVertexConsumer consumer) {
        int[] eMap = LightUtil.mapFormats(consumer.getVertexFormat(), this.format);
        if (this.b()) {
            consumer.setQuadTint(this.c());
        }
        consumer.setQuadOrientation(this.d());
        if (this instanceof IColoredBakedQuad) {
            consumer.setQuadColored();
        }
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < consumer.getVertexFormat().i(); ++e) {
                if (eMap[e] != this.format.i()) {
                    consumer.put(e, this.unpackedData[v][eMap[e]]);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static class Builder
    implements IVertexConsumer {
        private final bmu format;
        private final float[][][] unpackedData;
        private int tint = -1;
        private cq orientation;
        private boolean isColored = false;
        private int vertices = 0;
        private int elements = 0;
        private boolean full = false;

        public Builder(bmu format) {
            this.format = format;
            this.unpackedData = new float[4][format.i()][4];
        }

        @Override
        public bmu getVertexFormat() {
            return this.format;
        }

        @Override
        public void setQuadTint(int tint) {
            this.tint = tint;
        }

        @Override
        public void setQuadOrientation(cq orientation) {
            this.orientation = orientation;
        }

        @Override
        public void setQuadColored() {
            this.isColored = true;
        }

        @Override
        public void put(int element, float ... data) {
            for (int i = 0; i < 4; ++i) {
                this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
            }
            ++this.elements;
            if (this.elements == this.format.i()) {
                ++this.vertices;
                this.elements = 0;
            }
            if (this.vertices == 4) {
                this.full = true;
            }
        }

        public UnpackedBakedQuad build() {
            if (!this.full) {
                throw new IllegalStateException("not enough data");
            }
            if (this.isColored) {
                return new Colored(this.unpackedData, this.tint, this.orientation, this.format);
            }
            return new UnpackedBakedQuad(this.unpackedData, this.tint, this.orientation, this.format);
        }
    }

    public static class Colored
    extends UnpackedBakedQuad
    implements IColoredBakedQuad {
        public Colored(float[][][] unpackedData, int tint, cq orientation, bmu format) {
            super(unpackedData, tint, orientation, format);
        }
    }
}

