/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidBase
extends afh
implements IFluidBlock {
    protected static final Map<afh, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<afh, Boolean> displacements = Maps.newHashMap();
    public static final amn LEVEL;
    public static final PropertyFloat[] LEVEL_CORNERS;
    public static final PropertyFloat FLOW_DIRECTION;
    public static final IUnlistedProperty<Float>[] FLUID_RENDER_PROPS;
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected adf renderLayer = adf.d;
    protected int maxScaledLight = 0;
    protected final String fluidName;
    protected final Fluid definedFluid;

    public BlockFluidBase(Fluid fluid, arm material) {
        super(material);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.a(true);
        this.K();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.definedFluid = fluid;
        this.displacements.putAll(defaultDisplacements);
        this.j(this.M.b().a((amo)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected ama e() {
        return new ExtendedBlockState(this, new amo[]{LEVEL}, FLUID_RENDER_PROPS);
    }

    public int c(alz state) {
        return (Integer)state.b((amo)LEVEL);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderLayer(adf renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(adq world, cj pos) {
        if (world.d(pos)) {
            return true;
        }
        afh block = world.p(pos).c();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return this.displacements.get(block);
        }
        arm material = block.t();
        if (material.c() || material == arm.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(adm world, cj pos) {
        if (world.d(pos)) {
            return true;
        }
        alz state = world.p(pos);
        afh block = state.c();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                block.b(world, pos, state, 0);
                return true;
            }
            return false;
        }
        arm material = block.t();
        if (material.c() || material == arm.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity((adq)world, pos);
        if (density == Integer.MAX_VALUE) {
            block.b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(adq var1, cj var2);

    public abstract boolean a(alz var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    public void c(adm world, cj pos, alz state) {
        world.a(pos, (afh)this, this.tickRate);
    }

    public void a(adm world, cj pos, alz state, afh neighborBlock) {
        world.a(pos, (afh)this, this.tickRate);
    }

    public boolean N() {
        return false;
    }

    public boolean b(adq world, cj pos) {
        return true;
    }

    public aug a(adm world, cj pos, alz state) {
        return null;
    }

    public zw a(alz state, Random rand, int fortune) {
        return null;
    }

    public int a(Random par1Random) {
        return 0;
    }

    public int a(adm world) {
        return this.tickRate;
    }

    public aui a(adm world, cj pos, pk entity, aui vec) {
        if (this.densityDir > 0) {
            return vec;
        }
        aui vec_flow = this.getFlowVector((adq)world, pos);
        return vec.b(vec_flow.a * (double)(this.quantaPerBlock * 4), vec_flow.b * (double)(this.quantaPerBlock * 4), vec_flow.c * (double)(this.quantaPerBlock * 4));
    }

    public int getLightValue(adq world, cj pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, pos);
        }
        int data = (Integer)world.p(pos).b((amo)LEVEL);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public boolean c() {
        return false;
    }

    public boolean d() {
        return false;
    }

    public int c(adq world, cj pos) {
        int lightThis = world.b(pos, 0);
        int lightUp = world.b(pos.a(), 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public adf m() {
        return this.renderLayer;
    }

    public boolean a(adq world, cj pos, cq side) {
        afh block = world.p(pos).c();
        if (block.t() == this.J) {
            return false;
        }
        if (this.densityDir == -1 && side == cq.b) {
            return true;
        }
        if (this.densityDir == 1 && side == cq.a) {
            return true;
        }
        return super.a(world, pos, side);
    }

    public alz getExtendedState(alz oldState, adq worldIn, cj pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty(FLOW_DIRECTION, Float.valueOf((float)BlockFluidBase.getFlowDirection(worldIn, pos)));
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        height[1][1] = this.getFluidHeightForRender(worldIn, pos);
        if (height[1][1] == 1.0f) {
            for (int i2 = 0; i2 < 2; ++i2) {
                for (int j2 = 0; j2 < 2; ++j2) {
                    corner[i2][j2] = 1.0f;
                }
            }
        } else {
            int j3;
            int i3;
            for (i3 = 0; i3 < 3; ++i3) {
                for (j3 = 0; j3 < 3; ++j3) {
                    if (i3 == 1 && j3 == 1) continue;
                    height[i3][j3] = this.getFluidHeightForRender(worldIn, pos.a(i3 - 1, 0, j3 - 1));
                }
            }
            for (i3 = 0; i3 < 2; ++i3) {
                for (j3 = 0; j3 < 2; ++j3) {
                    corner[i3][j3] = this.getFluidHeightAverage(height[i3][j3], height[i3][j3 + 1], height[i3 + 1][j3], height[i3 + 1][j3 + 1]);
                }
            }
        }
        state = state.withProperty(LEVEL_CORNERS[0], Float.valueOf(corner[0][0]));
        state = state.withProperty(LEVEL_CORNERS[1], Float.valueOf(corner[0][1]));
        state = state.withProperty(LEVEL_CORNERS[2], Float.valueOf(corner[1][1]));
        state = state.withProperty(LEVEL_CORNERS[3], Float.valueOf(corner[1][0]));
        return state;
    }

    public static final int getDensity(adq world, cj pos) {
        afh block = world.p(pos).c();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(adq world, cj pos) {
        afh block = world.p(pos).c();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(adq world, cj pos) {
        afh block = world.p(pos).c();
        if (!block.t().d()) {
            return -1000.0;
        }
        aui vec = ((BlockFluidBase)block).getFlowVector(world, pos);
        return vec.a == 0.0 && vec.c == 0.0 ? -1000.0 : Math.atan2(vec.c, vec.a) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(adq world, cj pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(adq world, cj pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(adq world, cj pos) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (int i2 = 0; i2 < flow.length; ++i2) {
            if (flow[i2] >= 0.875f && end != 1.0f) {
                end = flow[i2];
            }
            if (!(flow[i2] >= 0.0f)) continue;
            total += flow[i2];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end;
    }

    public float getFluidHeightForRender(adq world, cj pos) {
        alz here = world.p(pos);
        alz up = world.p(pos.c(this.densityDir));
        if (here.c() == this) {
            if (up.c().t().d() || up.c() instanceof IFluidBlock) {
                return 1.0f;
            }
            if (this.c(here) == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        return !here.c().t().a() && up.c() == this ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }

    public aui getFlowVector(adq world, cj pos) {
        aui vec = new aui(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, pos);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = pos.n();
            int z2 = pos.p();
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            cj pos2 = new cj(x2, pos.o(), z2);
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.p(pos2).c().t().c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2.b())) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.b((double)((pos2.n() - pos.n()) * power), 0.0, (double)((pos2.p() - pos.p()) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.b((double)((pos2.n() - pos.n()) * power), 0.0, (double)((pos2.p() - pos.p()) * power));
        }
        if (world.p(pos.a()).c() == this) {
            boolean flag;
            boolean bl = flag = this.b(world, pos.a(0, 0, -1), cq.c) || this.b(world, pos.a(0, 0, 1), cq.d) || this.b(world, pos.a(-1, 0, 0), cq.e) || this.b(world, pos.a(1, 0, 0), cq.f) || this.b(world, pos.a(0, 1, -1), cq.c) || this.b(world, pos.a(0, 1, 1), cq.d) || this.b(world, pos.a(-1, 1, 0), cq.e) || this.b(world, pos.a(1, 1, 0), cq.f);
            if (flag) {
                vec = vec.a().b(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(adm world, cj pos) {
        int quantaRemaining = this.getQuantaValue((adq)world, pos) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    static {
        defaultDisplacements.put(afi.ao, false);
        defaultDisplacements.put(afi.ap, false);
        defaultDisplacements.put(afi.aq, false);
        defaultDisplacements.put(afi.ar, false);
        defaultDisplacements.put(afi.as, false);
        defaultDisplacements.put(afi.at, false);
        defaultDisplacements.put(afi.bd, false);
        defaultDisplacements.put(afi.cw, false);
        defaultDisplacements.put(afi.aO, false);
        defaultDisplacements.put(afi.aP, false);
        defaultDisplacements.put(afi.aQ, false);
        defaultDisplacements.put(afi.aR, false);
        defaultDisplacements.put(afi.aS, false);
        defaultDisplacements.put(afi.aT, false);
        defaultDisplacements.put(afi.bz, false);
        defaultDisplacements.put(afi.bo, false);
        defaultDisplacements.put(afi.bp, false);
        defaultDisplacements.put(afi.bq, false);
        defaultDisplacements.put(afi.br, false);
        defaultDisplacements.put(afi.bs, false);
        defaultDisplacements.put(afi.bt, false);
        defaultDisplacements.put(afi.aB, false);
        defaultDisplacements.put(afi.az, false);
        defaultDisplacements.put(afi.ch, false);
        defaultDisplacements.put(afi.ci, false);
        defaultDisplacements.put(afi.au, false);
        defaultDisplacements.put(afi.bi, false);
        defaultDisplacements.put(afi.bj, false);
        defaultDisplacements.put((afh)afi.cH, false);
        defaultDisplacements.put((afh)afi.aY, false);
        defaultDisplacements.put(afi.bF, false);
        defaultDisplacements.put(afi.bZ, false);
        defaultDisplacements.put(afi.cv, false);
        defaultDisplacements.put(afi.cK, false);
        defaultDisplacements.put(afi.cL, false);
        defaultDisplacements.put(afi.ba, false);
        defaultDisplacements.put(afi.aA, false);
        defaultDisplacements.put(afi.an, false);
        defaultDisplacements.put(afi.ax, false);
        defaultDisplacements.put((afh)afi.aM, false);
        LEVEL = amn.a((String)"level", (int)0, (int)15);
        LEVEL_CORNERS = new PropertyFloat[4];
        FLOW_DIRECTION = new PropertyFloat("flow_direction");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)FLOW_DIRECTION);
        for (int i2 = 0; i2 < 4; ++i2) {
            BlockFluidBase.LEVEL_CORNERS[i2] = new PropertyFloat("level_corner_" + i2);
            builder.add((Object)LEVEL_CORNERS[i2]);
        }
        FLUID_RENDER_PROPS = (IUnlistedProperty[])builder.build().toArray((Object[])new IUnlistedProperty[0]);
    }
}

