/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;

public class GameData {
    static final int MIN_BLOCK_ID = 0;
    static final int MAX_BLOCK_ID = 4095;
    static final int MIN_ITEM_ID = 4096;
    static final int MAX_ITEM_ID = 31999;
    public static final int MIN_POTION_ID = 0;
    public static final int MAX_POTION_ID = 255;
    private static final GameData mainData = new GameData();
    private final FMLControlledNamespacedRegistry<afh> iBlockRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BLOCKS, afh.class, new jy("minecraft:air"), 4095, 0, true, BlockStateCapture.INSTANCE);
    private final FMLControlledNamespacedRegistry<zw> iItemRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ITEMS, zw.class, null, 31999, 4096, true);
    private final FMLControlledNamespacedRegistry<pe> iPotionRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONS, pe.class, null, 255, 0, false, PotionArrayCapture.INSTANCE);
    private static Map<afh, zw> BLOCK_TO_ITEM = Maps.newHashMap();
    private static ClearableObjectIntIdentityMap<alz> BLOCKSTATE_TO_ID = new ClearableObjectIntIdentityMap();

    public static FMLControlledNamespacedRegistry<afh> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    public static FMLControlledNamespacedRegistry<zw> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    public static FMLControlledNamespacedRegistry<pe> getPotionRegistry() {
        return GameData.getMain().iPotionRegistry;
    }

    static zw findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.getObject(new jy(modId, name));
    }

    static afh findBlock(String modId, String name) {
        return GameData.getMain().iBlockRegistry.getObject(new jy(modId, name));
    }

    static GameRegistry.UniqueIdentifier getUniqueName(afh block) {
        if (block == null) {
            return null;
        }
        Object name = GameData.getMain().iBlockRegistry.c(block);
        return new GameRegistry.UniqueIdentifier(name);
    }

    static GameRegistry.UniqueIdentifier getUniqueName(zw item) {
        if (item == null) {
            return null;
        }
        Object name = GameData.getMain().iItemRegistry.c(item);
        return new GameRegistry.UniqueIdentifier(name);
    }

    protected static GameData getMain() {
        return mainData;
    }

    int registerItem(zw item, String name) {
        int index = name.indexOf(58);
        if (index != -1) {
            FMLLog.bigWarning("Dangerous extra prefix %s for name %s, invalid registry invocation/invalid name?", name.substring(0, index), name);
        }
        jy rl = this.addPrefix(name);
        return this.registerItem(item, rl, -1);
    }

    private int registerItem(zw item, jy name, int idHint) {
        return this.iItemRegistry.add(idHint, name, item);
    }

    int registerBlock(afh block, String name) {
        int index = name.indexOf(58);
        if (index != -1) {
            FMLLog.bigWarning("Dangerous alternative prefix %s for name %s, invalid registry invocation/invalid name?", name.substring(0, index), name);
        }
        jy rl = this.addPrefix(name);
        return this.registerBlock(block, rl, -1);
    }

    private int registerBlock(afh block, jy name, int idHint) {
        return this.iBlockRegistry.add(idHint, name, block);
    }

    private jy addPrefix(String name) {
        ModContainer mc;
        String prefix;
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        if (!oldPrefix.equals(prefix = (mc = Loader.instance().activeModContainer()) != null ? mc.getModId() : "minecraft") && oldPrefix.length() > 0) {
            prefix = oldPrefix;
        }
        return new jy(prefix, name);
    }

    void registerSubstitutionAlias(String name, GameRegistry.Type type, Object toReplace) throws ExistingSubstitutionException {
        jy nameToSubstitute = new jy(Loader.instance().activeModContainer().getModId(), name);
        if (type == GameRegistry.Type.BLOCK) {
            this.iBlockRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (afh)toReplace);
            this.iBlockRegistry.activateSubstitution(nameToSubstitute);
        } else if (type == GameRegistry.Type.ITEM) {
            this.iItemRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (zw)toReplace);
            this.iItemRegistry.activateSubstitution(nameToSubstitute);
        }
    }

    public static Map getBlockItemMap() {
        return BLOCK_TO_ITEM;
    }

    public static ClearableObjectIntIdentityMap<alz> getBlockStateIDMap() {
        return BLOCKSTATE_TO_ID;
    }

    public <T> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistryManager.makeDelegate(obj, rootClass);
    }

    private static class PotionArrayCapture
    implements FMLControlledNamespacedRegistry.AddCallback<pe> {
        static final PotionArrayCapture INSTANCE = new PotionArrayCapture();

        private PotionArrayCapture() {
        }

        @Override
        public void onAdd(pe potion, int id) {
            potion.H = id;
            pe.a[id] = potion;
        }
    }

    private static class BlockStateCapture
    implements FMLControlledNamespacedRegistry.AddCallback<afh> {
        static final BlockStateCapture INSTANCE = new BlockStateCapture();

        private BlockStateCapture() {
        }

        @Override
        public void onAdd(afh block, int blockId) {
            for (alz state : block.P().a()) {
                BLOCKSTATE_TO_ID.a(state, blockId << 4 | block.c(state));
            }
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends ct<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.a.clear();
            this.b.clear();
        }
    }
}

