/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.GameData;
import org.apache.logging.log4j.Level;

public class GameRegistry {
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static Map<IWorldGenerator, Integer> worldGeneratorIndex = Maps.newHashMap();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<IWorldGenerator> sortedGeneratorList;

    public static void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        worldGenerators.add(generator);
        worldGeneratorIndex.put(generator, modGenerationWeight);
        if (sortedGeneratorList != null) {
            sortedGeneratorList = null;
        }
    }

    public static void generateWorld(int chunkX, int chunkZ, adm world, amv chunkGenerator, amv chunkProvider) {
        if (sortedGeneratorList == null) {
            GameRegistry.computeSortedGeneratorList();
        }
        long worldSeed = world.J();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        for (IWorldGenerator generator : sortedGeneratorList) {
            fmlRandom.setSeed(chunkSeed);
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private static void computeSortedGeneratorList() {
        ArrayList list = Lists.newArrayList(worldGenerators);
        Collections.sort(list, new Comparator<IWorldGenerator>(){

            @Override
            public int compare(IWorldGenerator o1, IWorldGenerator o2) {
                return Ints.compare((int)((Integer)worldGeneratorIndex.get(o1)), (int)((Integer)worldGeneratorIndex.get(o2)));
            }
        });
        sortedGeneratorList = ImmutableList.copyOf((Collection)list);
    }

    public static void registerItem(zw item, String name) {
        GameRegistry.registerItem(item, name, null);
    }

    public static zw registerItem(zw item, String name, String modId) {
        GameData.getMain().registerItem(item, name);
        return item;
    }

    public static void addSubstitutionAlias(String nameToSubstitute, Type type, Object object) throws ExistingSubstitutionException {
        GameData.getMain().registerSubstitutionAlias(nameToSubstitute, type, object);
    }

    public static afh registerBlock(afh block, String name) {
        return GameRegistry.registerBlock(block, yo.class, name);
    }

    public static afh registerBlock(afh block, Class<? extends yo> itemclass, String name) {
        return GameRegistry.registerBlock(block, itemclass, name, new Object[0]);
    }

    public static afh registerBlock(afh block, Class<? extends yo> itemclass, String name, Object ... itemCtorArgs) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            yo i2 = null;
            if (itemclass != null) {
                Class[] ctorArgClasses = new Class[itemCtorArgs.length + 1];
                ctorArgClasses[0] = afh.class;
                for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                    ctorArgClasses[idx] = itemCtorArgs[idx - 1].getClass();
                }
                Constructor<? extends yo> itemCtor = itemclass.getConstructor(ctorArgClasses);
                i2 = itemCtor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            GameData.getMain().registerBlock(block, name);
            if (i2 != null) {
                GameData.getMain().registerItem((zw)i2, name);
                GameData.getBlockItemMap().put(block, i2);
            }
            return block;
        }
        catch (Exception e2) {
            FMLLog.log(Level.ERROR, e2, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(e2);
        }
    }

    public static void addRecipe(zx output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static abs addShapedRecipe(zx output, Object ... params) {
        return abt.a().a(output, params);
    }

    public static void addShapelessRecipe(zx output, Object ... params) {
        abt.a().b(output, params);
    }

    public static void addRecipe(abs recipe) {
        abt.a().b().add(recipe);
    }

    public static void addSmelting(afh input, zx output, float xp2) {
        abo.a().a(input, output, xp2);
    }

    public static void addSmelting(zw input, zx output, float xp2) {
        abo.a().a(input, output, xp2);
    }

    public static void addSmelting(zx input, zx output, float xp2) {
        abo.a().a(input, output, xp2);
    }

    public static void registerTileEntity(Class<? extends akw> tileEntityClass, String id) {
        akw.a(tileEntityClass, (String)id);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends akw> tileEntityClass, String id, String ... alternatives) {
        akw.a(tileEntityClass, (String)id);
        Map teMappings = (Map)ObfuscationReflectionHelper.getPrivateValue(akw.class, null, "field_145855_i", "nameToClassMap");
        for (String s : alternatives) {
            if (teMappings.containsKey(s)) continue;
            teMappings.put(s, tileEntityClass);
        }
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(zx itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    public static afh findBlock(String modId, String name) {
        return GameData.findBlock(modId, name);
    }

    public static zw findItem(String modId, String name) {
        return GameData.findItem(modId, name);
    }

    @Deprecated
    public static UniqueIdentifier findUniqueIdentifierFor(afh block) {
        return GameData.getUniqueName(block);
    }

    @Deprecated
    public static UniqueIdentifier findUniqueIdentifierFor(zw item) {
        return GameData.getUniqueName(item);
    }

    public static zx makeItemStack(String itemName, int meta, int stackSize, String nbtString) {
        if (itemName == null) {
            throw new IllegalArgumentException("The itemName cannot be null");
        }
        zw item = GameData.getItemRegistry().getObject(new jy(itemName));
        if (item == null) {
            FMLLog.getLogger().log(Level.TRACE, "Unable to find item with name {}", new Object[]{itemName});
            return null;
        }
        zx is = new zx(item, 1, meta);
        if (!Strings.isNullOrEmpty((String)nbtString)) {
            dn nbttag = null;
            try {
                nbttag = ed.a((String)nbtString);
            }
            catch (ec e2) {
                FMLLog.getLogger().log(Level.WARN, "Encountered an exception parsing ItemStack NBT string {}", new Object[]{nbtString, e2});
                throw Throwables.propagate((Throwable)e2);
            }
            if (!(nbttag instanceof dn)) {
                FMLLog.getLogger().log(Level.WARN, "Unexpected NBT string - multiple values {}", new Object[]{nbtString});
                throw new RuntimeException("Invalid NBT JSON");
            }
            is.d(nbttag);
        }
        return is;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ItemStackHolder {
        public String value();

        public int meta() default 0;

        public String nbt() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface ObjectHolder {
        public String value();
    }

    public static enum Type {
        BLOCK,
        ITEM;

    }

    @Deprecated
    public static final class UniqueIdentifier {
        public final String modId;
        public final String name;

        UniqueIdentifier(String modId, String name) {
            this.modId = modId;
            this.name = name;
        }

        public UniqueIdentifier(String string) {
            String[] parts = string.split(":");
            this.modId = parts[0];
            this.name = parts[1];
        }

        public UniqueIdentifier(Object obj) {
            if (obj instanceof String) {
                String[] parts = ((String)obj).split(":");
                this.modId = parts[0];
                this.name = parts[1];
            } else if (obj instanceof jy) {
                this.modId = ((jy)obj).b();
                this.name = ((jy)obj).a();
            } else {
                throw new IllegalArgumentException("UniqueIdentifier must be a String or ResourceLocation, was " + obj.getClass());
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            UniqueIdentifier other = (UniqueIdentifier)obj;
            return Objects.equal((Object)this.modId, (Object)other.modId) && Objects.equal((Object)this.name, (Object)other.name);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.modId, this.name});
        }

        public String toString() {
            return String.format("%s:%s", this.modId, this.name);
        }
    }
}

