/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class VillagerRegistry {
    private static final VillagerRegistry INSTANCE = new VillagerRegistry();
    private Map<Class<?>, IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    private List<Integer> newVillagerIds = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private Map<Integer, jy> newVillagers;
    private boolean hasInit = false;
    private FMLControlledNamespacedRegistry<VillagerProfession> professions = PersistentRegistryManager.createRegistry(new jy("minecraft:villagerprofessions"), VillagerProfession.class, null, 1024, 0, true, null);

    private VillagerRegistry() {
        this.init();
    }

    public static VillagerRegistry instance() {
        return INSTANCE;
    }

    @Deprecated
    public void registerVillagerId(int id) {
        if (this.newVillagerIds.contains(id)) {
            FMLLog.severe("Attempt to register duplicate villager id %d", id);
            throw new RuntimeException();
        }
        this.newVillagerIds.add(id);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public void registerVillagerSkin(int villagerId, jy villagerSkin) {
        if (this.newVillagers == null) {
            this.newVillagers = Maps.newHashMap();
        }
        this.newVillagers.put(villagerId, villagerSkin);
    }

    public void registerVillageCreationHandler(IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static jy getVillagerSkin(int villagerType, jy defaultSkin) {
        if (VillagerRegistry.instance().newVillagers != null && VillagerRegistry.instance().newVillagers.containsKey(villagerType)) {
            return VillagerRegistry.instance().newVillagers.get(villagerType);
        }
        return defaultSkin;
    }

    @Deprecated
    public static Collection<Integer> getRegisteredVillagers() {
        return Collections.unmodifiableCollection(VillagerRegistry.instance().newVillagerIds);
    }

    public static void addExtraVillageComponents(List<aqw.e> list, Random random, int i2) {
        List<aqw.e> parts = list;
        for (IVillageCreationHandler handler : VillagerRegistry.instance().villageCreationHandlers.values()) {
            parts.add(handler.getVillagePieceWeight(random, i2));
        }
    }

    public static aqw.n getVillageComponent(aqw.e villagePiece, aqw.k startPiece, List<aqt> pieces, Random random, int p1, int p2, int p3, cq facing, int p5) {
        return VillagerRegistry.instance().villageCreationHandlers.get(villagePiece.a).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, facing, p5);
    }

    public void register(VillagerProfession prof) {
        this.register(prof, -1);
    }

    private void register(VillagerProfession prof, int id) {
        this.professions.register(id, prof.name, prof);
    }

    private void init() {
        if (this.hasInit) {
            return;
        }
        VillagerProfession prof = new VillagerProfession("minecraft:farmer", "minecraft:textures/entity/villager/farmer.png");
        this.register(prof, 0);
        new VillagerCareer(prof, "farmer").init(VanillaTrades.trades[0][0]);
        new VillagerCareer(prof, "fisherman").init(VanillaTrades.trades[0][1]);
        new VillagerCareer(prof, "shepherd").init(VanillaTrades.trades[0][2]);
        new VillagerCareer(prof, "fletcher").init(VanillaTrades.trades[0][3]);
        prof = new VillagerProfession("minecraft:librarian", "minecraft:textures/entity/villager/librarian.png");
        this.register(prof, 1);
        new VillagerCareer(prof, "librarian").init(VanillaTrades.trades[1][0]);
        prof = new VillagerProfession("minecraft:priest", "minecraft:textures/entity/villager/priest.png");
        this.register(prof, 2);
        new VillagerCareer(prof, "cleric").init(VanillaTrades.trades[2][0]);
        prof = new VillagerProfession("minecraft:smith", "minecraft:textures/entity/villager/smith.png");
        this.register(prof, 3);
        new VillagerCareer(prof, "armor").init(VanillaTrades.trades[3][0]);
        new VillagerCareer(prof, "weapon").init(VanillaTrades.trades[3][1]);
        new VillagerCareer(prof, "tool").init(VanillaTrades.trades[3][2]);
        prof = new VillagerProfession("minecraft:butcher", "minecraft:textures/entity/villager/butcher.png");
        this.register(prof, 4);
        new VillagerCareer(prof, "butcher").init(VanillaTrades.trades[4][0]);
        new VillagerCareer(prof, "leather").init(VanillaTrades.trades[4][1]);
    }

    public static void setRandomProfession(wi entity, Random rand) {
        Set entries = VillagerRegistry.INSTANCE.professions.c();
        int prof = rand.nextInt(entries.size());
        entity.r(rand.nextInt(5));
    }

    private static class VanillaTrades {
        private static final wi.f[][][][] trades = new wi.f[][][][]{{{{new wi.a(zy.O, new wi.g(18, 22)), new wi.a(zy.bS, new wi.g(15, 19)), new wi.a(zy.bR, new wi.g(15, 19)), new wi.e(zy.P, new wi.g(-4, -2))}, {new wi.a(zw.a((afh)afi.aU), new wi.g(8, 13)), new wi.e(zy.ca, new wi.g(-3, -2))}, {new wi.a(zw.a((afh)afi.bk), new wi.g(7, 12)), new wi.e(zy.e, new wi.g(-5, -7))}, {new wi.e(zy.bc, new wi.g(-6, -10)), new wi.e(zy.aZ, new wi.g(1, 1))}}, {{new wi.a(zy.F, new wi.g(15, 20)), new wi.a(zy.h, new wi.g(16, 24)), new wi.d(zy.aU, new wi.g(6, 6), zy.aV, new wi.g(6, 6))}, {new wi.c((zw)zy.aR, new wi.g(7, 8))}}, {{new wi.a(zw.a((afh)afi.L), new wi.g(16, 22)), new wi.e((zw)zy.be, new wi.g(3, 4))}, {new wi.e(new zx(afi.L, 1, 0), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 1), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 2), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 3), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 4), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 5), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 6), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 7), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 8), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 9), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 10), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 11), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 12), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 13), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 14), new wi.g(1, 2)), new wi.e(new zx(afi.L, 1, 15), new wi.g(1, 2))}}, {{new wi.a(zy.F, new wi.g(15, 20)), new wi.e(zy.g, new wi.g(-12, -8))}, {new wi.e((zw)zy.f, new wi.g(2, 3)), new wi.d(zw.a((afh)afi.n), new wi.g(10, 10), zy.ak, new wi.g(6, 10))}}}, {{{new wi.a(zy.aK, new wi.g(24, 36)), new wi.b()}, {new wi.a(zy.aL, new wi.g(8, 10)), new wi.e(zy.aQ, new wi.g(10, 12)), new wi.e(zw.a((afh)afi.X), new wi.g(3, 4))}, {new wi.a(zy.bN, new wi.g(2, 2)), new wi.e(zy.aS, new wi.g(10, 12)), new wi.e(zw.a((afh)afi.w), new wi.g(-5, -3))}, {new wi.b()}, {new wi.b()}, {new wi.e(zy.co, new wi.g(20, 22))}}}, {{{new wi.a(zy.bt, new wi.g(36, 40)), new wi.a(zy.k, new wi.g(8, 10))}, {new wi.e(zy.aC, new wi.g(-4, -1)), new wi.e(new zx(zy.aW, 1, zd.l.b()), new wi.g(-2, -1))}, {new wi.e(zy.bH, new wi.g(7, 11)), new wi.e(zw.a((afh)afi.aX), new wi.g(-3, -1))}, {new wi.e(zy.bK, new wi.g(3, 11))}}}, {{{new wi.a(zy.h, new wi.g(16, 24)), new wi.e((zw)zy.Y, new wi.g(4, 6))}, {new wi.a(zy.j, new wi.g(7, 9)), new wi.e((zw)zy.Z, new wi.g(10, 14))}, {new wi.a(zy.i, new wi.g(3, 4)), new wi.c((zw)zy.ad, new wi.g(16, 19))}, {new wi.e((zw)zy.X, new wi.g(5, 7)), new wi.e((zw)zy.W, new wi.g(9, 11)), new wi.e((zw)zy.U, new wi.g(5, 7)), new wi.e((zw)zy.V, new wi.g(11, 15))}}, {{new wi.a(zy.h, new wi.g(16, 24)), new wi.e(zy.c, new wi.g(6, 8))}, {new wi.a(zy.j, new wi.g(7, 9)), new wi.c(zy.l, new wi.g(9, 10))}, {new wi.a(zy.i, new wi.g(3, 4)), new wi.c(zy.u, new wi.g(12, 15)), new wi.c(zy.x, new wi.g(9, 12))}}, {{new wi.a(zy.h, new wi.g(16, 24)), new wi.c(zy.a, new wi.g(5, 7))}, {new wi.a(zy.j, new wi.g(7, 9)), new wi.c(zy.b, new wi.g(9, 11))}, {new wi.a(zy.i, new wi.g(3, 4)), new wi.c(zy.w, new wi.g(12, 15))}}}, {{{new wi.a(zy.al, new wi.g(14, 18)), new wi.a(zy.bk, new wi.g(14, 18))}, {new wi.a(zy.h, new wi.g(16, 24)), new wi.e(zy.am, new wi.g(-7, -5)), new wi.e(zy.bl, new wi.g(-8, -6))}}, {{new wi.a(zy.aF, new wi.g(9, 12)), new wi.e((zw)zy.S, new wi.g(2, 4))}, {new wi.c((zw)zy.R, new wi.g(7, 12))}, {new wi.e(zy.aA, new wi.g(8, 10))}}}};

        private VanillaTrades() {
        }
    }

    public static class VillagerCareer {
        private VillagerProfession profession;
        private String name;
        private int id;

        public VillagerCareer(VillagerProfession parent, String name) {
            this.profession = parent;
            this.name = name;
            parent.register(this);
        }

        private VillagerCareer init(wi.f[][] traids) {
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VillagerCareer)) {
                return false;
            }
            VillagerCareer oc = (VillagerCareer)o;
            return this.name.equals(oc.name) && this.profession == oc.profession;
        }
    }

    public static class VillagerProfession {
        private jy name;
        private jy texture;
        private List<VillagerCareer> careers = Lists.newArrayList();
        public final RegistryDelegate<VillagerProfession> delegate = PersistentRegistryManager.makeDelegate(this, VillagerProfession.class);

        public VillagerProfession(String name, String texture) {
            this.name = new jy(name);
            this.texture = new jy(texture);
            ((RegistryDelegate.Delegate)this.delegate).setResourceName(this.name);
        }

        private void register(VillagerCareer career) {
            Validate.isTrue((!this.careers.contains(career) ? 1 : 0) != 0, (String)"Attempted to register career that is already registered.", (Object[])new Object[0]);
            Validate.isTrue((career.profession == this ? 1 : 0) != 0, (String)"Attempted to register career for the wrong profession.", (Object[])new Object[0]);
            career.id = this.careers.size();
            this.careers.add(career);
        }
    }

    public static interface IVillageCreationHandler {
        public aqw.e getVillagePieceWeight(Random var1, int var2);

        public Class<?> getComponentClass();

        public aqw.n buildComponent(aqw.e var1, aqw.k var2, List<aqt> var3, Random var4, int var5, int var6, int var7, cq var8, int var9);
    }
}

