/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class EntityViewRenderEvent
extends Event {
    private final bng renderer;
    private final rr entity;
    private final arc state;
    private final double renderPartialTicks;

    public EntityViewRenderEvent(bng renderer, rr entity, arc state, double renderPartialTicks) {
        this.renderer = renderer;
        this.entity = entity;
        this.state = state;
        this.renderPartialTicks = renderPartialTicks;
    }

    public bng getRenderer() {
        return this.renderer;
    }

    public rr getEntity() {
        return this.entity;
    }

    public arc getState() {
        return this.state;
    }

    public double getRenderPartialTicks() {
        return this.renderPartialTicks;
    }

    public static class FOVModifier
    extends EntityViewRenderEvent {
        private float fov;

        public FOVModifier(bng renderer, rr entity, arc state, double renderPartialTicks, float fov) {
            super(renderer, entity, state, renderPartialTicks);
            this.setFOV(fov);
        }

        public float getFOV() {
            return this.fov;
        }

        public void setFOV(float fov) {
            this.fov = fov;
        }
    }

    public static class CameraSetup
    extends EntityViewRenderEvent {
        public float yaw;
        public float pitch;
        public float roll;

        public CameraSetup(bng renderer, rr entity, arc state, double renderPartialTicks, float yaw, float pitch, float roll) {
            super(renderer, entity, state, renderPartialTicks);
            this.yaw = yaw;
            this.pitch = pitch;
            this.roll = roll;
        }
    }

    public static class FogColors
    extends EntityViewRenderEvent {
        public float red;
        public float green;
        public float blue;

        public FogColors(bng renderer, rr entity, arc state, double renderPartialTicks, float red, float green, float blue) {
            super(renderer, entity, state, renderPartialTicks);
            this.red = red;
            this.green = green;
            this.blue = blue;
        }
    }

    @Event.HasResult
    public static class RenderFogEvent
    extends EntityViewRenderEvent {
        public final int fogMode;
        public final float farPlaneDistance;

        public RenderFogEvent(bng renderer, rr entity, arc state, double renderPartialTicks, int fogMode, float farPlaneDistance) {
            super(renderer, entity, state, renderPartialTicks);
            this.fogMode = fogMode;
            this.farPlaneDistance = farPlaneDistance;
        }
    }

    @Cancelable
    public static class FogDensity
    extends EntityViewRenderEvent {
        public float density;

        public FogDensity(bng renderer, rr entity, arc state, double renderPartialTicks, float density) {
            super(renderer, entity, state, renderPartialTicks);
            this.density = density;
        }
    }
}

