/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelSimpleProperties;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IModelUVLock;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ISmartVariant;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.model.animation.IAnimatedModel;
import net.minecraftforge.client.model.animation.IClip;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public final class ModelLoader
extends bxr {
    private final Map<bxt, IModel> stateModels = Maps.newHashMap();
    private final Set<bxt> missingVariants = Sets.newHashSet();
    private final Map<kk, Exception> loadingExceptions = Maps.newHashMap();
    private IModel missingModel = null;
    private boolean isLoading = false;
    private final boolean enableVerboseMissingInfo = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false || Boolean.parseBoolean(System.getProperty("forge.verboseMissingModelLogging", "false"));
    private static final Map<RegistryDelegate<ajt>, bpi> customStateMappers = Maps.newHashMap();
    private static final Map<RegistryDelegate<ado>, bnm> customMeshDefinitions = Maps.newHashMap();
    private static final Map<Pair<RegistryDelegate<ado>, Integer>, bxt> customModels = Maps.newHashMap();

    public boolean isLoading() {
        return this.isLoading;
    }

    public ModelLoader(bwg manager, bvg map, bob shapes) {
        super(manager, map, shapes);
        VanillaLoader.instance.setLoader(this);
        VariantLoader.instance.setLoader(this);
        ModelLoaderRegistry.clearModelCache();
    }

    public db<bxt, bxo> a() {
        this.isLoading = true;
        this.b();
        this.c();
        this.missingModel = ModelLoaderRegistry.getMissingModel();
        this.stateModels.put(a, this.missingModel);
        final HashSet textures = Sets.newHashSet(ModelLoaderRegistry.getTextures());
        textures.remove(bvg.f);
        textures.addAll(b);
        this.l.a(this.g, new buz(){

            public void a(bvg map) {
                for (kk t : textures) {
                    map.a(t);
                }
            }
        });
        bxo missingBaked = this.missingModel.bake(this.missingModel.getDefaultState(), bvp.b, DefaultTextureGetter.instance);
        HashMap bakedModels = Maps.newHashMap();
        HashMultimap models = HashMultimap.create();
        Multimaps.invertFrom((Multimap)Multimaps.forMap(this.stateModels), (Multimap)models);
        ProgressManager.ProgressBar bakeBar = ProgressManager.push("ModelLoader: baking", models.keySet().size());
        for (IModel iModel : models.keySet()) {
            bakeBar.step("[" + Joiner.on((String)", ").join((Iterable)models.get((Object)iModel)) + "]");
            if (iModel == this.getMissingModel()) {
                bakedModels.put(iModel, missingBaked);
                continue;
            }
            bakedModels.put(iModel, iModel.bake(iModel.getDefaultState(), bvp.b, DefaultTextureGetter.instance));
        }
        ProgressManager.pop(bakeBar);
        for (Map.Entry entry : this.stateModels.entrySet()) {
            this.p.a(entry.getKey(), bakedModels.get(entry.getValue()));
        }
        return this.p;
    }

    protected void d() {
    }

    protected void e() {
    }

    protected void b() {
        ArrayList blocks = Lists.newArrayList((Iterable)ajt.h);
        Collections.sort(blocks, new Comparator<ajt>(){

            @Override
            public int compare(ajt b1, ajt b2) {
                return b1.getRegistryName().compareTo(b2.getRegistryName());
            }
        });
        ProgressManager.ProgressBar blockBar = ProgressManager.push("ModelLoader: blocks", blocks.size());
        bpf mapper = this.m.a();
        for (ajt block : blocks) {
            blockBar.step(block.getRegistryName());
            for (kk location : mapper.a(block)) {
                this.loadBlock(mapper, block, location);
            }
        }
        ProgressManager.pop(blockBar);
    }

    protected void a(bol definition, bxt location) {
        IModel model;
        try {
            model = ModelLoaderRegistry.getModel((kk)location);
        }
        catch (Exception e) {
            this.storeException((kk)location, e);
            model = this.getMissingModel();
        }
        this.stateModels.put(location, model);
    }

    protected void registerMultipartVariant(bol definition, Collection<bxt> locations) {
        for (bxt location : locations) {
            this.a(null, location);
        }
    }

    private void storeException(kk location, Exception exception) {
        this.loadingExceptions.put(location, exception);
    }

    protected bol a(kk location) {
        try {
            return super.a(location);
        }
        catch (Exception exception) {
            this.storeException(location, new Exception("Could not load model definition for variant " + location, exception));
            return new bol(new ArrayList());
        }
    }

    protected void f() {
        if (FluidRegistry.isUniversalBucketEnabled()) {
            ModelLoader.setBucketModelDefinition(ForgeModContainer.getInstance().universalBucket);
        }
        this.g();
        ArrayList items = Lists.newArrayList(GameData.getItemRegistry().typeSafeIterable());
        Collections.sort(items, new Comparator<ado>(){

            @Override
            public int compare(ado i1, ado i2) {
                return i1.getRegistryName().compareTo(i2.getRegistryName());
            }
        });
        ProgressManager.ProgressBar itemBar = ProgressManager.push("ModelLoader: items", items.size());
        for (ado item : items) {
            itemBar.step(item.getRegistryName());
            for (String s : this.a(item)) {
                kk file = this.a(s);
                bxt memory = ModelLoader.getInventoryVariant(s);
                IModel model = ModelLoaderRegistry.getMissingModel();
                Exception exception = null;
                try {
                    model = ModelLoaderRegistry.getModel(file);
                }
                catch (Exception e) {
                    FMLLog.fine("Item json isn't found for '" + memory + "', trying to load the variant from the blockstate json", new Object[0]);
                    try {
                        model = ModelLoaderRegistry.getModel((kk)memory);
                    }
                    catch (Exception ex) {
                        exception = new Exception("Could not load item model either from the normal location " + file + " or from the blockstate", ex);
                    }
                }
                this.stateModels.put(memory, model);
                if (exception == null) continue;
                this.storeException((kk)memory, exception);
            }
        }
        ProgressManager.pop(itemBar);
        if (ForgeModContainer.replaceVanillaBucketModel) {
            IModel model;
            bxt memory;
            if (!this.stateModels.containsKey(ModelDynBucket.LOCATION)) {
                try {
                    this.a(this.a((kk)ModelDynBucket.LOCATION), ModelDynBucket.LOCATION);
                }
                catch (Exception exception) {
                    FMLLog.getLogger().error("Could not load the forge bucket model from the blockstate", (Throwable)exception);
                    return;
                }
            }
            for (String s : this.a(ads.ay)) {
                memory = ModelLoader.getInventoryVariant(s);
                model = ModelLoaderRegistry.getModelOrMissing(new kk("forge", "item/bucket"));
                if (model == this.getMissingModel()) continue;
                this.stateModels.put(memory, model);
            }
            this.setBucketModel(ads.az);
            this.setBucketModel(ads.aA);
            if (FluidRegistry.isFluidRegistered("milk")) {
                Fluid milk = FluidRegistry.getFluid("milk");
                FluidStack milkStack = new FluidStack(milk, 1000);
                if (FluidContainerRegistry.getContainerCapacity(milkStack, new adq(ads.ay)) == 1000) {
                    this.setBucketModel(ads.aN);
                }
            } else {
                for (String s : this.a(ads.aN)) {
                    memory = ModelLoader.getInventoryVariant(s);
                    model = ModelLoaderRegistry.getModelOrMissing(new kk("forge", "item/bucket_milk"));
                    if (model == this.getMissingModel()) continue;
                    this.stateModels.put(memory, model);
                }
            }
        }
    }

    private void setBucketModel(ado item) {
        for (String s : this.a(item)) {
            bxt memory = ModelLoader.getInventoryVariant(s);
            IModel model = this.stateModels.get(ModelDynBucket.LOCATION);
            if (model == null) continue;
            this.stateModels.put(memory, model);
        }
    }

    public static bxt getInventoryVariant(String s) {
        if (s.contains("#")) {
            return new bxt(s);
        }
        return new bxt(s, "inventory");
    }

    protected kk d(kk model) {
        return new kk(model.b(), model.a() + ".json");
    }

    protected IModel getMissingModel() {
        if (this.missingModel == null) {
            try {
                this.missingModel = VanillaLoader.instance.loadModel(new kk(a.b(), a.a()));
            }
            catch (Exception e) {
                throw new RuntimeException("Missing the missing model, this should never happen");
            }
        }
        return this.missingModel;
    }

    public void onPostBakeEvent(db<bxt, bxo> modelRegistry) {
        bxo missingModel = (bxo)modelRegistry.c((Object)a);
        HashMap modelErrors = Maps.newHashMap();
        HashMultimap reverseBlockMap = null;
        HashMultimap reverseItemMap = null;
        if (this.enableVerboseMissingInfo) {
            reverseBlockMap = HashMultimap.create();
            for (Map.Entry<Object, Exception> entry : this.m.a().a().entrySet()) {
                reverseBlockMap.put((Object)entry.getValue(), entry.getKey());
            }
            reverseItemMap = HashMultimap.create();
            for (ado ado2 : GameData.getItemRegistry().typeSafeIterable()) {
                for (String s : this.a(ado2)) {
                    bxt memory = ModelLoader.getInventoryVariant(s);
                    reverseItemMap.put((Object)memory, (Object)ado2.getRegistryName());
                }
            }
        }
        for (Map.Entry<Object, Exception> entry : this.loadingExceptions.entrySet()) {
            if (!(entry.getKey() instanceof bxt)) continue;
            bxt location = (bxt)entry.getKey();
            bxo model = (bxo)modelRegistry.c((Object)location);
            if (model == null || model == missingModel) {
                int errorCount;
                String domain = ((kk)entry.getKey()).b();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < 5) {
                    String errorMsg = "Exception loading model for variant " + entry.getKey();
                    if (this.enableVerboseMissingInfo) {
                        Collection items;
                        Collection blocks = reverseBlockMap.get((Object)location);
                        if (!blocks.isEmpty()) {
                            errorMsg = blocks.size() == 1 ? errorMsg + " for blockstate \"" + blocks.iterator().next() + "\"" : errorMsg + " for blockstates [\"" + Joiner.on((String)"\", \"").join((Iterable)blocks) + "\"]";
                        }
                        if (!(items = reverseItemMap.get((Object)location)).isEmpty()) {
                            if (!blocks.isEmpty()) {
                                errorMsg = errorMsg + " and";
                            }
                            errorMsg = items.size() == 1 ? errorMsg + " for item \"" + (String)items.iterator().next() + "\"" : errorMsg + " for items [\"" + Joiner.on((String)"\", \"").join((Iterable)items) + "\"]";
                        }
                    }
                    FMLLog.getLogger().error(errorMsg, (Throwable)entry.getValue());
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.a((Object)location, (Object)missingModel);
        }
        for (bxt bxt2 : this.missingVariants) {
            bxo model = (bxo)modelRegistry.c((Object)bxt2);
            if (model == null || model == missingModel) {
                int errorCount;
                String domain = bxt2.b();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < 5) {
                    FMLLog.severe("Model definition for location %s not found", bxt2);
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.a((Object)bxt2, (Object)missingModel);
        }
        for (Map.Entry<Object, Exception> entry : modelErrors.entrySet()) {
            if ((Integer)((Object)entry.getValue()) < 5) continue;
            FMLLog.severe("Suppressed additional %s model loading errors for domain %s", entry.getValue(), entry.getKey());
        }
        this.isLoading = false;
    }

    public static void setCustomStateMapper(ajt block, bpi mapper) {
        customStateMappers.put(block.delegate, mapper);
    }

    public static void onRegisterAllBlocks(bob shapes) {
        for (Map.Entry<RegistryDelegate<ajt>, bpi> e : customStateMappers.entrySet()) {
            shapes.a(e.getKey().get(), e.getValue());
        }
    }

    public static void setCustomModelResourceLocation(ado item, int metadata, bxt model) {
        customModels.put((Pair<RegistryDelegate<ado>, Integer>)Pair.of((Object)item.delegate, (Object)metadata), model);
        bxr.registerItemVariants((ado)item, (kk[])new kk[]{model});
    }

    public static void setCustomMeshDefinition(ado item, bnm meshDefinition) {
        customMeshDefinitions.put(item.delegate, meshDefinition);
    }

    public static void setBucketModelDefinition(ado item) {
        ModelLoader.setCustomMeshDefinition(item, new bnm(){

            public bxt a(adq stack) {
                return ModelDynBucket.LOCATION;
            }
        });
        bxr.registerItemVariants((ado)item, (kk[])new kk[]{ModelDynBucket.LOCATION});
    }

    public static void onRegisterItems(bnl mesher) {
        for (Map.Entry<RegistryDelegate<ado>, bnm> entry : customMeshDefinitions.entrySet()) {
            mesher.a(entry.getKey().get(), entry.getValue());
        }
        for (Map.Entry<RegistryDelegate<ado>, bnm> entry : customModels.entrySet()) {
            mesher.a((ado)((RegistryDelegate)((Pair)entry.getKey()).getLeft()).get(), ((Integer)((Pair)entry.getKey()).getRight()).intValue(), (bxt)entry.getValue());
        }
    }

    public static Function<kk, bvh> defaultTextureGetter() {
        return DefaultTextureGetter.instance;
    }

    private static class MultipartModel
    implements IModel {
        private final kk location;
        private final boy multipart;
        private final ImmutableMap<bpa, IModel> partModels;

        public MultipartModel(kk location, boy multipart) throws Exception {
            this.location = location;
            this.multipart = multipart;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bpa selector : multipart.a()) {
                builder.put((Object)selector, (Object)new WeightedRandomModel(location, selector.a()));
            }
            this.partModels = builder.build();
        }

        @Override
        public Collection<kk> getDependencies() {
            return ImmutableSet.of();
        }

        @Override
        public Collection<kk> getTextures() {
            return ImmutableSet.of();
        }

        @Override
        public bxo bake(IModelState state, bvr format, Function<kk, bvh> bakedTextureGetter) {
            bxu.a builder = new bxu.a();
            for (bpa selector : this.multipart.a()) {
                builder.a(selector.a(this.multipart.c()), ((IModel)this.partModels.get((Object)selector)).bake(((IModel)this.partModels.get((Object)selector)).getDefaultState(), format, bakedTextureGetter));
            }
            bxo bakedModel = builder.a();
            return bakedModel;
        }

        @Override
        public IModelState getDefaultState() {
            return TRSRTransformation.identity();
        }
    }

    protected static enum VariantLoader implements ICustomModelLoader
    {
        instance;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        public void a(bwg resourceManager) {
        }

        @Override
        public boolean accepts(kk modelLocation) {
            return modelLocation instanceof bxt;
        }

        @Override
        public IModel loadModel(kk modelLocation) throws Exception {
            bxt variant = (bxt)modelLocation;
            bol definition = this.loader.a((kk)variant);
            try {
                bot variants = definition.c(variant.c());
                return new WeightedRandomModel((kk)variant, variants);
            }
            catch (bol.b e) {
                if (definition.b()) {
                    return new MultipartModel(new kk(variant.b(), variant.a()), definition.c());
                }
                throw e;
            }
        }

        public String toString() {
            return "VariantLoader.instance";
        }
    }

    private static enum DefaultTextureGetter implements Function<kk, bvh>
    {
        instance;


        public bvh apply(kk location) {
            return bcf.z().R().a(location.toString());
        }
    }

    public static final class White
    extends bvh {
        public static kk loc = new kk("white");
        public static White instance = new White();

        private White() {
            super(loc.toString());
        }

        public boolean hasCustomLoader(bwg manager, kk location) {
            return true;
        }

        public boolean load(bwg manager, kk location) {
            BufferedImage image = new BufferedImage(16, 16, 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, 16, 16);
            int[][] pixels = new int[bcf.z().u.J + 1][];
            pixels[0] = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels[0], 0, image.getWidth());
            this.l();
            this.a.add(pixels);
            return false;
        }

        public void register(bvg map) {
            map.setTextureEntry(loc.toString(), (bvh)instance);
        }
    }

    protected static enum VanillaLoader implements ICustomModelLoader
    {
        instance;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        ModelLoader getLoader() {
            return this.loader;
        }

        public void a(bwg resourceManager) {
        }

        @Override
        public boolean accepts(kk modelLocation) {
            return true;
        }

        @Override
        public IModel loadModel(kk modelLocation) throws Exception {
            String modelPath = modelLocation.a();
            if (modelLocation.a().startsWith("models/")) {
                modelPath = modelPath.substring("models/".length());
            }
            kk armatureLocation = new kk(modelLocation.b(), "armatures/" + modelPath + ".json");
            ModelBlockAnimation animation = Animation.INSTANCE.loadVanillaAnimation(armatureLocation);
            bok model = this.loader.c(modelLocation);
            ModelLoader modelLoader = this.loader;
            ((Object)((Object)modelLoader)).getClass();
            return modelLoader.new VanillaModelWrapper(modelLocation, model, false, animation);
        }

        public String toString() {
            return "VanillaLoader.instance";
        }
    }

    private static final class WeightedRandomModel
    implements IModel {
        private final List<bou> variants;
        private final List<kk> locations = new ArrayList<kk>();
        private final Set<kk> textures = Sets.newHashSet();
        private final List<IModel> models = new ArrayList<IModel>();
        private final IModelState defaultState;

        public WeightedRandomModel(kk parent, bot variants) throws Exception {
            this.variants = variants.a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (bou v : this.variants) {
                kk loc = v.a();
                this.locations.add(loc);
                IModel model = ModelLoaderRegistry.getModel(loc);
                if (v instanceof ISmartVariant) {
                    model = ((ISmartVariant)v).process(model);
                    for (kk location : model.getDependencies()) {
                        ModelLoaderRegistry.getModelOrMissing(location);
                    }
                    this.textures.addAll(model.getTextures());
                }
                this.models.add(model);
                builder.add((Object)Pair.of((Object)model, (Object)v.getState()));
            }
            if (this.models.size() == 0) {
                IModel missing = ModelLoaderRegistry.getMissingModel();
                this.models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            this.defaultState = new MultiModelState(builder.build());
        }

        @Override
        public Collection<kk> getDependencies() {
            return ImmutableList.copyOf(this.locations);
        }

        @Override
        public Collection<kk> getTextures() {
            return ImmutableSet.copyOf(this.textures);
        }

        @Override
        public bxo bake(IModelState state, bvr format, Function<kk, bvh> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla weighted models to the format that doesn't fit into the default one: " + format);
            }
            if (this.variants.size() == 1) {
                IModel model = this.models.get(0);
                return model.bake(MultiModelState.getPartState(state, model, 0), format, bakedTextureGetter);
            }
            bxw.a builder = new bxw.a();
            for (int i = 0; i < this.variants.size(); ++i) {
                IModel model = this.models.get(i);
                builder.a(model.bake(MultiModelState.getPartState(state, model, i), format, bakedTextureGetter), this.variants.get(i).d());
            }
            return builder.a();
        }

        @Override
        public IModelState getDefaultState() {
            return this.defaultState;
        }
    }

    private final class VanillaModelWrapper
    implements IRetexturableModel,
    IModelSimpleProperties,
    IModelUVLock,
    IAnimatedModel {
        private final kk location;
        private final bok model;
        private final boolean uvlock;
        private final ModelBlockAnimation animation;

        public VanillaModelWrapper(kk location, bok model, boolean uvlock, ModelBlockAnimation animation) {
            this.location = location;
            this.model = model;
            this.uvlock = uvlock;
            this.animation = animation;
        }

        @Override
        public Collection<kk> getDependencies() {
            HashSet set = Sets.newHashSet();
            for (kk dep : this.model.e()) {
                if (this.location.equals((Object)dep)) continue;
                set.add(dep);
                ModelLoader.this.stateModels.put(ModelLoader.getInventoryVariant(dep.toString()), ModelLoaderRegistry.getModelOrLogError(dep, "Could not load override model " + dep + " for model " + this.location));
            }
            if (this.model.h() != null && !this.model.h().a().startsWith("builtin/")) {
                set.add(this.model.h());
            }
            return ImmutableSet.copyOf((Collection)set);
        }

        @Override
        public Collection<kk> getTextures() {
            if (this.model.h() != null) {
                if (this.model.h().a().equals("builtin/generated")) {
                    this.model.d = r;
                } else {
                    IModel parent = ModelLoaderRegistry.getModelOrLogError(this.model.h(), "Could not load vanilla model parent '" + this.model.h() + "' for '" + this.model);
                    if (parent instanceof VanillaModelWrapper) {
                        this.model.d = ((VanillaModelWrapper)parent).model;
                    } else {
                        throw new IllegalStateException("vanilla model '" + this.model + "' can't have non-vanilla parent");
                    }
                }
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ModelLoader.this.b(this.model)) {
                for (String s : boo.a) {
                    String r2 = this.model.c(s);
                    kk loc = new kk(r2);
                    if (r2.equals(s)) continue;
                    builder.add((Object)loc);
                }
            }
            for (String s : this.model.c.values()) {
                if (s.startsWith("#")) continue;
                builder.add((Object)new kk(s));
            }
            return builder.build();
        }

        @Override
        public bxo bake(IModelState state, bvr format, Function<kk, bvh> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
            }
            bok model = this.model;
            if (model == null) {
                return ModelLoader.this.getMissingModel().bake(ModelLoader.this.getMissingModel().getDefaultState(), format, bakedTextureGetter);
            }
            ArrayList newTransforms = Lists.newArrayList();
            for (int i = 0; i < model.a().size(); ++i) {
                bog part = (bog)model.a().get(i);
                newTransforms.add(this.animation.getPartTransform(state, part, i));
            }
            bos transforms = model.j();
            HashMap tMap = Maps.newHashMap();
            tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms(transforms));
            tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms(state));
            SimpleModelState perState = new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf((Map)tMap));
            if (ModelLoader.this.b(model)) {
                return new ItemLayerModel(model).bake(perState, format, bakedTextureGetter);
            }
            if (ModelLoader.this.c(model)) {
                return new bxq(transforms, model.g());
            }
            return this.bakeNormal(model, perState, (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.absent()).or((Object)TRSRTransformation.identity()), newTransforms, format, bakedTextureGetter, this.uvlock);
        }

        private bxo bakeNormal(bok model, IModelState perState, final TRSRTransformation modelState, List<TRSRTransformation> newTransforms, final bvr format, final Function<kk, bvh> bakedTextureGetter, boolean uvLocked) {
            bvh particle = (bvh)bakedTextureGetter.apply((Object)new kk(model.c("particle")));
            bxv.a builder = new bxv.a(model, model.g()).a(particle);
            for (int i = 0; i < model.a().size(); ++i) {
                bog part = (bog)model.a().get(i);
                TRSRTransformation transformation = modelState;
                if (newTransforms.get(i) != null) {
                    transformation = transformation.compose(newTransforms.get(i));
                    boi rot = part.d;
                    if (rot == null) {
                        rot = new boi(new Vector3f(), cq.a.b, 0.0f, false);
                    }
                    part = new bog(part.a, part.b, part.c, rot, part.e);
                }
                for (Map.Entry e : part.c.entrySet()) {
                    bvh textureatlassprite1 = (bvh)bakedTextureGetter.apply((Object)new kk(model.c(((boh)e.getValue()).d)));
                    if (((boh)e.getValue()).b == null || !TRSRTransformation.isInteger(transformation.getMatrix())) {
                        builder.a(ModelLoader.this.makeBakedQuad(part, (boh)e.getValue(), textureatlassprite1, (cq)e.getKey(), transformation, uvLocked));
                        continue;
                    }
                    builder.a(modelState.rotate(((boh)e.getValue()).b), ModelLoader.this.makeBakedQuad(part, (boh)e.getValue(), textureatlassprite1, (cq)e.getKey(), transformation, uvLocked));
                }
            }
            return new IPerspectiveAwareModel.MapWrapper(builder.b(), perState){

                @Override
                public List<bof> a(arc state, cq side, long rand) {
                    IExtendedBlockState exState;
                    if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(Properties.AnimationProperty)) {
                        IModelState newState = exState.getValue(Properties.AnimationProperty);
                        IExtendedBlockState newExState = exState.withProperty(Properties.AnimationProperty, null);
                        if (newState != null) {
                            return VanillaModelWrapper.this.bake(new ModelStateComposition(modelState, newState), format, (Function<kk, bvh>)bakedTextureGetter).a((arc)newExState, side, rand);
                        }
                    }
                    return super.a(state, side, rand);
                }
            };
        }

        @Override
        public VanillaModelWrapper retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            ArrayList elements = Lists.newArrayList();
            for (bog part : this.model.a()) {
                elements.add(new bog(part.a, part.b, (Map)Maps.newHashMap((Map)part.c), part.d, part.e));
            }
            bok newModel = new bok(this.model.h(), (List)elements, (Map)Maps.newHashMap((Map)this.model.c), this.model.b(), this.model.c(), this.model.j(), (List)Lists.newArrayList((Iterable)this.model.f()));
            newModel.b = this.model.b;
            newModel.d = this.model.d;
            HashSet removed = Sets.newHashSet();
            for (Map.Entry e : textures.entrySet()) {
                if ("".equals(e.getValue())) {
                    removed.add(e.getKey());
                    newModel.c.remove(e.getKey());
                    continue;
                }
                newModel.c.put(e.getKey(), e.getValue());
            }
            HashMap remapped = Maps.newHashMap();
            for (Map.Entry e : newModel.c.entrySet()) {
                String key;
                if (!((String)e.getValue()).startsWith("#") || !newModel.c.containsKey(key = ((String)e.getValue()).substring(1))) continue;
                remapped.put(e.getKey(), newModel.c.get(key));
            }
            newModel.c.putAll(remapped);
            for (bog part : newModel.a()) {
                Iterator itr = part.c.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    if (!removed.contains(((boh)entry.getValue()).d)) continue;
                    itr.remove();
                }
            }
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public Optional<? extends IClip> getClip(String name) {
            if (this.animation.getClips().containsKey((Object)name)) {
                return Optional.fromNullable((Object)this.animation.getClips().get((Object)name));
            }
            return Optional.absent();
        }

        @Override
        public IModelState getDefaultState() {
            return bxp.a;
        }

        @Override
        public VanillaModelWrapper smoothLighting(boolean value) {
            if (this.model.i == value) {
                return this;
            }
            bok newModel = new bok(this.model.h(), this.model.a(), this.model.c, value, this.model.c(), this.model.j(), (List)Lists.newArrayList((Iterable)this.model.f()));
            newModel.d = this.model.d;
            newModel.b = this.model.b;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public VanillaModelWrapper gui3d(boolean value) {
            if (this.model.c() == value) {
                return this;
            }
            bok newModel = new bok(this.model.h(), this.model.a(), this.model.c, this.model.i, value, this.model.j(), (List)Lists.newArrayList((Iterable)this.model.f()));
            newModel.d = this.model.d;
            newModel.b = this.model.b;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public IModel uvlock(boolean value) {
            if (this.uvlock == value) {
                return this;
            }
            return new VanillaModelWrapper(this.location, this.model, value, this.animation);
        }
    }
}

