/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.MultiLayerModel;
import net.minecraftforge.client.model.b3d.B3DLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.common.FMLLog;

public class ModelLoaderRegistry {
    private static final Set<ICustomModelLoader> loaders = Sets.newHashSet();
    private static final Map<kk, IModel> cache = Maps.newHashMap();
    private static final Deque<kk> loadingModels = Queues.newArrayDeque();
    private static final Set<kk> textures = Sets.newHashSet();

    public static void registerLoader(ICustomModelLoader loader) {
        loaders.add(loader);
        ((bwe)bcf.z().O()).a((bwh)loader);
    }

    public static boolean loaded(kk location) {
        return cache.containsKey(location);
    }

    public static kk getActualLocation(kk location) {
        if (location instanceof bxt) {
            return location;
        }
        if (location.a().startsWith("builtin/")) {
            return location;
        }
        return new kk(location.b(), "models/" + location.a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IModel getModel(kk location) throws Exception {
        IModel model;
        if (cache.containsKey(location)) {
            return cache.get(location);
        }
        for (kk loading : loadingModels) {
            if (location.getClass() != loading.getClass() || !location.equals((Object)loading)) continue;
            throw new LoaderException("circular model dependencies, stack: [" + Joiner.on((String)", ").join(loadingModels) + "]");
        }
        loadingModels.addLast(location);
        try {
            kk actual = ModelLoaderRegistry.getActualLocation(location);
            ICustomModelLoader accepted = null;
            for (ICustomModelLoader loader : loaders) {
                try {
                    if (!loader.accepts(actual)) continue;
                    if (accepted != null) {
                        throw new LoaderException(String.format("2 loaders (%s and %s) want to load the same model %s", accepted, loader, location));
                    }
                    accepted = loader;
                }
                catch (Exception e) {
                    throw new LoaderException(String.format("Exception checking if model %s can be loaded with loader %s, skipping", location, loader), e);
                }
            }
            if (accepted == null) {
                if (ModelLoader.VariantLoader.instance.accepts(actual)) {
                    accepted = ModelLoader.VariantLoader.instance;
                } else if (ModelLoader.VanillaLoader.instance.accepts(actual)) {
                    accepted = ModelLoader.VanillaLoader.instance;
                }
            }
            if (accepted == null) {
                throw new LoaderException("no suitable loader found for the model " + location + ", skipping");
            }
            try {
                model = accepted.loadModel(actual);
            }
            catch (Exception e) {
                throw new LoaderException(String.format("Exception loading model %s with loader %s, skipping", location, accepted), e);
            }
            if (model == ModelLoaderRegistry.getMissingModel()) {
                throw new LoaderException(String.format("Loader %s returned missing model while loading model %s", accepted, location));
            }
            if (model == null) {
                throw new LoaderException(String.format("Loader %s returned null while loading model %s", accepted, location));
            }
            textures.addAll(model.getTextures());
        }
        finally {
            kk popLoc = loadingModels.removeLast();
            if (popLoc != location) {
                throw new IllegalStateException("Corrupted loading model stack: " + popLoc + " != " + location);
            }
        }
        cache.put(location, model);
        for (kk dep : model.getDependencies()) {
            ModelLoaderRegistry.getModelOrMissing(dep);
        }
        return model;
    }

    public static IModel getModelOrMissing(kk location) {
        try {
            return ModelLoaderRegistry.getModel(location);
        }
        catch (Exception e) {
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    public static IModel getModelOrLogError(kk location, String error) {
        try {
            return ModelLoaderRegistry.getModel(location);
        }
        catch (Exception e) {
            FMLLog.getLogger().error(error, (Throwable)e);
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    public static IModel getMissingModel() {
        return ModelLoader.VanillaLoader.instance.getLoader().getMissingModel();
    }

    public static void clearModelCache() {
        cache.clear();
        cache.put(new kk("minecraft:builtin/generated"), ItemLayerModel.instance);
        cache.put(new kk("minecraft:block/builtin/generated"), ItemLayerModel.instance);
        cache.put(new kk("minecraft:item/builtin/generated"), ItemLayerModel.instance);
    }

    static Iterable<kk> getTextures() {
        return textures;
    }

    static {
        ModelLoaderRegistry.registerLoader(B3DLoader.instance);
        ModelLoaderRegistry.registerLoader(OBJLoader.instance);
        ModelLoaderRegistry.registerLoader(ModelFluid.FluidLoader.instance);
        ModelLoaderRegistry.registerLoader(ItemLayerModel.Loader.instance);
        ModelLoaderRegistry.registerLoader(MultiLayerModel.Loader.instance);
        ModelLoaderRegistry.registerLoader(ModelDynBucket.LoaderDynBucket.instance);
    }

    public static class LoaderException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LoaderException(String message) {
            super(message);
        }

        public LoaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

