/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.animation;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraftforge.client.model.animation.AnimationStateMachine;
import net.minecraftforge.client.model.animation.Clips;
import net.minecraftforge.client.model.animation.IClip;
import net.minecraftforge.client.model.animation.ITimeValue;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.client.model.animation.TimeValues;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.common.util.JsonUtils;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public enum Animation implements bwh
{
    INSTANCE;

    private float clientPartialTickTime;
    private bwg manager;
    private final AnimationStateMachine missing = new AnimationStateMachine((ImmutableMap<String, ITimeValue>)ImmutableMap.of(), (ImmutableMap<String, IClip>)ImmutableMap.of((Object)"missingno", (Object)Clips.IdentityClip.instance), (ImmutableList<String>)ImmutableList.of((Object)"missingno"), (ImmutableMap<String, String>)ImmutableMap.of(), "missingno");
    private final Gson asmGson;
    private final Gson mbaGson;
    private final ModelBlockAnimation defaultModelBlockAnimation;

    private Animation() {
        this.missing.initialize();
        this.asmGson = new GsonBuilder().registerTypeAdapter(ImmutableList.class, (Object)JsonUtils.ImmutableListTypeAdapter.INSTANCE).registerTypeAdapter(ImmutableMap.class, (Object)JsonUtils.ImmutableMapTypeAdapter.INSTANCE).registerTypeAdapterFactory((TypeAdapterFactory)Clips.CommonClipTypeAdapterFactory.INSTANCE).registerTypeAdapterFactory((TypeAdapterFactory)TimeValues.CommonTimeValueTypeAdapterFactory.INSTANCE).setPrettyPrinting().enableComplexMapKeySerialization().disableHtmlEscaping().create();
        this.mbaGson = new GsonBuilder().registerTypeAdapter(ImmutableList.class, (Object)JsonUtils.ImmutableListTypeAdapter.INSTANCE).registerTypeAdapter(ImmutableMap.class, (Object)JsonUtils.ImmutableMapTypeAdapter.INSTANCE).setPrettyPrinting().enableComplexMapKeySerialization().disableHtmlEscaping().create();
        this.defaultModelBlockAnimation = new ModelBlockAnimation((ImmutableMap<String, ImmutableMap<String, float[]>>)ImmutableMap.of(), (ImmutableMap<String, ModelBlockAnimation.MBClip>)ImmutableMap.of());
    }

    public static float getWorldTime(aht world) {
        return Animation.getWorldTime(world, 0.0f);
    }

    public static float getWorldTime(aht world, float tickProgress) {
        return ((float)world.P() + tickProgress) / 20.0f;
    }

    public static float getPartialTickTime() {
        return Animation.INSTANCE.clientPartialTickTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAnimationStateMachine load(kk location, ImmutableMap<String, ITimeValue> customParameters) {
        try {
            ClipResolver clipResolver = new ClipResolver();
            ParameterResolver parameterResolver = new ParameterResolver(customParameters);
            Clips.CommonClipTypeAdapterFactory.INSTANCE.setClipResolver(clipResolver);
            TimeValues.CommonTimeValueTypeAdapterFactory.INSTANCE.setValueResolver(parameterResolver);
            bwf resource = this.manager.a(location);
            AnimationStateMachine asm = (AnimationStateMachine)this.asmGson.fromJson((Reader)new InputStreamReader(resource.b(), "UTF-8"), AnimationStateMachine.class);
            clipResolver.asm = asm;
            parameterResolver.asm = asm;
            asm.initialize();
            AnimationStateMachine animationStateMachine = asm;
            return animationStateMachine;
        }
        catch (IOException e) {
            FMLLog.log(Level.ERROR, e, "Exception loading Animation State Machine %s, skipping", location);
            AnimationStateMachine animationStateMachine = this.missing;
            return animationStateMachine;
        }
        catch (JsonParseException e) {
            FMLLog.log(Level.ERROR, e, "Exception loading Animation State Machine %s, skipping", location);
            AnimationStateMachine animationStateMachine = this.missing;
            return animationStateMachine;
        }
        finally {
            Clips.CommonClipTypeAdapterFactory.INSTANCE.setClipResolver(null);
            TimeValues.CommonTimeValueTypeAdapterFactory.INSTANCE.setValueResolver(null);
        }
    }

    public ModelBlockAnimation loadVanillaAnimation(kk armatureLocation) {
        try {
            bwf resource = null;
            try {
                resource = this.manager.a(armatureLocation);
            }
            catch (FileNotFoundException e) {
                return this.defaultModelBlockAnimation;
            }
            ModelBlockAnimation mba = (ModelBlockAnimation)this.mbaGson.fromJson((Reader)new InputStreamReader(resource.b(), "UTF-8"), ModelBlockAnimation.class);
            String json = this.mbaGson.toJson((Object)mba);
            return mba;
        }
        catch (IOException e) {
            FMLLog.log(Level.ERROR, e, "Exception loading vanilla model aniamtion %s, skipping", armatureLocation);
            return this.defaultModelBlockAnimation;
        }
        catch (JsonParseException e) {
            FMLLog.log(Level.ERROR, e, "Exception loading vanilla model aniamtion %s, skipping", armatureLocation);
            return this.defaultModelBlockAnimation;
        }
    }

    public static void setClientPartialTickTime(float clientPartialTickTime) {
        Animation.INSTANCE.clientPartialTickTime = clientPartialTickTime;
    }

    public void a(bwg manager) {
        this.manager = manager;
    }

    private static final class ParameterResolver
    implements Function<String, ITimeValue> {
        private final ImmutableMap<String, ITimeValue> customParameters;
        private AnimationStateMachine asm;

        public ParameterResolver(ImmutableMap<String, ITimeValue> customParameters) {
            this.customParameters = customParameters;
        }

        public ITimeValue apply(String name) {
            if (this.asm.getParameters().containsKey((Object)name)) {
                return (ITimeValue)this.asm.getParameters().get((Object)name);
            }
            return (ITimeValue)this.customParameters.get((Object)name);
        }
    }

    private static final class ClipResolver
    implements Function<String, IClip> {
        private AnimationStateMachine asm;

        private ClipResolver() {
        }

        public IClip apply(String name) {
            return (IClip)this.asm.getClips().get((Object)name);
        }
    }
}

