/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class UnpackedBakedQuad
extends bof {
    protected final float[][][] unpackedData;
    protected final bvr format;
    protected boolean packed = false;

    public UnpackedBakedQuad(float[][][] unpackedData, int tint, cq orientation, bvh texture, boolean applyDiffuseLighting, bvr format) {
        super(new int[format.g()], tint, orientation, texture, applyDiffuseLighting, format);
        this.unpackedData = unpackedData;
        this.format = format;
    }

    public int[] b() {
        if (!this.packed) {
            this.packed = true;
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < this.format.i(); ++e) {
                    LightUtil.pack(this.unpackedData[v][e], this.a, this.format, v, e);
                }
            }
        }
        return this.a;
    }

    public void pipe(IVertexConsumer consumer) {
        int[] eMap = LightUtil.mapFormats(consumer.getVertexFormat(), this.format);
        if (this.c()) {
            consumer.setQuadTint(this.d());
        }
        consumer.setQuadOrientation(this.e());
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < consumer.getVertexFormat().i(); ++e) {
                if (eMap[e] != this.format.i()) {
                    consumer.put(e, this.unpackedData[v][eMap[e]]);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static class Builder
    implements IVertexConsumer {
        private final bvr format;
        private final float[][][] unpackedData;
        private int tint = -1;
        private cq orientation;
        private bvh texture;
        private boolean applyDiffuseLighting;
        private int vertices = 0;
        private int elements = 0;
        private boolean full = false;

        public Builder(bvr format) {
            this.format = format;
            this.unpackedData = new float[4][format.i()][4];
        }

        @Override
        public bvr getVertexFormat() {
            return this.format;
        }

        @Override
        public void setQuadTint(int tint) {
            this.tint = tint;
        }

        @Override
        public void setQuadOrientation(cq orientation) {
            this.orientation = orientation;
        }

        public void setTexture(bvh texture) {
            this.texture = texture;
        }

        @Override
        public void setApplyDiffuseLighting(boolean diffuse) {
            this.applyDiffuseLighting = diffuse;
        }

        @Override
        public void put(int element, float ... data) {
            for (int i = 0; i < 4; ++i) {
                this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
            }
            ++this.elements;
            if (this.elements == this.format.i()) {
                ++this.vertices;
                this.elements = 0;
            }
            if (this.vertices == 4) {
                this.full = true;
            }
        }

        public UnpackedBakedQuad build() {
            if (!this.full) {
                throw new IllegalStateException("not enough data");
            }
            return new UnpackedBakedQuad(this.unpackedData, this.tint, this.orientation, this.texture, this.applyDiffuseLighting, this.format);
        }
    }
}

