/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ForgeHooks {
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static final Pattern URL_PATTERN;
    private static ThreadLocal<zj> craftingPlayer;

    public static adq getGrassSeed(Random rand, int fortune) {
        SeedEntry entry = (SeedEntry)ov.a((Random)rand, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.getStack(rand, fortune);
    }

    public static boolean canHarvestBlock(ajt block, zj player, ahx world, cj pos) {
        arc state = world.o(pos);
        if ((state = state.t().b(state, world, pos)).a().l()) {
            return true;
        }
        adq stack = player.br.h();
        String tool = block.getHarvestTool(state);
        if (stack == null || tool == null) {
            return player.b(state);
        }
        int toolLevel = stack.b().getHarvestLevel(stack, tool);
        if (toolLevel < 0) {
            return player.b(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    public static boolean canToolHarvestBlock(ahx world, cj pos, adq stack) {
        arc state = world.o(pos);
        state = state.t().b(state, world, pos);
        String tool = state.t().getHarvestTool(state);
        if (stack == null || tool == null) {
            return false;
        }
        return stack.b().getHarvestLevel(stack, tool) >= state.t().getHarvestLevel(state);
    }

    public static float blockStrength(arc state, zj player, aht world, cj pos) {
        float hardness = state.b(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(state.t(), player, (ahx)world, pos)) {
            return player.getBreakSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getBreakSpeed(state, pos) / hardness / 30.0f;
    }

    public static boolean isToolEffective(ahx world, cj pos, adq stack) {
        arc state = world.o(pos);
        state = state.t().b(state, world, pos);
        for (String type : stack.b().getToolClasses(stack)) {
            if (!state.t().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        Set blocks = (Set)ReflectionHelper.getPrivateValue(aeb.class, null, 0);
        for (ajt block : blocks) {
            block.setHarvestLevel("pickaxe", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(aen.class, null, 0);
        for (ajt block : blocks) {
            block.setHarvestLevel("shovel", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(abz.class, null, 0);
        for (ajt block : blocks) {
            block.setHarvestLevel("axe", 0);
        }
        aju.Z.setHarvestLevel("pickaxe", 3);
        for (ajt block : new ajt[]{aju.bP, aju.bT, aju.ag, aju.ah, aju.o, aju.R, aju.aC, aju.aD}) {
            block.setHarvestLevel("pickaxe", 2);
        }
        aju.p.setHarvestLevel("pickaxe", 1);
        aju.S.setHarvestLevel("pickaxe", 1);
        aju.x.setHarvestLevel("pickaxe", 1);
        aju.y.setHarvestLevel("pickaxe", 1);
        aju.co.setHarvestLevel("pickaxe", 0);
    }

    public static int getTotalArmorValue(zj player) {
        int ret = 0;
        for (int x = 0; x < player.br.b.length; ++x) {
            adq stack = player.br.b[x];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)stack.b()).getArmorDisplay(player, stack, x);
                continue;
            }
            if (stack == null || !(stack.b() instanceof abw)) continue;
            ret += ((abw)stack.b()).d;
        }
        return ret;
    }

    public static boolean onPickBlock(bbi target, zj player, aht world) {
        adq result = null;
        boolean isCreative = player.bJ.d;
        apv te = null;
        if (target.a == bbi.a.b) {
            arc state = world.o(target.a());
            if (state.t().isAir(state, (ahx)world, target.a())) {
                return false;
            }
            if (isCreative && bfb.q() && state.t().hasTileEntity(state)) {
                te = world.r(target.a());
            }
            result = state.t().getPickBlock(state, target, world, target.a(), player);
        } else {
            if (target.a != bbi.a.c || target.d == null || !isCreative) {
                return false;
            }
            result = target.d.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        if (result.b() == null) {
            String s1 = "";
            if (target.a == bbi.a.b) {
                s1 = ((kk)ajt.h.b((Object)world.o(target.a()).t())).toString();
            } else if (target.a == bbi.a.c) {
                s1 = rt.b((rr)target.d);
            }
            FMLLog.warning("Picking on: [%s] %s gave null item", target.a, s1);
            return true;
        }
        if (te != null) {
            bcf.z().a(result, te);
        }
        if (isCreative) {
            player.br.a(result);
            bcf.z().c.a(player.b(qm.a), 36 + player.br.d);
            return true;
        }
        int slot = player.br.b(result);
        if (slot != -1) {
            if (zi.e((int)slot)) {
                player.br.d = slot;
            } else {
                bcf.z().c.a(slot);
            }
            return true;
        }
        return false;
    }

    public static void onLivingSetAttackTarget(sa entity, sa target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(sa entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(sa entity, rc src, float amount) {
        return !MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static float onLivingHurt(sa entity, rc src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.ammount;
    }

    public static boolean onLivingDeath(sa entity, rc src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(sa entity, rc source, ArrayList<yd> drops, int lootingLevel, boolean recentlyHit) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit));
    }

    public static float[] onLivingFall(sa entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.distance;
            fArray = fArray2;
            fArray2[1] = event.damageMultiplier;
        }
        return fArray;
    }

    public static boolean isLivingOnLadder(arc state, aht world, cj pos, sa entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof zj && ((zj)entity).y();
        if (isSpectator) {
            return false;
        }
        if (!ForgeModContainer.fullBoundingBoxLadders) {
            return state != null && state.t().isLadder(state, (ahx)world, pos, entity);
        }
        bbh bb = entity.bl();
        int mX = on.c((double)bb.a);
        int mY = on.c((double)bb.b);
        int mZ = on.c((double)bb.c);
        int y2 = mY;
        while ((double)y2 < bb.e) {
            int x2 = mX;
            while ((double)x2 < bb.d) {
                int z2 = mZ;
                while ((double)z2 < bb.f) {
                    cj tmp = new cj(x2, y2, z2);
                    state = world.o(tmp);
                    if (state.t().isLadder(state, (ahx)world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(sa entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    public static yd onPlayerTossEvent(zj player, adq item, boolean includeName) {
        player.captureDrops = true;
        yd ret = player.a(item, false, includeName);
        player.capturedDrops.clear();
        player.captureDrops = false;
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        player.e().a((rr)event.entityItem);
        return event.entityItem;
    }

    public static float getEnchantPower(aht world, cj pos) {
        return world.o(pos).t().getEnchantPowerBonus(world, pos);
    }

    public static eu onServerChatEvent(mb net, String raw, eu comp) {
        ServerChatEvent event = new ServerChatEvent(net.b, raw, comp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.getComponent();
    }

    public static eu newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static eu newChatWithLinks(String string, boolean allowMissingHeader) {
        fa ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            fa link;
            String url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new fa(part);
                    } else {
                        ichat.a(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new fa(url);
                try {
                    if (new URI(url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new fa(url);
                            continue;
                        }
                        ichat.a(url);
                        continue;
                    }
                    url = "http://" + url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = new fa(url);
                        continue;
                    }
                    ichat.a(url);
                    continue;
                }
            }
            et click = new et(et.a.a, url);
            link.b().a(click);
            link.b().d(Boolean.valueOf(true));
            link.b().a(a.j);
            if (ichat == null) {
                ichat = link;
                continue;
            }
            ichat.a((eu)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new fa(end);
        } else if (end.length() > 0) {
            ichat.a(string.substring(lastEnd));
        }
        return ichat;
    }

    public static boolean canInteractWith(zj player, aau openContainer) {
        PlayerOpenContainerEvent event = new PlayerOpenContainerEvent(player, openContainer);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult() == Event.Result.DEFAULT ? event.canInteractWith : event.getResult() == Event.Result.ALLOW;
    }

    public static int onBlockBreakEvent(aht world, ahw.a gameType, lr entityPlayer, cj pos) {
        boolean preCancelEvent = false;
        if (gameType.d() && entityPlayer.cb() != null && entityPlayer.cb().b() instanceof aex) {
            preCancelEvent = true;
        }
        if (gameType.c()) {
            adq itemstack;
            if (gameType == ahw.a.e) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.cU() || (itemstack = entityPlayer.cb()) != null && itemstack.a(world.o(pos).t()))) {
                preCancelEvent = true;
            }
        }
        if (world.r(pos) == null) {
            fu packet = new fu(world, pos);
            packet.b = aju.a.u();
            entityPlayer.a.a((ff)packet);
        }
        arc state = world.o(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (zj)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled()) {
            ff pkt;
            entityPlayer.a.a((ff)new fu(world, pos));
            apv tileentity = world.r(pos);
            if (tileentity != null && (pkt = tileentity.D_()) != null) {
                entityPlayer.a.a(pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static qo onPlaceItemIntoWorld(adq itemstack, zj player, aht world, cj pos, cq side, float hitX, float hitY, float hitZ, qm hand) {
        int meta = itemstack.h();
        int size = itemstack.b;
        dn nbt = null;
        if (itemstack.o() != null) {
            nbt = (dn)itemstack.o().b();
        }
        if (!(itemstack.b() instanceof acj)) {
            world.captureBlockSnapshots = true;
        }
        qo ret = itemstack.b().a(itemstack, player, world, pos, hand, side, hitX, hitY, hitZ);
        world.captureBlockSnapshots = false;
        if (ret == qo.a) {
            int newMeta = itemstack.h();
            int newSize = itemstack.b;
            dn newNBT = null;
            if (itemstack.o() != null) {
                newNBT = (dn)itemstack.o().b();
            }
            BlockEvent.PlaceEvent placeEvent = null;
            List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
            world.capturedBlockSnapshots.clear();
            itemstack.b(meta);
            itemstack.b = size;
            if (nbt != null) {
                itemstack.d(nbt);
            }
            if (blockSnapshots.size() > 1) {
                placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace(player, blockSnapshots, side);
            } else if (blockSnapshots.size() == 1) {
                placeEvent = ForgeEventFactory.onPlayerBlockPlace(player, (BlockSnapshot)blockSnapshots.get(0), side);
            }
            if (placeEvent != null && placeEvent.isCanceled()) {
                ret = qo.c;
                for (BlockSnapshot blocksnapshot : blockSnapshots) {
                    world.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    world.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.b(newMeta);
                itemstack.b = newSize;
                if (nbt != null) {
                    itemstack.d(newNBT);
                }
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.flag;
                    arc oldBlock = snap.replacedBlock;
                    arc newBlock = world.o(snap.pos);
                    if (newBlock != null && !newBlock.t().hasTileEntity(newBlock)) {
                        newBlock.t().c(world, snap.pos, newBlock);
                    }
                    world.markAndNotifyBlock(snap.pos, null, oldBlock, newBlock, updateFlag);
                }
                player.b(nt.a((ado)itemstack.b()));
            }
        }
        world.capturedBlockSnapshots.clear();
        return ret;
    }

    public static boolean onAnvilChange(aaw container, adq left, adq right, qg outputSlot, String name, int baseCost) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            return false;
        }
        if (e.output == null) {
            return true;
        }
        outputSlot.a(0, e.output);
        container.a = e.cost;
        container.k = e.materialCost;
        return false;
    }

    public static float onAnvilRepair(zj player, adq output, adq left, adq right) {
        AnvilRepairEvent e = new AnvilRepairEvent(player, left, right, output);
        MinecraftForge.EVENT_BUS.post(e);
        return e.breakChance;
    }

    public static boolean onNoteChange(aql te, byte old) {
        NoteBlockEvent.Change e = new NoteBlockEvent.Change(te.D(), te.v(), te.D().o(te.v()), old, te.a);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            te.a = old;
            return false;
        }
        te.a = (byte)e.getVanillaNoteId();
        return true;
    }

    public static adq[] defaultRecipeGetRemainingItems(abc inv) {
        adq[] ret = new adq[inv.u_()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ForgeHooks.getContainerItem(inv.a(i));
        }
        return ret;
    }

    public static void setCraftingPlayer(zj player) {
        craftingPlayer.set(player);
    }

    public static zj getCraftingPlayer() {
        return craftingPlayer.get();
    }

    public static adq getContainerItem(adq stack) {
        if (stack == null) {
            return null;
        }
        if (stack.b().hasContainerItem(stack)) {
            if ((stack = stack.b().getContainerItem(stack)) != null && stack.e() && stack.i() > stack.j()) {
                ForgeEventFactory.onPlayerDestroyItem(craftingPlayer.get(), stack, null);
                return null;
            }
            return stack;
        }
        return null;
    }

    public static boolean isInsideOfMaterial(axe material, rr entity, cj pos) {
        arc state = entity.l.o(pos);
        ajt block = state.t();
        double eyes = entity.q + (double)entity.bn();
        double filled = 1.0;
        if (block instanceof IFluidBlock) {
            filled = ((IFluidBlock)block).getFilledPercentage(entity.l, pos);
        } else if (block instanceof amo) {
            filled = amo.e((int)block.e(state));
        }
        if (filled < 0.0) {
            return eyes > (double)(pos.q() + 1) + (1.0 - (filled *= -1.0));
        }
        return eyes < (double)(pos.q() + 1) + filled;
    }

    public static boolean onPlayerAttackTarget(zj player, rr target) {
        if (MinecraftForge.EVENT_BUS.post(new AttackEntityEvent(player, target))) {
            return false;
        }
        adq stack = player.cb();
        return stack == null || !stack.b().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(rr entity, int dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled() && entity instanceof aak) {
            ((aak)entity).b = true;
        }
        return !event.isCanceled();
    }

    public static bbi rayTraceEyes(sa entity, double length) {
        bbj startPos = new bbj(entity.p, entity.q + (double)entity.bn(), entity.r);
        bbj endPos = startPos.e(new bbj(entity.aB().b * length, entity.aB().c * length, entity.aB().d * length));
        return entity.l.a(startPos, endPos);
    }

    public static bbj rayTraceEyeHitVec(sa entity, double length) {
        bbi git = ForgeHooks.rayTraceEyes(entity, length);
        return git == null ? null : git.c;
    }

    static {
        seedList.add(new SeedEntry(new adq(ads.P), 10){

            @Override
            public adq getStack(Random rand, int fortune) {
                return new adq(ads.P, 1 + rand.nextInt(fortune * 2 + 1));
            }
        });
        ForgeHooks.initTools();
        URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_\\.]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
        craftingPlayer = new ThreadLocal();
    }

    static class SeedEntry
    extends ov.a {
        public final adq seed;

        public SeedEntry(adq seed, int weight) {
            super(weight);
            this.seed = seed;
        }

        public adq getStack(Random rand, int fortune) {
            return this.seed.k();
        }
    }
}

