/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.io.Serializable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockSnapshot
implements Serializable {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    public final cj pos;
    public final int dimId;
    public transient arc replacedBlock;
    public int flag;
    private final dn nbt;
    public transient aht world;
    public final GameRegistry.UniqueIdentifier blockIdentifier;
    public final int meta;

    public BlockSnapshot(aht world, cj pos, arc state) {
        this.world = world;
        this.dimId = world.s.getDimension();
        this.pos = pos;
        this.replacedBlock = state;
        this.blockIdentifier = GameRegistry.findUniqueIdentifierFor(state.t());
        this.meta = state.t().e(state);
        this.flag = 3;
        apv te = world.r(pos);
        if (te != null) {
            this.nbt = new dn();
            te.b(this.nbt);
        } else {
            this.nbt = null;
        }
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.T().j(), pos.p(), pos.q(), pos.r(), this.blockIdentifier, this.meta);
        }
    }

    public BlockSnapshot(aht world, cj pos, arc state, dn nbt) {
        this.world = world;
        this.dimId = world.s.getDimension();
        this.pos = pos.getImmutable();
        this.replacedBlock = state;
        this.blockIdentifier = GameRegistry.findUniqueIdentifierFor(state.t());
        this.meta = state.t().e(state);
        this.flag = 3;
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.T().j(), pos.p(), pos.q(), pos.r(), this.blockIdentifier, this.meta);
        }
    }

    public BlockSnapshot(aht world, cj pos, arc state, int flag) {
        this(world, pos, state);
        this.flag = flag;
    }

    public BlockSnapshot(int dimension, cj pos, String modid, String blockName, int meta, int flag, dn nbt) {
        this.dimId = dimension;
        this.pos = pos.getImmutable();
        this.flag = flag;
        this.blockIdentifier = new GameRegistry.UniqueIdentifier(modid + ":" + blockName);
        this.meta = meta;
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(aht world, cj pos) {
        return new BlockSnapshot(world, pos, world.o(pos));
    }

    public static BlockSnapshot getBlockSnapshot(aht world, cj pos, int flag) {
        return new BlockSnapshot(world, pos, world.o(pos), flag);
    }

    public static BlockSnapshot readFromNBT(dn tag) {
        dn nbt = tag.p("hasTE") ? null : tag.o("tileEntity");
        return new BlockSnapshot(tag.h("dimension"), new cj(tag.h("posX"), tag.h("posY"), tag.h("posZ")), tag.l("blockMod"), tag.l("blockName"), tag.h("metadata"), tag.h("flag"), nbt);
    }

    public arc getCurrentBlock() {
        return this.world.o(this.pos);
    }

    public aht getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld(this.dimId);
        }
        return this.world;
    }

    public arc getReplacedBlock() {
        if (this.replacedBlock == null) {
            this.replacedBlock = GameRegistry.findBlock(this.blockIdentifier.modId, this.blockIdentifier.name).a(this.meta);
        }
        return this.replacedBlock;
    }

    public apv getTileEntity() {
        if (this.nbt != null) {
            return apv.a((MinecraftServer)this.getWorld().u(), (dn)this.nbt);
        }
        return null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean applyPhysics) {
        arc current = this.getCurrentBlock();
        arc replaced = this.getReplacedBlock();
        if (current.t() != replaced.t() || current.t().e(current) != replaced.t().e(replaced)) {
            if (force) {
                this.world.a(this.pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        this.world.a(this.pos, replaced, applyPhysics ? 3 : 2);
        this.world.a(this.pos, current, replaced, applyPhysics ? 3 : 2);
        apv te = null;
        if (this.nbt != null && (te = this.world.r(this.pos)) != null) {
            te.a(this.nbt);
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", this.world.T().j(), this.pos.p(), this.pos.q(), this.pos.r(), replaced.t().e(replaced), replaced.t().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public boolean restoreToLocation(aht world, cj pos, boolean force, boolean applyPhysics) {
        arc current = this.getCurrentBlock();
        arc replaced = this.getReplacedBlock();
        if (current.t() != replaced.t() || current.t().e(current) != replaced.t().e(replaced)) {
            if (force) {
                world.a(pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        world.a(pos, replaced, applyPhysics ? 3 : 2);
        world.a(pos, current, replaced, applyPhysics ? 3 : 2);
        apv te = null;
        if (this.nbt != null && (te = world.r(pos)) != null) {
            te.a(this.nbt);
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", world.T().j(), pos.p(), pos.q(), pos.r(), replaced.t().e(replaced), replaced.t().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public void writeToNBT(dn compound) {
        compound.a("blockMod", this.blockIdentifier.modId);
        compound.a("blockName", this.blockIdentifier.name);
        compound.a("posX", this.pos.p());
        compound.a("posY", this.pos.q());
        compound.a("posZ", this.pos.r());
        compound.a("flag", this.flag);
        compound.a("dimension", this.dimId);
        compound.a("metadata", this.meta);
        compound.a("hasTE", this.nbt != null);
        if (this.nbt != null) {
            compound.a("tileEntity", (eb)this.nbt);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        if (!this.pos.equals((Object)other.pos)) {
            return false;
        }
        if (this.meta != other.meta) {
            return false;
        }
        if (this.dimId != other.dimId) {
            return false;
        }
        if (!(this.nbt == other.nbt || this.nbt != null && this.nbt.equals((Object)other.nbt))) {
            return false;
        }
        if (!(this.world == other.world || this.world != null && this.world.equals(other.world))) {
            return false;
        }
        return this.blockIdentifier == other.blockIdentifier || this.blockIdentifier != null && this.blockIdentifier.equals(other.blockIdentifier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.pos.p();
        hash = 73 * hash + this.pos.q();
        hash = 73 * hash + this.pos.r();
        hash = 73 * hash + this.meta;
        hash = 73 * hash + this.dimId;
        hash = 73 * hash + (this.nbt != null ? this.nbt.hashCode() : 0);
        hash = 73 * hash + (this.world != null ? this.world.hashCode() : 0);
        hash = 73 * hash + (this.blockIdentifier != null ? this.blockIdentifier.hashCode() : 0);
        return hash;
    }
}

