/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.io.File;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ForgeEventFactory {
    public static BlockEvent.MultiPlaceEvent onPlayerMultiBlockPlace(zj player, List<BlockSnapshot> blockSnapshots, cq direction) {
        BlockSnapshot snap = blockSnapshots.get(0);
        arc placedAgainst = snap.world.o(snap.pos.a(direction.d()));
        BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(blockSnapshots, placedAgainst, player);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.PlaceEvent onPlayerBlockPlace(zj player, BlockSnapshot blockSnapshot, cq direction) {
        arc placedAgainst = blockSnapshot.world.o(blockSnapshot.pos.a(direction.d()));
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blockSnapshot, placedAgainst, player);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.NeighborNotifyEvent onNeighborNotify(aht world, cj pos, arc state, EnumSet<cq> notifiedSides) {
        BlockEvent.NeighborNotifyEvent event = new BlockEvent.NeighborNotifyEvent(world, pos, state, notifiedSides);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static boolean doPlayerHarvestCheck(zj player, arc state, boolean success) {
        PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck(player, state, success);
        MinecraftForge.EVENT_BUS.post(event);
        return event.canHarvest();
    }

    public static float getBreakSpeed(zj player, arc state, float original, cj pos) {
        PlayerEvent.BreakSpeed event = new PlayerEvent.BreakSpeed(player, state, original, pos);
        return MinecraftForge.EVENT_BUS.post(event) ? -1.0f : event.newSpeed;
    }

    @Deprecated
    public static PlayerInteractEvent onPlayerInteract(zj player, PlayerInteractEvent.Action action, aht world, cj pos, cq face) {
        return ForgeEventFactory.onPlayerInteract(player, action, world, pos, face, null);
    }

    public static PlayerInteractEvent onPlayerInteract(zj player, PlayerInteractEvent.Action action, aht world, cj pos, cq face, bbj localPos) {
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, pos, face, world, localPos);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static void onPlayerDestroyItem(zj player, adq stack, qm hand) {
        MinecraftForge.EVENT_BUS.post(new PlayerDestroyItemEvent(player, stack, hand));
    }

    public static Event.Result canEntitySpawn(sb entity, aht world, float x, float y, float z) {
        LivingSpawnEvent.CheckSpawn event = new LivingSpawnEvent.CheckSpawn(entity, world, x, y, z);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static boolean doSpecialSpawn(sb entity, aht world, float x, float y, float z) {
        return MinecraftForge.EVENT_BUS.post(new LivingSpawnEvent.SpecialSpawn(entity, world, x, y, z));
    }

    public static Event.Result canEntityDespawn(sb entity) {
        LivingSpawnEvent.AllowDespawn event = new LivingSpawnEvent.AllowDespawn(entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static int getExperienceDrop(sa entity, zj attackingPlayer, int originalExperience) {
        LivingExperienceDropEvent event = new LivingExperienceDropEvent(entity, attackingPlayer, originalExperience);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return 0;
        }
        return event.getDroppedExperience();
    }

    public static List<aig.c> getPotentialSpawns(lp world, sc type, cj pos, List<aig.c> oldList) {
        WorldEvent.PotentialSpawns event = new WorldEvent.PotentialSpawns((aht)world, type, pos, oldList);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.list;
    }

    public static int getMaxSpawnPackSize(sb entity) {
        LivingPackSizeEvent maxCanSpawnEvent = new LivingPackSizeEvent(entity);
        MinecraftForge.EVENT_BUS.post(maxCanSpawnEvent);
        return maxCanSpawnEvent.getResult() == Event.Result.ALLOW ? maxCanSpawnEvent.maxPackSize : entity.cJ();
    }

    public static String getPlayerDisplayName(zj player, String username) {
        PlayerEvent.NameFormat event = new PlayerEvent.NameFormat(player, username);
        MinecraftForge.EVENT_BUS.post(event);
        return event.displayname;
    }

    public static float fireBlockHarvesting(List<adq> drops, aht world, cj pos, arc state, int fortune, float dropChance, boolean silkTouch, zj player) {
        BlockEvent.HarvestDropsEvent event = new BlockEvent.HarvestDropsEvent(world, pos, state, fortune, dropChance, drops, player, silkTouch);
        MinecraftForge.EVENT_BUS.post(event);
        return event.dropChance;
    }

    public static ItemTooltipEvent onItemTooltip(adq itemStack, zj entityPlayer, List<String> toolTip, boolean showAdvancedItemTooltips) {
        ItemTooltipEvent event = new ItemTooltipEvent(itemStack, entityPlayer, toolTip, showAdvancedItemTooltips);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static ZombieEvent.SummonAidEvent fireZombieSummonAid(za zombie, aht world, int x, int y, int z, sa attacker, double summonChance) {
        ZombieEvent.SummonAidEvent summonEvent = new ZombieEvent.SummonAidEvent(zombie, world, x, y, z, attacker, summonChance);
        MinecraftForge.EVENT_BUS.post(summonEvent);
        return summonEvent;
    }

    public static boolean onEntityStruckByLightning(rr entity, ya bolt) {
        return MinecraftForge.EVENT_BUS.post(new EntityStruckByLightningEvent(entity, bolt));
    }

    public static int onItemUseStart(sa entity, adq item, int duration) {
        LivingEntityUseItemEvent.Start event = new LivingEntityUseItemEvent.Start(entity, item, duration);
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.duration;
    }

    public static int onItemUseTick(sa entity, adq item, int duration) {
        LivingEntityUseItemEvent.Tick event = new LivingEntityUseItemEvent.Tick(entity, item, duration);
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.duration;
    }

    public static boolean onUseItemStop(sa entity, adq item, int duration) {
        return MinecraftForge.EVENT_BUS.post(new LivingEntityUseItemEvent.Stop(entity, item, duration));
    }

    public static adq onItemUseFinish(sa entity, adq item, int duration, adq result) {
        LivingEntityUseItemEvent.Finish event = new LivingEntityUseItemEvent.Finish(entity, item, duration, result);
        MinecraftForge.EVENT_BUS.post(event);
        return event.result;
    }

    public static void onStartEntityTracking(rr entity, zj player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StartTracking(player, entity));
    }

    public static void onStopEntityTracking(rr entity, zj player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StopTracking(player, entity));
    }

    public static void firePlayerLoadingEvent(zj player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerSavingEvent(zj player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.SaveToFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerLoadingEvent(zj player, azq playerFileData, String uuidString) {
        azf sh = (azf)playerFileData;
        File dir = (File)ObfuscationReflectionHelper.getPrivateValue(azf.class, sh, "playersDirectory", "field_75771_c");
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, dir, uuidString));
    }

    public static eu onClientChat(byte type, eu message) {
        ClientChatReceivedEvent event = new ClientChatReceivedEvent(type, message);
        return MinecraftForge.EVENT_BUS.post(event) ? null : event.message;
    }

    public static int onHoeUse(adq stack, zj player, aht worldIn, cj pos) {
        UseHoeEvent event = new UseHoeEvent(player, stack, worldIn, pos);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            stack.a(1, (sa)player);
            return 1;
        }
        return 0;
    }

    public static int onApplyBonemeal(zj player, aht world, cj pos, arc state, adq stack) {
        BonemealEvent event = new BonemealEvent(player, world, pos, state);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (!world.E) {
                --stack.b;
            }
            return 1;
        }
        return 0;
    }

    public static qp<adq> onBucketUse(zj player, aht world, adq stack, bbi target) {
        FillBucketEvent event = new FillBucketEvent(player, stack, world, target);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return new qp(qo.c, (Object)stack);
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (player.bJ.d) {
                return new qp(qo.a, (Object)stack);
            }
            if (--stack.b <= 0) {
                return new qp(qo.a, (Object)event.getFilledBucket());
            }
            if (!player.br.c(event.getFilledBucket())) {
                player.a(event.getFilledBucket(), false);
            }
            return new qp(qo.a, (Object)stack);
        }
        return null;
    }

    public static boolean canEntityUpdate(rr entity) {
        EntityEvent.CanUpdate event = new EntityEvent.CanUpdate(entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event.canUpdate;
    }

    public static PlaySoundAtEntityEvent onPlaySoundAtEntity(rr entity, nf name, nh category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = new PlaySoundAtEntityEvent(entity, name, category, volume, pitch);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static int onItemExpire(yd entity, adq item) {
        if (item == null) {
            return -1;
        }
        ItemExpireEvent event = new ItemExpireEvent(entity, item.b() == null ? 6000 : item.b().getEntityLifespan(item, entity.l));
        if (!MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.extraLife;
    }

    public static int onItemPickup(yd entityItem, zj entityIn, adq itemstack) {
        EntityItemPickupEvent event = new EntityItemPickupEvent(entityIn, entityItem);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.getResult() == Event.Result.ALLOW ? 1 : 0;
    }

    public static void onPlayerDrops(zj player, rc cause, List<yd> capturedDrops, boolean recentlyHit) {
        PlayerDropsEvent event = new PlayerDropsEvent(player, cause, capturedDrops, recentlyHit);
        if (!MinecraftForge.EVENT_BUS.post(event)) {
            for (yd item : capturedDrops) {
                player.a(item);
            }
        }
    }

    public static boolean canInteractWith(zj player, rr entity, adq item, qm hand) {
        return !MinecraftForge.EVENT_BUS.post(new EntityInteractEvent(player, entity, item, hand));
    }

    public static boolean canMountEntity(rr entityMounting, rr entityBeingMounted, boolean isMounting) {
        boolean isCanceled = MinecraftForge.EVENT_BUS.post(new EntityMountEvent(entityMounting, entityBeingMounted, entityMounting.l, isMounting));
        if (isCanceled) {
            entityMounting.a(entityMounting.p, entityMounting.q, entityMounting.r, entityMounting.x, entityMounting.y);
            return false;
        }
        return true;
    }

    public static zj.a onPlayerSleepInBed(zj player, cj pos) {
        PlayerSleepInBedEvent event = new PlayerSleepInBedEvent(player, pos);
        MinecraftForge.EVENT_BUS.post(event);
        return event.result;
    }

    public static void onPlayerWakeup(zj player, boolean wakeImmediatly, boolean updateWorldFlag, boolean setSpawn) {
        MinecraftForge.EVENT_BUS.post(new PlayerWakeUpEvent(player, wakeImmediatly, updateWorldFlag, setSpawn));
    }

    public static void onPlayerFall(zj player, float distance, float multiplier) {
        MinecraftForge.EVENT_BUS.post(new PlayerFlyableFallEvent(player, distance, multiplier));
    }

    public static boolean onPlayerSpawnSet(zj player, cj pos, boolean forced) {
        return MinecraftForge.EVENT_BUS.post(new PlayerSetSpawnEvent(player, pos, forced));
    }

    public static void onPlayerClone(zj player, zj oldPlayer, boolean wasDeath) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.Clone(player, oldPlayer, wasDeath));
    }

    public static boolean onExplosionStart(aht world, ahp explosion) {
        return MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Start(world, explosion));
    }

    public static void onExplosionDetonate(aht world, ahp explosion, List<rr> list, double diameter) {
        MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Detonate(world, explosion, list));
    }

    public static boolean onCreateWorldSpawn(aht world, ahw settings) {
        return MinecraftForge.EVENT_BUS.post(new WorldEvent.CreateSpawnPosition(world, settings));
    }

    public static float onLivingHeal(sa entity, float amount) {
        LivingHealEvent event = new LivingHealEvent(entity, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.amount;
    }

    public static boolean onPotionAttemptBreaw(adq[] stacks) {
        adq[] tmp = new adq[stacks.length];
        for (int x = 0; x < tmp.length; ++x) {
            tmp[x] = adq.c((adq)stacks[x]);
        }
        PotionBrewEvent.Pre event = new PotionBrewEvent.Pre(tmp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            boolean changed = false;
            for (int x = 0; x < stacks.length; ++x) {
                changed |= adq.b((adq)tmp[x], (adq)stacks[x]);
                stacks[x] = event.getItem(x);
            }
            if (changed) {
                ForgeEventFactory.onPotionBrewed(stacks);
            }
            return true;
        }
        return false;
    }

    public static void onPotionBrewed(adq[] brewingItemStacks) {
        MinecraftForge.EVENT_BUS.post(new PotionBrewEvent.Post(brewingItemStacks));
    }

    public static boolean renderFireOverlay(zj player, float renderPartialTicks) {
        return ForgeEventFactory.renderBlockOverlay(player, renderPartialTicks, RenderBlockOverlayEvent.OverlayType.FIRE, aju.ab.u(), new cj((rr)player));
    }

    public static boolean renderWaterOverlay(zj player, float renderPartialTicks) {
        return ForgeEventFactory.renderBlockOverlay(player, renderPartialTicks, RenderBlockOverlayEvent.OverlayType.WATER, aju.j.u(), new cj((rr)player));
    }

    public static boolean renderBlockOverlay(zj player, float renderPartialTicks, RenderBlockOverlayEvent.OverlayType type, arc block, cj pos) {
        return MinecraftForge.EVENT_BUS.post(new RenderBlockOverlayEvent(player, renderPartialTicks, type, block, pos));
    }

    public static CapabilityDispatcher gatherCapabilities(apv tileEntity) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent.TileEntity(tileEntity), null);
    }

    public static CapabilityDispatcher gatherCapabilities(rr entity) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent.Entity(entity), null);
    }

    public static CapabilityDispatcher gatherCapabilities(ado item, adq stack, ICapabilityProvider parent) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent.Item(item, stack), parent);
    }

    private static CapabilityDispatcher gatherCapabilities(AttachCapabilitiesEvent event, ICapabilityProvider parent) {
        MinecraftForge.EVENT_BUS.post(event);
        return event.getCapabilities().size() > 0 || parent != null ? new CapabilityDispatcher(event.getCapabilities(), parent) : null;
    }

    public static boolean fireSleepingLocationCheck(zj player, cj sleepingLocation) {
        SleepingLocationCheckEvent evt = new SleepingLocationCheckEvent(player, sleepingLocation);
        MinecraftForge.EVENT_BUS.post(evt);
        Event.Result canContinueSleep = evt.getResult();
        if (canContinueSleep == Event.Result.DEFAULT) {
            arc state = player.l.o(player.bG);
            return state.t().isBed(state, (ahx)player.l, player.bG, (rr)player);
        }
        return canContinueSleep == Event.Result.ALLOW;
    }

    public static qp<adq> onArrowNock(adq item, aht world, zj player, qm hand, boolean hasAmmo) {
        ArrowNockEvent event = new ArrowNockEvent(player, item, hand, world, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return new qp(qo.c, (Object)item);
        }
        return event.getAction();
    }

    public static int onArrowLoose(adq stack, aht world, zj player, int charge, boolean hasAmmo) {
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, world, charge, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.getCharge();
    }

    public static boolean onReplaceBiomeBlocks(ary gen, int x, int z, atf primer, aht world) {
        ChunkGeneratorEvent.ReplaceBiomeBlocks event = new ChunkGeneratorEvent.ReplaceBiomeBlocks(gen, x, z, primer, world);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult() != Event.Result.DENY;
    }

    public static void onChunkPopulate(boolean pre, ary gen, aht world, int x, int z, boolean hasVillageGenerated) {
        MinecraftForge.EVENT_BUS.post(new PopulateChunkEvent.Pre(gen, world, world.r, x, z, hasVillageGenerated));
    }
}

