/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import java.io.File;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;

public class PlayerEvent
extends LivingEvent {
    public final zj entityPlayer;

    public PlayerEvent(zj player) {
        super((sa)player);
        this.entityPlayer = player;
    }

    public static class SaveToFile
    extends PlayerEvent {
        public final File playerDirectory;
        public final String playerUUID;

        public SaveToFile(zj player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.playerDirectory, this.playerUUID + "." + suffix);
        }
    }

    public static class LoadFromFile
    extends PlayerEvent {
        public final File playerDirectory;
        public final String playerUUID;

        public LoadFromFile(zj player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.playerDirectory, this.playerUUID + "." + suffix);
        }
    }

    public static class StopTracking
    extends PlayerEvent {
        public final rr target;

        public StopTracking(zj player, rr target) {
            super(player);
            this.target = target;
        }
    }

    public static class StartTracking
    extends PlayerEvent {
        public final rr target;

        public StartTracking(zj player, rr target) {
            super(player);
            this.target = target;
        }
    }

    public static class Clone
    extends PlayerEvent {
        public final zj original;
        public final boolean wasDeath;

        public Clone(zj _new, zj oldPlayer, boolean wasDeath) {
            super(_new);
            this.original = oldPlayer;
            this.wasDeath = wasDeath;
        }
    }

    public static class NameFormat
    extends PlayerEvent {
        public final String username;
        public String displayname;

        public NameFormat(zj player, String username) {
            super(player);
            this.username = username;
            this.displayname = username;
        }
    }

    @Cancelable
    public static class BreakSpeed
    extends PlayerEvent {
        public final arc state;
        public final float originalSpeed;
        public float newSpeed = 0.0f;
        public final cj pos;

        public BreakSpeed(zj player, arc state, float original, cj pos) {
            super(player);
            this.state = state;
            this.originalSpeed = original;
            this.newSpeed = original;
            this.pos = pos;
        }
    }

    public static class HarvestCheck
    extends PlayerEvent {
        private final arc state;
        private boolean success;

        public HarvestCheck(zj player, arc state, boolean success) {
            super(player);
            this.state = state;
            this.success = success;
        }

        public arc getTargetBlock() {
            return this.state;
        }

        public boolean canHarvest() {
            return this.success;
        }

        public void setCanHarvest(boolean success) {
            this.success = success;
        }
    }
}

