/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    public final aht world;
    public final cj pos;
    public final arc state;

    public BlockEvent(aht world, cj pos, arc state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<cq> notifiedSides;

        public NeighborNotifyEvent(aht world, cj pos, arc state, EnumSet<cq> notifiedSides) {
            super(world, pos, state);
            this.notifiedSides = notifiedSides;
        }

        public EnumSet<cq> getNotifiedSides() {
            return this.notifiedSides;
        }
    }

    @Cancelable
    public static class MultiPlaceEvent
    extends PlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public MultiPlaceEvent(List<BlockSnapshot> blockSnapshots, arc placedAgainst, zj player) {
            super(blockSnapshots.get(0), placedAgainst, player);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created MultiPlaceEvent - [PlacedAgainst: %s ][ItemInHand: %s ][Player: %s ]\n", placedAgainst, this.itemInHand, player);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class PlaceEvent
    extends BlockEvent {
        public final zj player;
        public final adq itemInHand;
        public final BlockSnapshot blockSnapshot;
        public final arc placedBlock;
        public final arc placedAgainst;

        public PlaceEvent(BlockSnapshot blockSnapshot, arc placedAgainst, zj player) {
            super(blockSnapshot.world, blockSnapshot.pos, blockSnapshot.getCurrentBlock());
            this.player = player;
            this.itemInHand = player.cb();
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            if (DEBUG) {
                System.out.printf("Created PlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][ItemStack: %s ][Player: %s ]\n", this.placedBlock, placedAgainst, this.itemInHand, player);
            }
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final zj player;
        private int exp;

        public BreakEvent(aht world, cj pos, arc state, zj player) {
            super(world, pos, state);
            this.player = player;
            if (state == null || !ForgeHooks.canHarvestBlock(state.t(), player, (ahx)world, pos) || state.t().canSilkHarvest(world, pos, world.o(pos), player) && ago.a((agm)agq.r, (adq)player.cb()) > 0) {
                this.exp = 0;
            } else {
                int bonusLevel = ago.a((agm)agq.t, (adq)player.cb());
                this.exp = state.t().getExpDrop(state, (ahx)world, pos, bonusLevel);
            }
        }

        public zj getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        public final int fortuneLevel;
        public final List<adq> drops;
        public final boolean isSilkTouching;
        public float dropChance;
        public final zj harvester;

        public HarvestDropsEvent(aht world, cj pos, arc state, int fortuneLevel, float dropChance, List<adq> drops, zj harvester, boolean isSilkTouching) {
            super(world, pos, state);
            this.fortuneLevel = fortuneLevel;
            this.dropChance = dropChance;
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }
    }
}

