/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.concurrent.Callable;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class FluidUtil {
    private FluidUtil() {
    }

    public static boolean interactWithTank(adq stack, zj player, IFluidHandler tank, cq side) {
        if (stack == null || player.l.E) {
            return true;
        }
        int slot = player.br.d;
        adq result = FluidUtil.tryFillBucket(stack, tank, side);
        if (result != null || (result = FluidUtil.tryEmptyBucket(stack, tank, side)) != null) {
            if (!player.bJ.d) {
                player.br.a(slot, 1);
                ItemHandlerHelper.giveItemToPlayer(player, result, slot);
            }
            if (player.bs != null) {
                player.bs.b();
            }
            return true;
        }
        adq copy = stack.k();
        boolean changedBucket = false;
        if (adq.c((adq)stack, (adq)FluidContainerRegistry.EMPTY_BUCKET) && FluidRegistry.isUniversalBucketEnabled()) {
            stack = new adq((ado)ForgeModContainer.getInstance().universalBucket, copy.b);
            changedBucket = true;
        }
        if (FluidUtil.tryFillFluidContainerItem(stack, tank, side, player) || FluidUtil.tryEmptyFluidContainerItem(stack, tank, side, player)) {
            if (player.bJ.d) {
                player.br.a(slot, copy);
            } else if (changedBucket && stack.b != copy.b) {
                copy.b = stack.b;
                player.br.a(slot, copy);
            } else if (copy.b > 1) {
                player.br.a(slot, stack);
            } else {
                player.br.a(slot, null);
                ItemHandlerHelper.giveItemToPlayer(player, stack, slot);
            }
            if (player.bs != null) {
                player.bs.b();
            }
            return true;
        }
        return false;
    }

    public static adq tryFillBucket(adq bucket, IFluidHandler tank, cq side) {
        FluidTankInfo[] info = tank.getTankInfo(side);
        if (info == null || info.length == 0) {
            return null;
        }
        if (!FluidContainerRegistry.isEmptyContainer(bucket)) {
            return null;
        }
        FluidStack inTank = info[0].fluid;
        FluidStack liquid = tank.drain(side, FluidContainerRegistry.getContainerCapacity(inTank, bucket), false);
        if (liquid != null && liquid.amount > 0) {
            tank.drain(side, FluidContainerRegistry.getContainerCapacity(liquid, bucket), true);
            return FluidContainerRegistry.fillFluidContainer(liquid, bucket);
        }
        return null;
    }

    public static adq tryEmptyBucket(adq bucket, IFluidHandler tank, cq side) {
        int amount;
        if (!FluidContainerRegistry.isFilledContainer(bucket)) {
            return null;
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem(bucket);
        if (tank.canFill(side, liquid.getFluid()) && (amount = tank.fill(side, liquid, false)) == liquid.amount) {
            tank.fill(side, liquid, true);
            return FluidContainerRegistry.drainFluidContainer(bucket);
        }
        return null;
    }

    public static boolean tryFillFluidContainerItem(adq container, IFluidHandler tank, cq side, zj player) {
        return FluidUtil.tryFillFluidContainerItem(container, tank, side, new PlayerMainInvWrapper(player.br), -1, player);
    }

    public static boolean tryEmptyFluidContainerItem(adq container, IFluidHandler tank, cq side, zj player) {
        return FluidUtil.tryEmptyFluidContainerItem(container, tank, side, new PlayerMainInvWrapper(player.br), -1, player);
    }

    public static boolean tryFillFluidContainerItem(adq container, IFluidHandler tank, cq side, IItemHandler inventory, int max, zj player) {
        FluidStack liquid;
        if (!(container.b() instanceof IFluidContainerItem)) {
            return false;
        }
        IFluidContainerItem fluidContainer = (IFluidContainerItem)container.b();
        if (fluidContainer.getFluid(container) != null) {
            return false;
        }
        if (max <= 0) {
            max = fluidContainer.getCapacity(container);
        }
        if ((liquid = tank.drain(side, max, false)) != null && liquid.amount > 0) {
            if (container.b > 1) {
                adq toFill = container.k();
                toFill.b = 1;
                int filled = fluidContainer.fill(toFill, liquid, false);
                if (filled <= 0) {
                    return false;
                }
                filled = fluidContainer.fill(toFill, liquid, true);
                adq remainder = ItemHandlerHelper.insertItemStacked(inventory, toFill, true);
                if (remainder != null && player == null) {
                    return false;
                }
                remainder = ItemHandlerHelper.insertItemStacked(inventory, toFill, false);
                if (remainder != null && player != null) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                tank.drain(side, filled, true);
                --container.b;
            } else {
                int filled = fluidContainer.fill(container, liquid, false);
                if (filled <= 0) {
                    return false;
                }
                filled = fluidContainer.fill(container, liquid, true);
                tank.drain(side, filled, true);
            }
            return true;
        }
        return false;
    }

    public static boolean tryEmptyFluidContainerItem(adq container, IFluidHandler tank, cq side, IItemHandler inventory, int max, zj player) {
        if (!(container.b() instanceof IFluidContainerItem)) {
            return false;
        }
        IFluidContainerItem fluidContainer = (IFluidContainerItem)container.b();
        if (fluidContainer.getFluid(container) != null) {
            int filled;
            FluidStack drained;
            if (max <= 0) {
                max = fluidContainer.getCapacity(container);
            }
            if ((drained = fluidContainer.drain(container, max, false)) != null && (filled = tank.fill(side, drained, false)) > 0 && (drained = fluidContainer.drain(container, filled, false)) != null && drained.amount == filled) {
                if (container.b > 1) {
                    adq toEmpty = container.k();
                    toEmpty.b = 1;
                    drained = fluidContainer.drain(toEmpty, filled, true);
                    adq remainder = ItemHandlerHelper.insertItemStacked(inventory, toEmpty, true);
                    if (remainder != null && player == null) {
                        return false;
                    }
                    remainder = ItemHandlerHelper.insertItemStacked(inventory, toEmpty, false);
                    if (remainder != null && player != null) {
                        ItemHandlerHelper.giveItemToPlayer(player, remainder);
                    }
                    tank.fill(side, drained, true);
                    --container.b;
                } else {
                    drained = fluidContainer.drain(container, filled, true);
                    tank.fill(side, drained, true);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean insertItemIntoo(adq stack, qg inventory, aht world, cj pos, boolean isCreative) {
        if (stack == null) {
            return false;
        }
        if (inventory != null && FluidUtil.addItemStackToInventory(stack, inventory, isCreative)) {
            if (world != null && pos != null) {
                world.a(null, (double)pos.p(), (double)pos.q(), (double)pos.r(), ng.cU, nh.h, 0.2f, ((world.r.nextFloat() - world.r.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            return true;
        }
        if (world != null && pos != null) {
            double d0 = (double)pos.q() + 0.5;
            yd entityitem = new yd(world, (double)pos.p(), d0, (double)pos.r(), stack);
            entityitem.a(40);
            entityitem.s = 0.0;
            entityitem.u = 0.0;
            if (!world.E) {
                world.a((rr)entityitem);
            }
            return true;
        }
        return false;
    }

    private static boolean addItemStackToInventory(final adq itemstack, qg inventory, boolean isCreative) {
        if (itemstack != null && itemstack.b == 1 && itemstack.b() != null) {
            try {
                adq slot;
                int i2;
                int sizeInventory = inventory.u_();
                if (inventory instanceof zi) {
                    sizeInventory -= 4;
                }
                if (itemstack.g()) {
                    int j2;
                    for (j2 = 0; j2 < sizeInventory && inventory.a(j2) != null; ++j2) {
                    }
                    if (j2 < sizeInventory) {
                        adq copy = adq.c((adq)itemstack);
                        copy.c = 5;
                        inventory.a(j2, copy);
                        itemstack.b = 0;
                        return true;
                    }
                    if (isCreative) {
                        itemstack.b = 0;
                        return true;
                    }
                    return false;
                }
                int origSize = itemstack.b;
                for (i2 = 0; i2 < sizeInventory; ++i2) {
                    slot = inventory.a(i2);
                    if (slot == null || slot.b() != itemstack.b() || !slot.d() || slot.b >= slot.c() || slot.b >= inventory.w_() || slot.f() && slot.i() != itemstack.i() || !adq.a((adq)slot, (adq)itemstack)) continue;
                    int dif = itemstack.b;
                    if (dif > slot.c() - slot.b) {
                        dif = slot.c() - slot.b;
                    }
                    if (dif > inventory.w_()) {
                        dif = inventory.w_();
                    }
                    slot.b += dif;
                    slot.c = 5;
                    itemstack.b -= dif;
                    inventory.a(i2, slot);
                    if (itemstack.b <= 0) break;
                }
                if (itemstack.b > 0) {
                    for (i2 = 0; i2 < sizeInventory; ++i2) {
                        if (inventory.a(i2) == null) {
                            slot = adq.c((adq)itemstack);
                            if (slot.b > inventory.w_()) {
                                slot.b = inventory.w_();
                            }
                            slot.c = 5;
                            inventory.a(i2, slot);
                            itemstack.b -= slot.b;
                        }
                        if (itemstack.b <= 0) break;
                    }
                }
                if (itemstack.b > 0 && isCreative) {
                    itemstack.b = 0;
                    return true;
                }
                return itemstack.b < origSize;
            }
            catch (Throwable throwable) {
                b crashreport = b.a((Throwable)throwable, (String)"Adding item to inventory");
                c crashreportcategory = crashreport.a("Item being added");
                crashreportcategory.a("Item ID", (Object)ado.a((ado)itemstack.b()));
                crashreportcategory.a("Item data", (Object)itemstack.i());
                crashreportcategory.a("Item name", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return itemstack.q();
                    }
                });
                throw new e(crashreport);
            }
        }
        return false;
    }
}

