/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;

public class GuiEditArrayEntries
extends bdl {
    protected GuiEditArray owningGui;
    public bcf a;
    public IConfigElement configElement;
    public List<IArrayEntry> listEntries;
    public boolean isDefault;
    public boolean isChanged;
    public boolean canAddMoreEntries;
    public final int controlWidth;
    public final Object[] beforeValues;
    public Object[] currentValues;

    public GuiEditArrayEntries(GuiEditArray parent, bcf mc, IConfigElement configElement, Object[] beforeValues, Object[] currentValues) {
        super(mc, parent.l, parent.m, parent.titleLine2 != null ? (parent.titleLine3 != null ? 43 : 33) : 23, parent.m - 32, 20);
        this.owningGui = parent;
        this.a = mc;
        this.configElement = configElement;
        this.beforeValues = beforeValues;
        this.currentValues = currentValues;
        this.b(false);
        this.isChanged = !Arrays.deepEquals(beforeValues, currentValues);
        this.isDefault = Arrays.deepEquals(currentValues, configElement.getDefaults());
        this.canAddMoreEntries = !configElement.isListLengthFixed() && (configElement.getMaxListLength() == -1 || currentValues.length < configElement.getMaxListLength());
        this.listEntries = new ArrayList<IArrayEntry>();
        this.controlWidth = parent.l / 2 - (configElement.isListLengthFixed() ? 0 : 48);
        if (configElement.isList() && configElement.getArrayEntryClass() != null) {
            Class<? extends IArrayEntry> clazz = configElement.getArrayEntryClass();
            for (Object value : currentValues) {
                try {
                    this.listEntries.add(clazz.getConstructor(GuiEditArray.class, GuiEditArrayEntries.class, IConfigElement.class, Object.class).newInstance(new Object[]{this.owningGui, this, configElement, value.toString()}));
                }
                catch (Throwable e2) {
                    FMLLog.severe("There was a critical error instantiating the custom IGuiEditListEntry for property %s.", configElement.getName());
                    e2.printStackTrace();
                }
            }
        } else if (configElement.isList() && configElement.getType().equals((Object)ConfigGuiType.BOOLEAN)) {
            for (Object value : currentValues) {
                this.listEntries.add(new BooleanEntry(this.owningGui, this, configElement, Boolean.valueOf(value.toString())));
            }
        } else if (configElement.isList() && configElement.getType().equals((Object)ConfigGuiType.INTEGER)) {
            for (Object value : currentValues) {
                this.listEntries.add(new IntegerEntry(this.owningGui, this, configElement, Integer.parseInt(value.toString())));
            }
        } else if (configElement.isList() && configElement.getType().equals((Object)ConfigGuiType.DOUBLE)) {
            for (Object value : currentValues) {
                this.listEntries.add(new DoubleEntry(this.owningGui, this, configElement, Double.parseDouble(value.toString())));
            }
        } else if (configElement.isList()) {
            for (Object value : currentValues) {
                this.listEntries.add(new StringEntry(this.owningGui, this, configElement, value.toString()));
            }
        }
        if (!configElement.isListLengthFixed()) {
            this.listEntries.add(new BaseEntry(this.owningGui, this, configElement));
        }
    }

    protected int d() {
        return this.b - this.b / 4;
    }

    public int c() {
        return this.owningGui.l;
    }

    public IArrayEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    protected int b() {
        return this.listEntries.size();
    }

    public void addNewEntry(int index) {
        if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.BOOLEAN) {
            this.listEntries.add(index, new BooleanEntry(this.owningGui, this, this.configElement, true));
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.INTEGER) {
            this.listEntries.add(index, new IntegerEntry(this.owningGui, this, this.configElement, 0));
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.DOUBLE) {
            this.listEntries.add(index, new DoubleEntry(this.owningGui, this, this.configElement, 0.0));
        } else if (this.configElement.isList()) {
            this.listEntries.add(index, new StringEntry(this.owningGui, this, this.configElement, ""));
        }
        this.canAddMoreEntries = !this.configElement.isListLengthFixed() && (this.configElement.getMaxListLength() == -1 || this.listEntries.size() - 1 < this.configElement.getMaxListLength());
        this.keyTyped('\u0000', 207);
    }

    public void removeEntry(int index) {
        this.listEntries.remove(index);
        this.canAddMoreEntries = !this.configElement.isListLengthFixed() && (this.configElement.getMaxListLength() == -1 || this.listEntries.size() - 1 < this.configElement.getMaxListLength());
        this.keyTyped('\u0000', 207);
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void recalculateState() {
        int i2;
        int listLength;
        this.isDefault = true;
        this.isChanged = false;
        int n = listLength = this.configElement.isListLengthFixed() ? this.listEntries.size() : this.listEntries.size() - 1;
        if (listLength != this.configElement.getDefaults().length) {
            this.isDefault = false;
        }
        if (listLength != this.beforeValues.length) {
            this.isChanged = true;
        }
        if (this.isDefault) {
            for (i2 = 0; i2 < listLength; ++i2) {
                if (this.configElement.getDefaults()[i2].equals(this.listEntries.get(i2).getValue())) continue;
                this.isDefault = false;
            }
        }
        if (!this.isChanged) {
            for (i2 = 0; i2 < listLength; ++i2) {
                if (this.beforeValues[i2].equals(this.listEntries.get(i2).getValue())) continue;
                this.isChanged = true;
            }
        }
    }

    protected void keyTyped(char eventChar, int eventKey) {
        for (IArrayEntry entry : this.listEntries) {
            entry.keyTyped(eventChar, eventKey);
        }
        this.recalculateState();
    }

    protected void updateScreen() {
        for (IArrayEntry entry : this.listEntries) {
            entry.updateCursorCounter();
        }
    }

    protected void mouseClickedPassThru(int x, int y, int mouseEvent) {
        for (IArrayEntry entry : this.listEntries) {
            entry.mouseClicked(x, y, mouseEvent);
        }
    }

    protected boolean isListSavable() {
        for (IArrayEntry entry : this.listEntries) {
            if (entry.isValueSavable()) continue;
            return false;
        }
        return true;
    }

    protected void saveListChanges() {
        int listLength;
        int n = listLength = this.configElement.isListLengthFixed() ? this.listEntries.size() : this.listEntries.size() - 1;
        if (this.owningGui.slotIndex != -1 && this.owningGui.parentScreen != null && this.owningGui.parentScreen instanceof GuiConfig && ((GuiConfig)this.owningGui.parentScreen).entryList.getListEntry(this.owningGui.slotIndex) instanceof GuiConfigEntries.ArrayEntry) {
            GuiConfigEntries.ArrayEntry entry = (GuiConfigEntries.ArrayEntry)((GuiConfig)this.owningGui.parentScreen).entryList.getListEntry(this.owningGui.slotIndex);
            Object[] ao = new Object[listLength];
            for (int i2 = 0; i2 < listLength; ++i2) {
                ao[i2] = this.listEntries.get(i2).getValue();
            }
            entry.setListFromChildScreen(ao);
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.BOOLEAN) {
            Object[] abol = new Boolean[listLength];
            for (int i3 = 0; i3 < listLength; ++i3) {
                abol[i3] = Boolean.valueOf(this.listEntries.get(i3).getValue().toString());
            }
            this.configElement.set(abol);
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.INTEGER) {
            Object[] ai = new Integer[listLength];
            for (int i4 = 0; i4 < listLength; ++i4) {
                ai[i4] = Integer.valueOf(this.listEntries.get(i4).getValue().toString());
            }
            this.configElement.set(ai);
        } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.DOUBLE) {
            Object[] ad = new Double[listLength];
            for (int i5 = 0; i5 < listLength; ++i5) {
                ad[i5] = Double.valueOf(this.listEntries.get(i5).getValue().toString());
            }
            this.configElement.set(ad);
        } else if (this.configElement.isList()) {
            Object[] as = new String[listLength];
            for (int i6 = 0; i6 < listLength; ++i6) {
                as[i6] = this.listEntries.get(i6).getValue().toString();
            }
            this.configElement.set(as);
        }
    }

    protected void drawScreenPost(int mouseX, int mouseY, float f) {
        for (IArrayEntry entry : this.listEntries) {
            entry.drawToolTip(mouseX, mouseY);
        }
    }

    public static interface IArrayEntry
    extends bdl.a {
        public void keyTyped(char var1, int var2);

        public void updateCursorCounter();

        public void mouseClicked(int var1, int var2, int var3);

        public void drawToolTip(int var1, int var2);

        public boolean isValueSavable();

        public Object getValue();
    }

    public static class BaseEntry
    implements IArrayEntry {
        protected final GuiEditArray owningScreen;
        protected final GuiEditArrayEntries owningEntryList;
        protected final IConfigElement configElement;
        protected final GuiButtonExt btnAddNewEntryAbove;
        private final HoverChecker addNewEntryAboveHoverChecker;
        protected final GuiButtonExt btnRemoveEntry;
        private final HoverChecker removeEntryHoverChecker;
        private List<String> addNewToolTip;
        private List<String> removeToolTip;
        protected boolean isValidValue = true;
        protected boolean isValidated = false;

        public BaseEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement) {
            this.owningScreen = owningScreen;
            this.owningEntryList = owningEntryList;
            this.configElement = configElement;
            this.btnAddNewEntryAbove = new GuiButtonExt(0, 0, 0, 18, 18, "+");
            this.btnAddNewEntryAbove.packedFGColour = GuiUtils.getColorCode('2', true);
            this.btnAddNewEntryAbove.l = owningScreen.enabled;
            this.btnRemoveEntry = new GuiButtonExt(0, 0, 0, 18, 18, "x");
            this.btnRemoveEntry.packedFGColour = GuiUtils.getColorCode('c', true);
            this.btnRemoveEntry.l = owningScreen.enabled;
            this.addNewEntryAboveHoverChecker = new HoverChecker(this.btnAddNewEntryAbove, 800);
            this.removeEntryHoverChecker = new HoverChecker(this.btnRemoveEntry, 800);
            this.addNewToolTip = new ArrayList<String>();
            this.removeToolTip = new ArrayList<String>();
            this.addNewToolTip.add(bwo.a((String)"fml.configgui.tooltip.addNewEntryAbove", (Object[])new Object[0]));
            this.removeToolTip.add(bwo.a((String)"fml.configgui.tooltip.removeEntry", (Object[])new Object[0]));
        }

        public void a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
            if (this.getValue() != null && this.isValidated) {
                this.owningEntryList.a.k.a(this.isValidValue ? a.k + "\u2714" : a.m + "\u2715", listWidth / 4 - this.owningEntryList.a.k.a("\u2714") - 2, y + slotHeight / 2 - this.owningEntryList.a.k.a / 2, 0xFFFFFF);
            }
            int half = listWidth / 2;
            if (this.owningEntryList.canAddMoreEntries) {
                this.btnAddNewEntryAbove.m = true;
                this.btnAddNewEntryAbove.h = half + (half / 2 - 44);
                this.btnAddNewEntryAbove.i = y;
                this.btnAddNewEntryAbove.a(this.owningEntryList.a, mouseX, mouseY);
            } else {
                this.btnAddNewEntryAbove.m = false;
            }
            if (!this.configElement.isListLengthFixed() && slotIndex != this.owningEntryList.listEntries.size() - 1) {
                this.btnRemoveEntry.m = true;
                this.btnRemoveEntry.h = half + (half / 2 - 22);
                this.btnRemoveEntry.i = y;
                this.btnRemoveEntry.a(this.owningEntryList.a, mouseX, mouseY);
            } else {
                this.btnRemoveEntry.m = false;
            }
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < this.owningEntryList.e && mouseY > this.owningEntryList.d;
            if (this.btnAddNewEntryAbove.m && this.addNewEntryAboveHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.addNewToolTip, mouseX, mouseY);
            }
            if (this.btnRemoveEntry.m && this.removeEntryHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.removeToolTip, mouseX, mouseY);
            }
        }

        public boolean a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnAddNewEntryAbove.c(this.owningEntryList.a, x, y)) {
                this.btnAddNewEntryAbove.a(this.owningEntryList.a.U());
                this.owningEntryList.addNewEntry(index);
                this.owningEntryList.recalculateState();
                return true;
            }
            if (this.btnRemoveEntry.c(this.owningEntryList.a, x, y)) {
                this.btnRemoveEntry.a(this.owningEntryList.a.U());
                this.owningEntryList.removeEntry(index);
                this.owningEntryList.recalculateState();
                return true;
            }
            return false;
        }

        public void b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnAddNewEntryAbove.a(x, y);
            this.btnRemoveEntry.a(x, y);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }

        @Override
        public boolean isValueSavable() {
            return this.isValidValue;
        }

        @Override
        public Object getValue() {
            return null;
        }

        public void a(int p_178011_1_, int p_178011_2_, int p_178011_3_) {
        }
    }

    public static class BooleanEntry
    extends BaseEntry {
        protected final GuiButtonExt btnValue;
        private boolean value;

        public BooleanEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, boolean value) {
            super(owningScreen, owningEntryList, configElement);
            this.value = value;
            this.btnValue = new GuiButtonExt(0, 0, 0, owningEntryList.controlWidth, 18, bwo.a((String)String.valueOf(value), (Object[])new Object[0]));
            this.btnValue.l = owningScreen.enabled;
            this.isValidated = false;
        }

        @Override
        public void a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
            super.a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected);
            this.btnValue.h = listWidth / 4;
            this.btnValue.i = y;
            String trans = bwo.a((String)String.valueOf(this.value), (Object[])new Object[0]);
            this.btnValue.j = !trans.equals(String.valueOf(this.value)) ? trans : String.valueOf(this.value);
            this.btnValue.packedFGColour = this.value ? GuiUtils.getColorCode('2', true) : GuiUtils.getColorCode('4', true);
            this.btnValue.a(this.owningEntryList.a, mouseX, mouseY);
        }

        @Override
        public boolean a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValue.c(this.owningEntryList.a, x, y)) {
                this.btnValue.a(this.owningEntryList.a.U());
                this.value = !this.value;
                this.owningEntryList.recalculateState();
                return true;
            }
            return super.a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnValue.a(x, y);
            super.b(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static class StringEntry
    extends BaseEntry {
        protected final bdd textFieldValue;

        public StringEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Object value) {
            super(owningScreen, owningEntryList, configElement);
            this.textFieldValue = new bdd(0, owningEntryList.a.k, owningEntryList.b / 4 + 1, 0, owningEntryList.controlWidth - 3, 16);
            this.textFieldValue.f(10000);
            this.textFieldValue.a(value.toString());
            boolean bl = this.isValidated = configElement.getValidationPattern() != null;
            if (configElement.getValidationPattern() != null) {
                this.isValidValue = configElement.getValidationPattern().matcher(this.textFieldValue.b().trim()).matches();
            }
        }

        @Override
        public void a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
            super.a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected);
            if (this.configElement.isListLengthFixed() || slotIndex != this.owningEntryList.listEntries.size() - 1) {
                this.textFieldValue.e(true);
                this.textFieldValue.f = y + 1;
                this.textFieldValue.g();
            } else {
                this.textFieldValue.e(false);
            }
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            if (this.owningScreen.enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                this.textFieldValue.a(this.owningScreen.enabled ? eventChar : (char)'\u0000', eventKey);
                if (this.configElement.getValidationPattern() != null) {
                    this.isValidValue = this.configElement.getValidationPattern().matcher(this.textFieldValue.b().trim()).matches();
                }
            }
        }

        @Override
        public void updateCursorCounter() {
            this.textFieldValue.a();
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textFieldValue.a(x, y, mouseEvent);
        }

        @Override
        public Object getValue() {
            return this.textFieldValue.b().trim();
        }
    }

    public static class IntegerEntry
    extends StringEntry {
        public IntegerEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Integer value) {
            super(owningScreen, owningEntryList, configElement, value);
            this.isValidated = true;
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.owningScreen.enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.b();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.i() == 0 && eventChar == '-' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.a(this.owningScreen.enabled ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.b().trim().isEmpty() && !this.textFieldValue.b().trim().equals("-")) {
                        try {
                            long value = Long.parseLong(this.textFieldValue.b().trim());
                            if (value < (long)Integer.valueOf(this.configElement.getMinValue().toString()).intValue() || value > (long)Integer.valueOf(this.configElement.getMaxValue().toString()).intValue()) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e2) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public Integer getValue() {
            try {
                return Integer.valueOf(this.textFieldValue.b().trim());
            }
            catch (Throwable e2) {
                return Integer.MAX_VALUE;
            }
        }
    }

    public static class DoubleEntry
    extends StringEntry {
        public DoubleEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Double value) {
            super(owningScreen, owningEntryList, configElement, value);
            this.isValidated = true;
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.owningScreen.enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.b();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.i() == 0 && eventChar == '-' || !before.contains(".") && eventChar == '.' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.a(this.owningScreen.enabled ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.b().trim().isEmpty() && !this.textFieldValue.b().trim().equals("-")) {
                        try {
                            double value = Double.parseDouble(this.textFieldValue.b().trim());
                            if (value < Double.valueOf(this.configElement.getMinValue().toString()) || value > Double.valueOf(this.configElement.getMaxValue().toString())) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e2) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public Double getValue() {
            try {
                return Double.valueOf(this.textFieldValue.b().trim());
            }
            catch (Throwable e2) {
                return Double.MAX_VALUE;
            }
        }
    }
}

