/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WorldAccessContainer;
import net.minecraftforge.fml.common.asm.FMLSanityChecker;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw", "LexManos", "Player");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        meta.url = "https://github.com/MinecraftForge/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @Subscribe
    public void modPreinitialization(FMLPreInitializationEvent evt) {
        VillagerRegistry.instance();
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public dn getDataForWriting(azf handler, azh info) {
        dn fmlData = new dn();
        du modList = new du();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            dn mod = new dn();
            mod.a("ModId", mc.getModId());
            mod.a("ModVersion", mc.getVersion());
            modList.a((eb)mod);
        }
        fmlData.a("ModList", (eb)modList);
        dn registries = new dn();
        fmlData.a("Registries", (eb)registries);
        FMLLog.fine("Gathering id map for writing to world save %s", info.j());
        PersistentRegistryManager.GameDataSnapshot dataSnapshot = PersistentRegistryManager.takeSnapshot();
        for (Map.Entry<kk, PersistentRegistryManager.GameDataSnapshot.Entry> e2 : dataSnapshot.entries.entrySet()) {
            dn data = new dn();
            registries.a(e2.getKey().toString(), (eb)data);
            du ids = new du();
            for (Map.Entry<kk, Integer> item : e2.getValue().ids.entrySet()) {
                dn tag = new dn();
                tag.a("K", item.getKey().toString());
                tag.a("V", item.getValue().intValue());
                ids.a((eb)tag);
            }
            data.a("ids", (eb)ids);
            du aliases = new du();
            for (Map.Entry<kk, kk> entry : e2.getValue().aliases.entrySet()) {
                dn tag = new dn();
                tag.a("K", entry.getKey().toString());
                tag.a("V", entry.getValue().toString());
                aliases.a((eb)tag);
            }
            data.a("aliases", (eb)aliases);
            du subs = new du();
            for (kk entry : e2.getValue().substitutions) {
                dn tag = new dn();
                tag.a("K", entry.toString());
                subs.a((eb)tag);
            }
            data.a("substitutions", (eb)subs);
            int[] blocked = new int[e2.getValue().blocked.size()];
            int idx = 0;
            for (Integer i2 : e2.getValue().blocked) {
                blocked[idx++] = i2;
            }
            data.a("blocked", blocked);
            du dummied = new du();
            for (kk entry : e2.getValue().dummied) {
                dn tag = new dn();
                tag.a("K", entry.toString());
                dummied.a((eb)tag);
            }
            data.a("dummied", (eb)dummied);
        }
        return fmlData;
    }

    @Override
    public void readData(azf handler, azh info, Map<String, eb> propertyMap, dn tag) {
        if (tag.e("ModList")) {
            du modList = tag.c("ModList", 10);
            for (int i2 = 0; i2 < modList.c(); ++i2) {
                dn mod = modList.b(i2);
                String modId = mod.l("ModId");
                String modVersion = mod.l("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    FMLLog.log("fml.ModTracker", Level.ERROR, "This world was saved with mod %s which appears to be missing, things may not work well", modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", modId, modVersion, container.getVersion());
            }
        }
        List<String> failedElements = null;
        if (tag.e("ModItemData")) {
            StartupQuery.notify("This save predates 1.7.10, it can no longer be loaded here. Please load in 1.7.10 or 1.8 first");
            StartupQuery.abort();
        } else if (tag.e("ItemData")) {
            int i3;
            if (!tag.e("BlockedItemIds")) {
                StartupQuery.notify("This save predates 1.7.10, it can no longer be loaded here. Please load in 1.7.10 or 1.8 first");
                StartupQuery.abort();
            }
            PersistentRegistryManager.GameDataSnapshot snapshot = new PersistentRegistryManager.GameDataSnapshot();
            PersistentRegistryManager.GameDataSnapshot.Entry blocks = new PersistentRegistryManager.GameDataSnapshot.Entry();
            PersistentRegistryManager.GameDataSnapshot.Entry items = new PersistentRegistryManager.GameDataSnapshot.Entry();
            snapshot.entries.put(PersistentRegistryManager.BLOCKS, blocks);
            snapshot.entries.put(PersistentRegistryManager.ITEMS, items);
            du list = tag.c("ItemData", 10);
            for (int i4 = 0; i4 < list.c(); ++i4) {
                dn e2 = list.b(i4);
                String name = e2.l("K");
                if (name.charAt(0) == '\u0001') {
                    blocks.ids.put(new kk(name.substring(1)), e2.h("V"));
                    continue;
                }
                if (name.charAt(0) != '\u0002') continue;
                items.ids.put(new kk(name.substring(1)), e2.h("V"));
            }
            HashSet<Integer> blockedIds = new HashSet<Integer>();
            for (int id : tag.n("BlockedItemIds")) {
                blockedIds.add(id);
            }
            blocks.blocked.addAll(blockedIds);
            items.blocked.addAll(blockedIds);
            list = tag.c("BlockAliases", 10);
            for (i3 = 0; i3 < list.c(); ++i3) {
                dn dataTag = list.b(i3);
                blocks.aliases.put(new kk(dataTag.l("K")), new kk(dataTag.l("V")));
            }
            if (tag.b("BlockSubstitutions", 9)) {
                list = tag.c("BlockSubstitutions", 10);
                for (i3 = 0; i3 < list.c(); ++i3) {
                    dn dataTag = list.b(i3);
                    blocks.substitutions.add(new kk(dataTag.l("K")));
                }
            }
            list = tag.c("ItemAliases", 10);
            for (i3 = 0; i3 < list.c(); ++i3) {
                dn dataTag = list.b(i3);
                items.aliases.put(new kk(dataTag.l("K")), new kk(dataTag.l("V")));
            }
            if (tag.b("ItemSubstitutions", 9)) {
                list = tag.c("ItemSubstitutions", 10);
                for (i3 = 0; i3 < list.c(); ++i3) {
                    dn dataTag = list.b(i3);
                    items.substitutions.add(new kk(dataTag.l("K")));
                }
            }
            failedElements = PersistentRegistryManager.injectSnapshot(snapshot, true, true);
        } else if (tag.e("Registries")) {
            PersistentRegistryManager.GameDataSnapshot snapshot = new PersistentRegistryManager.GameDataSnapshot();
            dn regs = tag.o("Registries");
            for (String key : regs.c()) {
                int[] blocked;
                int x;
                PersistentRegistryManager.GameDataSnapshot.Entry entry = new PersistentRegistryManager.GameDataSnapshot.Entry();
                kk entryLoc = "fml:blocks".equals(key) ? PersistentRegistryManager.BLOCKS : ("fml:items".equals(key) ? PersistentRegistryManager.ITEMS : ("fmlgr:villagerprofessions".equals(key) ? VillagerRegistry.PROFESSIONS : new kk(key)));
                snapshot.entries.put(entryLoc, entry);
                du list = regs.o(key).c("ids", 10);
                for (x = 0; x < list.c(); ++x) {
                    dn e3 = list.b(x);
                    entry.ids.put(new kk(e3.l("K")), e3.h("V"));
                }
                list = regs.o(key).c("aliases", 10);
                for (x = 0; x < list.c(); ++x) {
                    dn e4 = list.b(x);
                    entry.aliases.put(new kk(e4.l("K")), new kk(e4.l("V")));
                }
                list = regs.o(key).c("substitutions", 10);
                for (x = 0; x < list.c(); ++x) {
                    dn e5 = list.b(x);
                    entry.substitutions.add(new kk(e5.l("K")));
                }
                for (int i5 : blocked = regs.o(key).n("blocked")) {
                    entry.blocked.add(i5);
                }
                if (!regs.o(key).e("dummied")) continue;
                list = regs.o(key).c("dummied", 10);
                for (int x2 = 0; x2 < list.c(); ++x2) {
                    dn e6 = list.b(x2);
                    entry.dummied.add(new kk(e6.l("K")));
                }
            }
            failedElements = PersistentRegistryManager.injectSnapshot(snapshot, true, true);
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            String text = "Forge Mod Loader could not load this save.\n\nThere are " + failedElements.size() + " unassigned blocks and items in this save.\n" + "You will not be able to load until they are present again.\n\n" + "Missing Blocks/Items:\n";
            for (String s : failedElements) {
                text = text + s + "\n";
            }
            StartupQuery.notify(text);
            StartupQuery.abort();
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificates = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Override
    public String getGuiClassName() {
        return "net.minecraftforge.fml.client.FMLConfigGuiFactory";
    }

    @Override
    public Object getMod() {
        return this;
    }
}

