/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FileListHelper;
import org.apache.logging.log4j.Level;

public class ModDiscoverer {
    private static Pattern zipJar = Pattern.compile("(.+).(zip|jar)$");
    private List<ModCandidate> candidates = Lists.newArrayList();
    private ASMDataTable dataTable = new ASMDataTable();
    private List<File> nonModLibs = Lists.newArrayList();

    public void findClasspathMods(ModClassLoader modClassLoader) {
        ImmutableList knownLibraries = ImmutableList.builder().addAll(modClassLoader.getDefaultLibraries()).addAll(CoreModManager.getIgnoredMods()).addAll(CoreModManager.getReparseableCoremods()).build();
        File[] minecraftSources = modClassLoader.getParentSources();
        if (minecraftSources.length == 1 && minecraftSources[0].isFile()) {
            FMLLog.fine("Minecraft is a file at %s, loading", minecraftSources[0].getAbsolutePath());
            this.addCandidate(new ModCandidate(minecraftSources[0], minecraftSources[0], ContainerType.JAR, true, true));
        } else {
            int i2 = 0;
            for (File source : minecraftSources) {
                if (source.isFile()) {
                    if (knownLibraries.contains(source.getName()) || modClassLoader.isDefaultLibrary(source)) {
                        FMLLog.finer("Skipping known library file %s", source.getAbsolutePath());
                    } else {
                        FMLLog.fine("Found a minecraft related file at %s, examining for mod candidates", source.getAbsolutePath());
                        this.addCandidate(new ModCandidate(source, source, ContainerType.JAR, i2 == 0, true));
                    }
                } else if (minecraftSources[i2].isDirectory()) {
                    FMLLog.fine("Found a minecraft related directory at %s, examining for mod candidates", source.getAbsolutePath());
                    this.addCandidate(new ModCandidate(source, source, ContainerType.DIR, i2 == 0, true));
                }
                ++i2;
            }
        }
    }

    public void findModDirMods(File modsDir) {
        this.findModDirMods(modsDir, new File[0]);
    }

    public void findModDirMods(File modsDir, File[] supplementalModFileCandidates) {
        Object[] modList = FileListHelper.sortFileList(modsDir, null);
        for (Object modFile : modList = FileListHelper.sortFileList((File[])ObjectArrays.concat((Object[])modList, (Object[])supplementalModFileCandidates, File.class))) {
            if (CoreModManager.getIgnoredMods().contains(((File)modFile).getName())) {
                FMLLog.finer("Skipping already parsed coremod or tweaker %s", ((File)modFile).getName());
                continue;
            }
            if (((File)modFile).isDirectory()) {
                FMLLog.fine("Found a candidate mod directory %s", ((File)modFile).getName());
                this.addCandidate(new ModCandidate((File)modFile, (File)modFile, ContainerType.DIR));
                continue;
            }
            Matcher matcher = zipJar.matcher(((File)modFile).getName());
            if (matcher.matches()) {
                FMLLog.fine("Found a candidate zip or jar file %s", matcher.group(0));
                this.addCandidate(new ModCandidate((File)modFile, (File)modFile, ContainerType.JAR));
                continue;
            }
            FMLLog.fine("Ignoring unknown file %s in mods directory", ((File)modFile).getName());
        }
    }

    public List<ModContainer> identifyMods() {
        ArrayList modList = Lists.newArrayList();
        for (ModCandidate candidate : this.candidates) {
            try {
                List<ModContainer> mods = candidate.explore(this.dataTable);
                if (mods.isEmpty() && !candidate.isClasspath()) {
                    this.nonModLibs.add(candidate.getModContainer());
                    continue;
                }
                modList.addAll(mods);
            }
            catch (LoaderException le) {
                FMLLog.log(Level.WARN, le, "Identified a problem with the mod candidate %s, ignoring this source", candidate.getModContainer());
            }
            catch (Throwable t) {
                Throwables.propagate((Throwable)t);
            }
        }
        return modList;
    }

    public ASMDataTable getASMTable() {
        return this.dataTable;
    }

    public List<File> getNonModLibs() {
        return this.nonModLibs;
    }

    private void addCandidate(ModCandidate candidate) {
        for (ModCandidate c2 : this.candidates) {
            if (!c2.getModContainer().equals(candidate.getModContainer())) continue;
            FMLLog.finer("  Skipping already in list %s", candidate.getModContainer());
            return;
        }
        this.candidates.add(candidate);
    }
}

