/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import java.util.List;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLNetworkException;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public class FMLOutboundHandler
extends ChannelOutboundHandlerAdapter {
    public static final AttributeKey<OutboundTarget> FML_MESSAGETARGET = AttributeKey.valueOf((String)"fml:outboundTarget");
    public static final AttributeKey<Object> FML_MESSAGETARGETARGS = AttributeKey.valueOf((String)"fml:outboundTargetArgs");

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof FMLProxyPacket)) {
            return;
        }
        FMLProxyPacket pkt = (FMLProxyPacket)msg;
        Object args = null;
        NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
        if (dispatcher != null) {
            ctx.write(msg, promise);
            return;
        }
        OutboundTarget outboundTarget = (OutboundTarget)((Object)ctx.channel().attr(FML_MESSAGETARGET).get());
        Side channelSide = (Side)((Object)ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get());
        if (outboundTarget != null && outboundTarget.allowed.contains((Object)channelSide)) {
            args = ctx.channel().attr(FML_MESSAGETARGETARGS).get();
            outboundTarget.validateArgs(args);
        } else if (channelSide == Side.CLIENT) {
            outboundTarget = OutboundTarget.TOSERVER;
        } else {
            throw new FMLNetworkException("Packet arrived at the outbound handler without a valid target!");
        }
        List<NetworkDispatcher> dispatchers = outboundTarget.selectNetworks(args, ctx, pkt);
        if (dispatchers == null) {
            ctx.write(msg, promise);
            return;
        }
        for (NetworkDispatcher targetDispatcher : dispatchers) {
            targetDispatcher.sendProxy((FMLProxyPacket)msg);
        }
    }

    public static enum OutboundTarget {
        NOWHERE(Sets.immutableEnumSet((Enum)Side.CLIENT, (Enum[])new Side[]{Side.SERVER})){

            @Override
            public void validateArgs(Object args) {
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                return null;
            }
        }
        ,
        DISPATCHER(Sets.immutableEnumSet((Enum)Side.SERVER, (Enum[])new Side[0])){

            @Override
            public void validateArgs(Object args) {
                if (!(args instanceof NetworkDispatcher)) {
                    throw new RuntimeException("DISPATCHER expects a NetworkDispatcher");
                }
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                return ImmutableList.of((Object)((Object)((NetworkDispatcher)((Object)args))));
            }
        }
        ,
        REPLY(Sets.immutableEnumSet((Enum)Side.SERVER, (Enum[])new Side[0])){

            @Override
            public void validateArgs(Object args) {
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                return ImmutableList.of((Object)((Object)packet.getDispatcher()));
            }
        }
        ,
        PLAYER(Sets.immutableEnumSet((Enum)Side.SERVER, (Enum[])new Side[0])){

            @Override
            public void validateArgs(Object args) {
                if (!(args instanceof lr)) {
                    throw new RuntimeException("PLAYER target expects a Player arg");
                }
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                lr player = (lr)args;
                NetworkDispatcher dispatcher = player == null ? null : (NetworkDispatcher)((Object)player.a.a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                return dispatcher == null ? ImmutableList.of() : ImmutableList.of(dispatcher);
            }
        }
        ,
        ALL(Sets.immutableEnumSet((Enum)Side.SERVER, (Enum[])new Side[0])){

            @Override
            public void validateArgs(Object args) {
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (lr player : FMLCommonHandler.instance().getMinecraftServerInstance().al().v()) {
                    NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)player.a.a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                    if (dispatcher == null) continue;
                    builder.add((Object)dispatcher);
                }
                return builder.build();
            }
        }
        ,
        DIMENSION(Sets.immutableEnumSet((Enum)Side.SERVER, (Enum[])new Side[0])){

            @Override
            public void validateArgs(Object args) {
                if (!(args instanceof Integer)) {
                    throw new RuntimeException("DIMENSION expects an integer argument");
                }
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                int dimension = (Integer)args;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (lr player : FMLCommonHandler.instance().getMinecraftServerInstance().al().v()) {
                    NetworkDispatcher dispatcher;
                    if (dimension != player.am || (dispatcher = (NetworkDispatcher)((Object)player.a.a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get())) == null) continue;
                    builder.add((Object)dispatcher);
                }
                return builder.build();
            }
        }
        ,
        ALLAROUNDPOINT(Sets.immutableEnumSet((Enum)Side.SERVER, (Enum[])new Side[0])){

            @Override
            public void validateArgs(Object args) {
                if (!(args instanceof NetworkRegistry.TargetPoint)) {
                    throw new RuntimeException("ALLAROUNDPOINT expects a TargetPoint argument");
                }
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                NetworkRegistry.TargetPoint tp = (NetworkRegistry.TargetPoint)args;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (lr player : FMLCommonHandler.instance().getMinecraftServerInstance().al().v()) {
                    NetworkDispatcher dispatcher;
                    double d6;
                    double d5;
                    double d4;
                    if (player.am != tp.dimension || !((d4 = tp.x - player.p) * d4 + (d5 = tp.y - player.q) * d5 + (d6 = tp.z - player.r) * d6 < tp.range * tp.range) || (dispatcher = (NetworkDispatcher)((Object)player.a.a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get())) == null) continue;
                    builder.add((Object)dispatcher);
                }
                return builder.build();
            }
        }
        ,
        TOSERVER(Sets.immutableEnumSet((Enum)Side.CLIENT, (Enum[])new Side[0])){

            @Override
            public void validateArgs(Object args) {
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                ek clientConnection = FMLCommonHandler.instance().getClientToServerNetworkManager();
                return clientConnection == null || clientConnection.channel().attr(NetworkDispatcher.FML_DISPATCHER).get() == null ? ImmutableList.of() : ImmutableList.of((Object)clientConnection.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            }
        };

        public final ImmutableSet<Side> allowed;

        private OutboundTarget(ImmutableSet<Side> sides) {
            this.allowed = sides;
        }

        public abstract void validateArgs(Object var1);

        public abstract List<NetworkDispatcher> selectNetworks(Object var1, ChannelHandlerContext var2, FMLProxyPacket var3);
    }
}

