/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.functions.GenericIterableFactory;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.IncompatibleSubstitutionException;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;

public class FMLControlledNamespacedRegistry<I>
extends co<kk, I> {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugRegistryEntries", "false"));
    private final Class<I> superType;
    private final boolean isDelegated;
    private final Field delegateAccessor;
    private kk optionalDefaultKey;
    private I optionalDefaultObject;
    private int maxId;
    private int minId;
    private final Map<kk, kk> aliases = Maps.newHashMap();
    private final BiMap<kk, I> persistentSubstitutions = HashBiMap.create();
    private final BiMap<kk, I> activeSubstitutions = HashBiMap.create();
    private final Set<Integer> blockedIds = Sets.newHashSet();
    private final Set<kk> dummiedLocations = Sets.newHashSet();
    private final BitSet availabilityMap;
    private final AddCallback<I> addCallback;

    FMLControlledNamespacedRegistry(kk defaultKey, int maxIdValue, int minIdValue, Class<I> type, boolean isDelegated) {
        this(defaultKey, maxIdValue, minIdValue, type, isDelegated, null);
    }

    FMLControlledNamespacedRegistry(kk defaultKey, int maxIdValue, int minIdValue, Class<I> type, boolean isDelegated, AddCallback<I> callback) {
        super((Object)defaultKey);
        this.superType = type;
        this.optionalDefaultKey = defaultKey;
        this.maxId = maxIdValue;
        this.minId = minIdValue;
        this.availabilityMap = new BitSet(maxIdValue + 1);
        this.isDelegated = isDelegated;
        if (this.isDelegated) {
            try {
                this.delegateAccessor = type.getField("delegate");
            }
            catch (NoSuchFieldException e2) {
                FMLLog.log(Level.ERROR, e2, "Delegate class identified with missing delegate field", new Object[0]);
                throw Throwables.propagate((Throwable)e2);
            }
        } else {
            this.delegateAccessor = null;
        }
        this.addCallback = callback;
    }

    void validateContent(kk registryName) {
        for (I obj : this.typeSafeIterable()) {
            int id = this.getId(obj);
            kk name = this.getNameForObject(obj);
            boolean isSubstituted = this.activeSubstitutions.containsKey((Object)name);
            if (name == null) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, doesn't yield a name.", registryName, obj, id));
            }
            if (!isSubstituted && id < 0) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s, doesn't yield an id.", registryName, obj, name));
            }
            if (id > this.maxId) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s uses the too large id %d.", registryName, obj, name, id));
            }
            if (isSubstituted) continue;
            if (this.getRaw(id) != obj) {
                throw new IllegalStateException(String.format("Registry entry for id %d, name %s, doesn't yield the expected %s %s.", id, name, registryName, obj));
            }
            if (this.getRaw(name) != obj) {
                throw new IllegalStateException(String.format("Registry entry for name %s, id %d, doesn't yield the expected %s %s.", name, id, registryName, obj));
            }
            if (this.getId(name) == id) continue;
            throw new IllegalStateException(String.format("Registry entry for name %s doesn't yield the expected id %d.", name, id));
        }
    }

    void set(FMLControlledNamespacedRegistry<I> otherRegistry) {
        if (this.superType != otherRegistry.superType) {
            throw new IllegalArgumentException("incompatible registry");
        }
        this.optionalDefaultKey = otherRegistry.optionalDefaultKey;
        this.maxId = otherRegistry.maxId;
        this.minId = otherRegistry.minId;
        this.aliases.clear();
        this.aliases.putAll(otherRegistry.aliases);
        this.persistentSubstitutions.clear();
        this.persistentSubstitutions.putAll(otherRegistry.getPersistentSubstitutions());
        this.activeSubstitutions.clear();
        this.dummiedLocations.clear();
        this.dummiedLocations.addAll(otherRegistry.dummiedLocations);
        this.a.a();
        this.c.clear();
        for (I thing : otherRegistry.typeSafeIterable()) {
            this.addObjectRaw(otherRegistry.getId(thing), otherRegistry.getNameForObject(thing), thing);
        }
        this.activeSubstitutions.putAll(otherRegistry.activeSubstitutions);
    }

    @Deprecated
    public void register(int id, kk name, I thing) {
        this.add(id, name, thing);
    }

    @Deprecated
    public void putObject(kk name, I thing) {
        if (name == null) {
            throw new NullPointerException("Can't use a null-name for the registry.");
        }
        if (thing == null) {
            throw new NullPointerException("Can't add null-object to the registry.");
        }
        kk existingName = this.getNameForObject(thing);
        if (existingName == null) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), not resolvable", name, thing);
        } else if (existingName.equals((Object)name)) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), already added", name, thing);
        } else {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), adding alias to %s instead", name, thing, existingName);
            this.addAlias(name, existingName);
        }
    }

    public I getObject(kk name) {
        I object = this.getRaw(name);
        return object == null ? this.optionalDefaultObject : object;
    }

    public I a(int id) {
        I object = this.getRaw(id);
        return object == null ? this.optionalDefaultObject : object;
    }

    public int getId(I thing) {
        return this.getIDForObjectBypass(thing);
    }

    public I getRaw(int id) {
        return (I)super.a(id);
    }

    private I getRaw(kk name) {
        Object ret = super.c((Object)name);
        if (ret == null && (name = this.aliases.get(name)) != null) {
            return this.getRaw(name);
        }
        return (I)ret;
    }

    public boolean containsKey(kk name) {
        boolean ret = super.d((Object)name);
        if (!ret && (name = this.aliases.get(name)) != null) {
            return this.containsKey(name);
        }
        return ret;
    }

    public int getId(kk itemName) {
        I obj = this.getRaw(itemName);
        if (obj == null) {
            return -1;
        }
        return this.getId(obj);
    }

    public Iterable<I> typeSafeIterable() {
        return GenericIterableFactory.newCastingIterable(super.iterator(), this.superType);
    }

    public void serializeIds(Map<kk, Integer> idMapping) {
        for (I thing : this.typeSafeIterable()) {
            idMapping.put(this.getNameForObject(thing), this.getId(thing));
        }
    }

    public void serializeAliases(Map<kk, kk> map) {
        map.putAll(this.aliases);
    }

    public void serializeSubstitutions(Set<kk> set) {
        set.addAll(this.activeSubstitutions.keySet());
    }

    public void serializeDummied(Set<kk> set) {
        set.addAll(this.dummiedLocations);
    }

    int add(int id, kk name, I thing) {
        if (name == null) {
            throw new NullPointerException(String.format("Can't use a null-name for the registry, object %s.", thing));
        }
        if (thing == null) {
            throw new NullPointerException(String.format("Can't add null-object to the registry, name %s.", name));
        }
        if (this.optionalDefaultKey != null && this.optionalDefaultKey.equals((Object)name) && this.optionalDefaultObject == null) {
            this.optionalDefaultObject = thing;
        }
        if (this.getPersistentSubstitutions().containsValue(thing)) {
            throw new IllegalArgumentException(String.format("The object %s (%s) cannot be added to the registry. It is already being used as a substitute for %s", thing.getClass(), name, this.getPersistentSubstitutions().inverse().get(thing)));
        }
        int idToUse = id;
        if (idToUse < 0 || this.availabilityMap.get(idToUse)) {
            idToUse = this.availabilityMap.nextClearBit(this.minId);
        }
        if (idToUse > this.maxId) {
            throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", idToUse));
        }
        if (this.getRaw(name) == thing) {
            FMLLog.bigWarning("The object %s has been registered twice for the same name %s.", thing, name);
            return this.getId(thing);
        }
        if (this.getRaw(name) != null) {
            throw new IllegalArgumentException(String.format("The name %s has been registered twice, for %s and %s.", name, this.getRaw(name), thing));
        }
        if (this.getId(thing) >= 0) {
            int foundId = this.getId(thing);
            I otherThing = this.getRaw(foundId);
            throw new IllegalArgumentException(String.format("The object %s{%x} has been registered twice, using the names %s and %s. (Other object at this id is %s{%x})", thing, System.identityHashCode(thing), this.getNameForObject(thing), name, otherThing, System.identityHashCode(otherThing)));
        }
        if (PersistentRegistryManager.isFrozen(this)) {
            FMLLog.bigWarning("The object %s (name %s) is being added too late.", thing, name);
        }
        if (this.activeSubstitutions.containsKey((Object)name)) {
            I oldThing = thing;
            thing = this.activeSubstitutions.get((Object)name);
            if (DEBUG) {
                FMLLog.getLogger().log(Level.DEBUG, "Active substitution: {} {}@{} -> {}@{}", new Object[]{name, oldThing.getClass().getName(), System.identityHashCode(oldThing), thing.getClass().getName(), System.identityHashCode(thing)});
            }
        }
        this.addObjectRaw(idToUse, name, thing);
        if (this.isDelegated) {
            this.getExistingDelegate(thing).setResourceName(name);
        }
        if (this.dummiedLocations.remove(name) && DEBUG) {
            FMLLog.fine("Registry Dummy Remove: %s", name);
        }
        if (DEBUG) {
            FMLLog.finer("Registry add: %s %d %s (req. id %d)", name, idToUse, thing, id);
        }
        return idToUse;
    }

    void markDummy(kk rl, Integer id, I thing) {
        if (DEBUG) {
            FMLLog.finer("Registry Dummy Add: %s %d -> %s", rl, id, thing);
        }
        this.dummiedLocations.add(rl);
        this.addObjectRaw(id, rl, thing);
    }

    void addAlias(kk from, kk to) {
        this.aliases.put(from, to);
        if (DEBUG) {
            FMLLog.finer("Registry alias: %s -> %s", from, to);
        }
    }

    Map<kk, Integer> getEntriesNotIn(FMLControlledNamespacedRegistry<I> registry) {
        HashMap<kk, Integer> ret = new HashMap<kk, Integer>();
        for (I thing : this.typeSafeIterable()) {
            if (registry.b.containsKey(thing) || registry.activeSubstitutions.containsKey((Object)this.getNameForObject(thing))) continue;
            ret.put(this.getNameForObject(thing), this.getId(thing));
        }
        return ret;
    }

    void dump(kk registryName) {
        if (!DEBUG) {
            return;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (I thing : this.typeSafeIterable()) {
            ids.add(this.getId(thing));
        }
        Collections.sort(ids);
        FMLLog.finer("Registry Name : {}", registryName);
        Iterator<Object> i$ = ids.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            I thing = this.getRaw(id);
            FMLLog.finer("Registry: %d %s %s", id, this.getNameForObject(thing), thing);
        }
    }

    private void addObjectRaw(int id, kk name, I thing) {
        if (name == null) {
            throw new NullPointerException("The name to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (thing == null) {
            throw new NullPointerException("The object to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (!this.superType.isInstance(thing)) {
            throw new IllegalArgumentException("The object to be added to the registry is not of the right type. Reflection/ASM hackery? Registry bug?");
        }
        this.a.a(thing, id);
        super.a((Object)name, thing);
        this.availabilityMap.set(id);
        if (this.addCallback != null) {
            this.addCallback.onAdd(thing, id);
        }
    }

    public I getDefaultValue() {
        return this.optionalDefaultObject;
    }

    public RegistryDelegate<I> getDelegate(I thing, Class<I> clazz) {
        return new RegistryDelegate.Delegate<I>(thing, clazz);
    }

    public RegistryDelegate.Delegate<I> getExistingDelegate(I thing) {
        try {
            return (RegistryDelegate.Delegate)this.delegateAccessor.get(thing);
        }
        catch (IllegalAccessException e2) {
            FMLLog.log(Level.ERROR, e2, "Illegal attempt to access delegate", new Object[0]);
            throw Throwables.propagate((Throwable)e2);
        }
    }

    I activateSubstitution(kk nameToReplace) {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace)) {
            I original = this.getRaw(nameToReplace);
            Object sub = this.getPersistentSubstitutions().get((Object)nameToReplace);
            this.getExistingDelegate(original).changeReference(sub);
            this.activeSubstitutions.put((Object)nameToReplace, sub);
            return original;
        }
        return null;
    }

    void addSubstitutionAlias(String modId, kk nameToReplace, I replacement) throws ExistingSubstitutionException {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace) || this.getPersistentSubstitutions().containsValue(replacement)) {
            FMLLog.severe("The substitution of %s has already occurred. You cannot duplicate substitutions", nameToReplace);
            throw new ExistingSubstitutionException(nameToReplace, replacement);
        }
        I original = this.getRaw(nameToReplace);
        if (original == null) {
            throw new NullPointerException("The replacement target is not present. This won't work");
        }
        if (!original.getClass().isAssignableFrom(replacement.getClass())) {
            FMLLog.severe("The substitute %s for %s (type %s) is type incompatible. This won't work", replacement.getClass().getName(), nameToReplace, original.getClass().getName());
            throw new IncompatibleSubstitutionException(nameToReplace, replacement, original);
        }
        int existingId = this.getId(replacement);
        if (existingId != -1) {
            FMLLog.severe("The substitute %s for %s is registered into the game independently. This won't work", replacement.getClass().getName(), nameToReplace);
            throw new IllegalArgumentException("The object substitution is already registered. This won't work");
        }
        FMLLog.log(Level.DEBUG, "Adding substitution %s with %s (name %s)", original, replacement, nameToReplace);
        this.getPersistentSubstitutions().put((Object)nameToReplace, replacement);
    }

    BiMap<kk, I> getPersistentSubstitutions() {
        return this.persistentSubstitutions;
    }

    public void a() {
        if (this.optionalDefaultKey != null) {
            Validate.notNull(this.optionalDefaultObject);
        }
    }

    public Iterator<I> iterator() {
        return Iterators.concat((Iterator)super.iterator(), this.getPersistentSubstitutions().values().iterator());
    }

    FMLControlledNamespacedRegistry<I> makeShallowCopy() {
        return new FMLControlledNamespacedRegistry<I>(this.optionalDefaultKey, this.maxId, this.minId, this.superType, this.isDelegated);
    }

    void resetSubstitutionDelegates() {
        if (!this.isDelegated) {
            return;
        }
        for (I obj : this.typeSafeIterable()) {
            RegistryDelegate.Delegate<I> delegate = this.getExistingDelegate(obj);
            delegate.changeReference(obj);
        }
    }

    public <T> FMLControlledNamespacedRegistry<T> asType(Class<? extends T> type) {
        return this;
    }

    public void serializeBlockList(Set<Integer> blocked) {
        blocked.addAll(this.blockedIds);
    }

    public Set<? extends kk> getActiveSubstitutions() {
        return this.activeSubstitutions.keySet();
    }

    public void loadAliases(Map<kk, kk> aliases) {
        for (Map.Entry<kk, kk> alias : aliases.entrySet()) {
            this.addAlias(alias.getKey(), alias.getValue());
        }
    }

    public void loadSubstitutions(Set<kk> substitutions) {
        for (kk rl : substitutions) {
            this.activateSubstitution(rl);
        }
    }

    public void loadBlocked(Set<Integer> blocked) {
        for (Integer id : blocked) {
            this.blockedIds.add(id);
            this.availabilityMap.set(id);
        }
    }

    public void loadDummied(Set<kk> dummied) {
        if (DEBUG && dummied.size() > 0) {
            FMLLog.fine("Registry Dummy Load: [%s]", Joiner.on((String)", ").join(dummied));
        }
        this.dummiedLocations.addAll(dummied);
    }

    public void loadIds(Map<kk, Integer> ids, Map<kk, Integer> missingIds, Map<kk, Integer[]> remappedIds, FMLControlledNamespacedRegistry<I> currentRegistry, kk registryName) {
        for (Map.Entry<kk, Integer> entry : ids.entrySet()) {
            kk itemName = entry.getKey();
            int newId = entry.getValue();
            int currId = currentRegistry.getId(itemName);
            if (currId == -1) {
                FMLLog.info("Found a missing id from the world %s", itemName);
                missingIds.put(entry.getKey(), newId);
                continue;
            }
            if (currId != newId) {
                FMLLog.fine("Fixed %s id mismatch %s: %d (init) -> %d (map).", registryName, itemName, currId, newId);
                remappedIds.put(itemName, new Integer[]{currId, newId});
            }
            I obj = super.getRaw(itemName);
            this.add(newId, itemName, obj);
        }
    }

    public void blockId(int id) {
        this.blockedIds.add(id);
    }

    public void notifyCallbacks() {
        if (this.addCallback == null) {
            return;
        }
        for (Object i2 : this.a) {
            this.addCallback.onAdd(i2, this.a.c(i2));
        }
    }

    public kk getNameForObject(I p_177774_1_) {
        kk rl = (kk)super.b(p_177774_1_);
        if (rl == null) {
            rl = (kk)this.activeSubstitutions.inverse().get(p_177774_1_);
        }
        return rl;
    }

    public static interface AddCallback<T> {
        public void onAdd(T var1, int var2);
    }
}

