/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;

public class GameData {
    static final int MIN_BLOCK_ID = 0;
    static final int MAX_BLOCK_ID = 4095;
    static final int MIN_ITEM_ID = 4096;
    static final int MAX_ITEM_ID = 31999;
    public static final int MIN_POTION_ID = 0;
    public static final int MAX_POTION_ID = 255;
    public static final int MIN_BIOME_ID = 0;
    public static final int MAX_BIOME_ID = 255;
    private static final GameData mainData = new GameData();
    private final FMLControlledNamespacedRegistry<ajt> iBlockRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BLOCKS, ajt.class, new kk("minecraft:air"), 4095, 0, true, BlockStateCapture.INSTANCE);
    private final FMLControlledNamespacedRegistry<ado> iItemRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ITEMS, ado.class, null, 31999, 4096, true, ItemBlockCapture.INSTANCE);
    private final FMLControlledNamespacedRegistry<rk> iPotionRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONS, rk.class, null, 255, 0, false, PotionArrayCapture.INSTANCE);
    private final FMLControlledNamespacedRegistry<aig> iBiomeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BIOMES, aig.class, null, 255, 0, false, BiomeCapture.INSTANCE);
    private static BiMap<ajt, ado> BLOCK_TO_ITEM = HashBiMap.create();
    private static ClearableObjectIntIdentityMap<arc> BLOCKSTATE_TO_ID = new ClearableObjectIntIdentityMap();

    public static FMLControlledNamespacedRegistry<ajt> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    public static FMLControlledNamespacedRegistry<ado> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    public static FMLControlledNamespacedRegistry<rk> getPotionRegistry() {
        return GameData.getMain().iPotionRegistry;
    }

    public static FMLControlledNamespacedRegistry<aig> getBiomeRegistry() {
        return GameData.getMain().iBiomeRegistry;
    }

    static ado findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.getObject(new kk(modId, name));
    }

    static ajt findBlock(String modId, String name) {
        return GameData.getMain().iBlockRegistry.getObject(new kk(modId, name));
    }

    static GameRegistry.UniqueIdentifier getUniqueName(ajt block) {
        if (block == null) {
            return null;
        }
        kk name = GameData.getMain().iBlockRegistry.getNameForObject(block);
        return new GameRegistry.UniqueIdentifier(name);
    }

    static GameRegistry.UniqueIdentifier getUniqueName(ado item) {
        if (item == null) {
            return null;
        }
        kk name = GameData.getMain().iItemRegistry.getNameForObject(item);
        return new GameRegistry.UniqueIdentifier(name);
    }

    protected static GameData getMain() {
        return mainData;
    }

    int registerItem(ado item, String name) {
        return this.iItemRegistry.add(-1, this.addPrefix(name), item);
    }

    int registerBlock(ajt block, String name) {
        return this.iBlockRegistry.add(-1, this.addPrefix(name), block);
    }

    private kk addPrefix(String name) {
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        name = index == -1 ? name : name.substring(index + 1);
        ModContainer mc = Loader.instance().activeModContainer();
        String prefix = mc != null ? mc.getModId().toLowerCase() : "minecraft";
        if (!oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            FMLLog.bigWarning("Dangerous alternative prefix %s for name %s, invalid registry invocation/invalid name?", prefix, name);
            prefix = oldPrefix;
        }
        return new kk(prefix, name);
    }

    void registerSubstitutionAlias(String name, GameRegistry.Type type, Object toReplace) throws ExistingSubstitutionException {
        kk nameToSubstitute = new kk(name);
        if (type == GameRegistry.Type.BLOCK) {
            this.iBlockRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (ajt)toReplace);
            ajt orig = this.iBlockRegistry.activateSubstitution(nameToSubstitute);
            if (BLOCK_TO_ITEM.containsKey((Object)orig)) {
                ado i2 = (ado)BLOCK_TO_ITEM.get((Object)orig);
                BLOCK_TO_ITEM.forcePut((Object)((ajt)toReplace), (Object)i2);
            }
        } else if (type == GameRegistry.Type.ITEM) {
            this.iItemRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (ado)toReplace);
            ado orig = this.iItemRegistry.activateSubstitution(nameToSubstitute);
            if (BLOCK_TO_ITEM.containsValue((Object)orig)) {
                ajt b2 = (ajt)BLOCK_TO_ITEM.inverse().get((Object)orig);
                BLOCK_TO_ITEM.forcePut((Object)b2, (Object)((ado)toReplace));
            }
        }
    }

    public static Map<ajt, ado> getBlockItemMap() {
        return BLOCK_TO_ITEM;
    }

    public static ClearableObjectIntIdentityMap<arc> getBlockStateIDMap() {
        return BLOCKSTATE_TO_ID;
    }

    public <T> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistryManager.makeDelegate(obj, rootClass);
    }

    private static class BiomeCapture
    implements FMLControlledNamespacedRegistry.AddCallback<aig> {
        static final BiomeCapture INSTANCE = new BiomeCapture();

        private BiomeCapture() {
        }

        @Override
        public void onAdd(aig potion, int id) {
        }
    }

    private static class PotionArrayCapture
    implements FMLControlledNamespacedRegistry.AddCallback<rk> {
        static final PotionArrayCapture INSTANCE = new PotionArrayCapture();

        private PotionArrayCapture() {
        }

        @Override
        public void onAdd(rk potion, int id) {
        }
    }

    private static class ItemBlockCapture
    implements FMLControlledNamespacedRegistry.AddCallback<ado> {
        static final ItemBlockCapture INSTANCE = new ItemBlockCapture();

        private ItemBlockCapture() {
        }

        @Override
        public void onAdd(ado item, int blockId) {
            if (item instanceof acc) {
                acc itemBlock = (acc)item;
                BLOCK_TO_ITEM.forcePut(itemBlock.d().delegate.get(), (Object)item);
            }
        }
    }

    private static class BlockStateCapture
    implements FMLControlledNamespacedRegistry.AddCallback<ajt> {
        static final BlockStateCapture INSTANCE = new BlockStateCapture();

        private BlockStateCapture() {
        }

        @Override
        public void onAdd(ajt block, int blockId) {
            for (arc state : block.t().a()) {
                BLOCKSTATE_TO_ID.a(state, blockId << 4 | block.e(state));
            }
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends ct<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.a.clear();
            this.b.clear();
        }
    }
}

