/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class VillagerRegistry {
    public static final kk PROFESSIONS = new kk("minecraft:villagerprofessions");
    private static final VillagerRegistry INSTANCE = new VillagerRegistry();
    private Map<Class<?>, IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    private List<Integer> newVillagerIds = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private Map<Integer, kk> newVillagers;
    private boolean hasInit = false;
    private FMLControlledNamespacedRegistry<VillagerProfession> professions = PersistentRegistryManager.createRegistry(PROFESSIONS, VillagerProfession.class, null, 1024, 0, true, null);

    private VillagerRegistry() {
        this.init();
    }

    public static VillagerRegistry instance() {
        return INSTANCE;
    }

    @Deprecated
    public void registerVillagerId(int id) {
        if (this.newVillagerIds.contains(id)) {
            FMLLog.severe("Attempt to register duplicate villager id %d", id);
            throw new RuntimeException();
        }
        this.newVillagerIds.add(id);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public void registerVillagerSkin(int villagerId, kk villagerSkin) {
        if (this.newVillagers == null) {
            this.newVillagers = Maps.newHashMap();
        }
        this.newVillagers.put(villagerId, villagerSkin);
    }

    public void registerVillageCreationHandler(IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static kk getVillagerSkin(int villagerType, kk defaultSkin) {
        if (VillagerRegistry.instance().newVillagers != null && VillagerRegistry.instance().newVillagers.containsKey(villagerType)) {
            return VillagerRegistry.instance().newVillagers.get(villagerType);
        }
        return defaultSkin;
    }

    @Deprecated
    public static Collection<Integer> getRegisteredVillagers() {
        return Collections.unmodifiableCollection(VillagerRegistry.instance().newVillagerIds);
    }

    public static void addExtraVillageComponents(List<awk.e> list, Random random, int i2) {
        List<awk.e> parts = list;
        for (IVillageCreationHandler handler : VillagerRegistry.instance().villageCreationHandlers.values()) {
            parts.add(handler.getVillagePieceWeight(random, i2));
        }
    }

    public static awk.n getVillageComponent(awk.e villagePiece, awk.k startPiece, List<awg> pieces, Random random, int p1, int p2, int p3, cq facing, int p5) {
        return VillagerRegistry.instance().villageCreationHandlers.get(villagePiece.a).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, facing, p5);
    }

    public void register(VillagerProfession prof) {
        this.register(prof, -1);
    }

    private void register(VillagerProfession prof, int id) {
        this.professions.register(id, prof.name, prof);
    }

    private void init() {
        if (this.hasInit) {
            return;
        }
        VillagerProfession prof = new VillagerProfession("minecraft:farmer", "minecraft:textures/entity/villager/farmer.png");
        this.register(prof, 0);
        new VillagerCareer(prof, "farmer").init(VanillaTrades.trades[0][0]);
        new VillagerCareer(prof, "fisherman").init(VanillaTrades.trades[0][1]);
        new VillagerCareer(prof, "shepherd").init(VanillaTrades.trades[0][2]);
        new VillagerCareer(prof, "fletcher").init(VanillaTrades.trades[0][3]);
        prof = new VillagerProfession("minecraft:librarian", "minecraft:textures/entity/villager/librarian.png");
        this.register(prof, 1);
        new VillagerCareer(prof, "librarian").init(VanillaTrades.trades[1][0]);
        prof = new VillagerProfession("minecraft:priest", "minecraft:textures/entity/villager/priest.png");
        this.register(prof, 2);
        new VillagerCareer(prof, "cleric").init(VanillaTrades.trades[2][0]);
        prof = new VillagerProfession("minecraft:smith", "minecraft:textures/entity/villager/smith.png");
        this.register(prof, 3);
        new VillagerCareer(prof, "armor").init(VanillaTrades.trades[3][0]);
        new VillagerCareer(prof, "weapon").init(VanillaTrades.trades[3][1]);
        new VillagerCareer(prof, "tool").init(VanillaTrades.trades[3][2]);
        prof = new VillagerProfession("minecraft:butcher", "minecraft:textures/entity/villager/butcher.png");
        this.register(prof, 4);
        new VillagerCareer(prof, "butcher").init(VanillaTrades.trades[4][0]);
        new VillagerCareer(prof, "leather").init(VanillaTrades.trades[4][1]);
    }

    public static void setRandomProfession(ze entity, Random rand) {
        Set entries = VillagerRegistry.INSTANCE.professions.c();
        int prof = rand.nextInt(entries.size());
        entity.l(rand.nextInt(5));
    }

    private static class VanillaTrades {
        private static final ze.f[][][][] trades = new ze.f[][][][]{{{{new ze.a(ads.Q, new ze.g(18, 22)), new ze.a(ads.cc, new ze.g(15, 19)), new ze.a(ads.cb, new ze.g(15, 19)), new ze.e(ads.R, new ze.g(-4, -2))}, {new ze.a(ado.a((ajt)aju.aU), new ze.g(8, 13)), new ze.e(ads.ck, new ze.g(-3, -2))}, {new ze.a(ado.a((ajt)aju.bk), new ze.g(7, 12)), new ze.e(ads.e, new ze.g(-5, -7))}, {new ze.e(ads.bj, new ze.g(-6, -10)), new ze.e(ads.bg, new ze.g(1, 1))}}, {{new ze.a(ads.H, new ze.g(15, 20)), new ze.a(ads.j, new ze.g(16, 24)), new ze.d(ads.bb, new ze.g(6, 6), ads.bc, new ze.g(6, 6))}, {new ze.c((ado)ads.aY, new ze.g(7, 8))}}, {{new ze.a(ado.a((ajt)aju.L), new ze.g(16, 22)), new ze.e((ado)ads.bl, new ze.g(3, 4))}, {new ze.e(new adq(aju.L, 1, 0), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 1), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 2), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 3), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 4), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 5), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 6), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 7), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 8), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 9), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 10), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 11), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 12), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 13), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 14), new ze.g(1, 2)), new ze.e(new adq(aju.L, 1, 15), new ze.g(1, 2))}}, {{new ze.a(ads.H, new ze.g(15, 20)), new ze.e(ads.g, new ze.g(-12, -8))}, {new ze.e((ado)ads.f, new ze.g(2, 3)), new ze.d(ado.a((ajt)aju.n), new ze.g(10, 10), ads.am, new ze.g(6, 10))}}}, {{{new ze.a(ads.aR, new ze.g(24, 36)), new ze.b()}, {new ze.a(ads.aS, new ze.g(8, 10)), new ze.e(ads.aX, new ze.g(10, 12)), new ze.e(ado.a((ajt)aju.X), new ze.g(3, 4))}, {new ze.a(ads.bX, new ze.g(2, 2)), new ze.e(ads.aZ, new ze.g(10, 12)), new ze.e(ado.a((ajt)aju.w), new ze.g(-5, -3))}, {new ze.b()}, {new ze.b()}, {new ze.e(ads.cy, new ze.g(20, 22))}}}, {{{new ze.a(ads.bA, new ze.g(36, 40)), new ze.a(ads.m, new ze.g(8, 10))}, {new ze.e(ads.aE, new ze.g(-4, -1)), new ze.e(new adq(ads.bd, 1, act.l.b()), new ze.g(-2, -1))}, {new ze.e(ads.bB, new ze.g(4, 7)), new ze.e(ado.a((ajt)aju.aX), new ze.g(-3, -1))}, {new ze.e(ads.bU, new ze.g(3, 11))}}}, {{{new ze.a(ads.j, new ze.g(16, 24)), new ze.e((ado)ads.aa, new ze.g(4, 6))}, {new ze.a(ads.l, new ze.g(7, 9)), new ze.e((ado)ads.ab, new ze.g(10, 14))}, {new ze.a(ads.k, new ze.g(3, 4)), new ze.c((ado)ads.af, new ze.g(16, 19))}, {new ze.e((ado)ads.Z, new ze.g(5, 7)), new ze.e((ado)ads.Y, new ze.g(9, 11)), new ze.e((ado)ads.W, new ze.g(5, 7)), new ze.e((ado)ads.X, new ze.g(11, 15))}}, {{new ze.a(ads.j, new ze.g(16, 24)), new ze.e(ads.c, new ze.g(6, 8))}, {new ze.a(ads.l, new ze.g(7, 9)), new ze.c(ads.n, new ze.g(9, 10))}, {new ze.a(ads.k, new ze.g(3, 4)), new ze.c(ads.w, new ze.g(12, 15)), new ze.c(ads.z, new ze.g(9, 12))}}, {{new ze.a(ads.j, new ze.g(16, 24)), new ze.c(ads.a, new ze.g(5, 7))}, {new ze.a(ads.l, new ze.g(7, 9)), new ze.c(ads.b, new ze.g(9, 11))}, {new ze.a(ads.k, new ze.g(3, 4)), new ze.c(ads.y, new ze.g(12, 15))}}}, {{{new ze.a(ads.an, new ze.g(14, 18)), new ze.a(ads.br, new ze.g(14, 18))}, {new ze.a(ads.j, new ze.g(16, 24)), new ze.e(ads.ao, new ze.g(-7, -5)), new ze.e(ads.bs, new ze.g(-8, -6))}}, {{new ze.a(ads.aM, new ze.g(9, 12)), new ze.e((ado)ads.U, new ze.g(2, 4))}, {new ze.c((ado)ads.T, new ze.g(7, 12))}, {new ze.e(ads.aC, new ze.g(8, 10))}}}};

        private VanillaTrades() {
        }
    }

    public static class VillagerCareer {
        private VillagerProfession profession;
        private String name;
        private int id;

        public VillagerCareer(VillagerProfession parent, String name) {
            this.profession = parent;
            this.name = name;
            parent.register(this);
        }

        private VillagerCareer init(ze.f[][] traids) {
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VillagerCareer)) {
                return false;
            }
            VillagerCareer oc = (VillagerCareer)o;
            return this.name.equals(oc.name) && this.profession == oc.profession;
        }
    }

    public static class VillagerProfession {
        private kk name;
        private kk texture;
        private List<VillagerCareer> careers = Lists.newArrayList();
        public final RegistryDelegate<VillagerProfession> delegate = PersistentRegistryManager.makeDelegate(this, VillagerProfession.class);

        public VillagerProfession(String name, String texture) {
            this.name = new kk(name);
            this.texture = new kk(texture);
            ((RegistryDelegate.Delegate)this.delegate).setResourceName(this.name);
        }

        private void register(VillagerCareer career) {
            Validate.isTrue((!this.careers.contains(career) ? 1 : 0) != 0, (String)"Attempted to register career that is already registered.", (Object[])new Object[0]);
            Validate.isTrue((career.profession == this ? 1 : 0) != 0, (String)"Attempted to register career for the wrong profession.", (Object[])new Object[0]);
            career.id = this.careers.size();
            this.careers.add(career);
        }
    }

    public static interface IVillageCreationHandler {
        public awk.e getVillagePieceWeight(Random var1, int var2);

        public Class<?> getComponentClass();

        public awk.n buildComponent(awk.e var1, awk.k var2, List<awg> var3, Random var4, int var5, int var6, int var7, cq var8, int var9);
    }
}

