/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;

public class ForgeTimeTracker {
    public static boolean tileEntityTracking;
    public static int tileEntityTrackingDuration;
    public static long tileEntityTrackingTime;
    private Map<apv, int[]> tileEntityTimings;
    private WeakReference<apv> tile;
    private static final ForgeTimeTracker INSTANCE;
    private long timing;

    private ForgeTimeTracker() {
        MapMaker mm2 = new MapMaker();
        mm2.weakKeys();
        this.tileEntityTimings = mm2.makeMap();
    }

    private void trackTileStart(apv tileEntity, long nanoTime) {
        if (tileEntityTrackingTime == 0L) {
            tileEntityTrackingTime = nanoTime;
        } else if (tileEntityTrackingTime + (long)tileEntityTrackingDuration < nanoTime) {
            tileEntityTracking = false;
            tileEntityTrackingTime = 0L;
            return;
        }
        this.tile = new WeakReference<apv>(tileEntity);
        this.timing = nanoTime;
    }

    private void trackTileEnd(apv tileEntity, long nanoTime) {
        if (this.tile == null || this.tile.get() != tileEntity) {
            this.tile = null;
            return;
        }
        int[] timings = this.tileEntityTimings.get(tileEntity);
        if (timings == null) {
            timings = new int[101];
            this.tileEntityTimings.put(tileEntity, timings);
        }
        int idx = timings[100] = (timings[100] + 1) % 100;
        timings[idx] = (int)(nanoTime - this.timing);
    }

    public static ImmutableMap<apv, int[]> getTileTimings() {
        return INSTANCE.buildImmutableTileEntityTimingMap();
    }

    private ImmutableMap<apv, int[]> buildImmutableTileEntityTimingMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<apv, int[]> entry : this.tileEntityTimings.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)Arrays.copyOfRange(entry.getValue(), 0, 100));
        }
        return builder.build();
    }

    public static void trackStart(apv tileEntity) {
        if (!tileEntityTracking) {
            return;
        }
        INSTANCE.trackTileStart(tileEntity, System.nanoTime());
    }

    public static void trackEnd(apv tileEntity) {
        if (!tileEntityTracking) {
            return;
        }
        INSTANCE.trackTileEnd(tileEntity, System.nanoTime());
    }

    public static void trackStart(rr par1Entity) {
    }

    public static void trackEnd(rr par1Entity) {
    }

    static {
        INSTANCE = new ForgeTimeTracker();
    }
}

