/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.ScaledResolution;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.IScreenBase;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.minimap.MinimapInterface;

public class MinimapInterfaceInstance
extends InterfaceInstance {
    private XaeroMinimapSession minimapSession;
    private IXaeroMinimap modMain;

    public MinimapInterfaceInstance(MinimapInterface inter, IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        super(inter);
        this.minimapSession = minimapSession;
        this.modMain = modMain;
    }

    @Override
    public void prePotentialRender() {
        try {
            super.prePotentialRender();
            this.minimapSession.getMinimapProcessor().checkFBO();
        }
        catch (Throwable e) {
            ((MinimapInterface)this.inter).setCrashedWith(e);
            ((MinimapInterface)this.inter).checkCrashes();
        }
    }

    @Override
    public void render(int width, int height, ScaledResolution scaledRes, float partial) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP) || mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP_BENEFICIAL) || mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP_HARMFUL)) {
            return;
        }
        if (this.modMain.getSettings().hideMinimapUnderScreen && mc.field_71462_r != null && !(mc.field_71462_r instanceof IScreenBase) && !(mc.field_71462_r instanceof GuiChat) && !(mc.field_71462_r instanceof GuiGameOver) || this.modMain.getSettings().hideMinimapUnderF3 && mc.field_71474_y.field_74330_P) {
            return;
        }
        int scale = scaledRes.func_78325_e();
        this.minimapSession.getMinimapProcessor().onRender(this.inter.getX(), this.inter.getY(), width, height, scaledRes, this.getInterfaceWidth(scale), this.getW(scale), partial);
        super.render(width, height, scaledRes, partial);
    }

    @Override
    public int getW(double scale) {
        return (int)((double)((float)this.getInterfaceWidth(scale) * this.modMain.getSettings().getMinimapScale(scale)) / scale);
    }

    @Override
    public int getH(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getWC(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getHC(double scale) {
        return this.getH(scale);
    }

    @Override
    public int getW0(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getH0(double scale) {
        return this.getH(scale);
    }

    public int getInterfaceWidth(double scale) {
        return this.minimapSession.getMinimapProcessor().getMinimapSize(scale) / 2 + 18;
    }

    @Override
    public int getSize(double scale) {
        int w = this.getInterfaceWidth(scale);
        return w * w;
    }
}

