/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.element.render.map.MinimapElementMapRendererHandler;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.element.RadarRenderer;
import xaero.common.minimap.waypoints.render.CompassRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class MinimapFBORenderer
extends MinimapRenderer {
    private ImprovedFramebuffer scalingFramebuffer;
    private ImprovedFramebuffer rotationFramebuffer;
    private MinimapElementMapRendererHandler minimapElementMapRendererHandler;
    private RadarRenderer radarRenderer;
    private EntityIconManager entityIconManager;
    private boolean triedFBO;
    private boolean loadedFBO;

    public MinimapFBORenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface, CompassRenderer compassRenderer) {
        super(modMain, mc, waypointsGuiRenderer, minimapInterface, compassRenderer);
    }

    public void loadFrameBuffer(MinimapProcessor minimapProcessor) {
        if (!minimapProcessor.canUseFrameBuffer()) {
            MinimapLogs.LOGGER.info("FBO mode not supported! Using minimap safe mode.");
        } else {
            this.scalingFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer.func_147607_a(9729);
            this.loadedFBO = this.scalingFramebuffer.field_147616_f != -1 && this.rotationFramebuffer.field_147616_f != -1;
            this.entityIconManager = new EntityIconManager(this.modMain, new EntityIconPrerenderer(this.modMain));
            this.minimapElementMapRendererHandler = MinimapElementMapRendererHandler.Builder.begin().build();
            this.radarRenderer = RadarRenderer.Builder.begin().setModMain(this.modMain).setEntityIconManager(this.entityIconManager).setMinimapInterface(this.minimapInterface).build();
            this.minimapElementMapRendererHandler.add(this.radarRenderer);
            this.minimapInterface.getOverMapRendererHandler().add(this.radarRenderer);
            if (this.modMain.getSupportMods().worldmap()) {
                this.modMain.getSupportMods().worldmapSupport.createRadarRenderWrapper(this.radarRenderer);
            }
        }
        this.triedFBO = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderChunks(XaeroMinimapSession minimapSession, MinimapProcessor minimap, int mapSize, int bufferSize, float sizeFix, float partial, int lightLevel, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, ScaledResolution scaledRes, ModSettings settings) {
        MinimapWriter minimapWriter = minimap.getMinimapWriter();
        synchronized (minimapWriter) {
            this.renderChunksToFBO(minimapSession, minimap, (EntityPlayer)this.mc.field_71439_g, this.mc.func_175606_aa(), bufferSize, mapSize, sizeFix, partial, lightLevel, true, useWorldMap, lockedNorth, shape, ps, pc, cave, circle, scaledRes);
        }
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        GlStateManager.func_179083_b((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
        this.rotationFramebuffer.func_147612_c();
    }

    public void renderChunksToFBO(XaeroMinimapSession minimapSession, MinimapProcessor minimap, EntityPlayer player, Entity renderEntity, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, ScaledResolution scaledRes) {
        double zInsidePixel;
        double maxVisibleLength = lockedNorth || shape == 1 ? (double)viewW : (double)viewW * Math.sqrt(2.0);
        double halfMaxVisibleLength = maxVisibleLength / 2.0;
        double radiusBlocks = maxVisibleLength / 2.0 / this.zoom;
        double playerX = minimap.getEntityRadar().getEntityX(renderEntity, partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(renderEntity, partial);
        int xFloored = OptimizedMath.myFloor(playerX);
        int zFloored = OptimizedMath.myFloor(playerZ);
        int playerChunkX = xFloored >> 6;
        int playerChunkZ = zFloored >> 6;
        int offsetX = xFloored & 0x3F;
        int offsetZ = zFloored & 0x3F;
        boolean zooming = (double)((int)this.zoom) != this.zoom;
        this.scalingFramebuffer.func_147610_a(true);
        GL11.glClear((int)16640);
        GlStateManager.func_179098_w();
        RenderHelper.func_74518_a();
        long before = System.currentTimeMillis();
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        this.helper.defaultOrtho(this.scalingFramebuffer, scaledRes);
        GlStateManager.func_179128_n((int)5888);
        GL11.glPushMatrix();
        GlStateManager.func_179096_D();
        before = System.currentTimeMillis();
        double xInsidePixel = minimap.getEntityRadar().getEntityX(renderEntity, partial) - (double)xFloored;
        if (xInsidePixel < 0.0) {
            xInsidePixel += 1.0;
        }
        if ((zInsidePixel = minimap.getEntityRadar().getEntityZ(renderEntity, partial) - (double)zFloored) < 0.0) {
            zInsidePixel += 1.0;
        }
        float halfWView = (float)viewW / 2.0f;
        float angle = (float)(90.0 - this.getRenderAngle(lockedNorth));
        GlStateManager.func_179147_l();
        GlStateManager.func_179109_b((float)256.0f, (float)256.0f, (float)-2000.0f);
        GlStateManager.func_179139_a((double)this.zoom, (double)this.zoom, (double)1.0);
        Gui.func_73734_a((int)-256, (int)-256, (int)256, (int)256, (int)-16777216);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float chunkGridAlphaMultiplier = 1.0f;
        int minX = playerChunkX + (int)Math.floor(((double)offsetX - radiusBlocks) / 64.0);
        int minZ = playerChunkZ + (int)Math.floor(((double)offsetZ - radiusBlocks) / 64.0);
        int maxX = playerChunkX + (int)Math.floor(((double)(offsetX + 1) + radiusBlocks) / 64.0);
        int maxZ = playerChunkZ + (int)Math.floor(((double)(offsetZ + 1) + radiusBlocks) / 64.0);
        if (useWorldMap) {
            chunkGridAlphaMultiplier = this.modMain.getSupportMods().worldmapSupport.getMinimapBrightness();
            this.modMain.getSupportMods().worldmapSupport.drawMinimap(minimapSession, this.helper, xFloored, zFloored, minX, minZ, maxX, maxZ, zooming, this.zoom);
        } else if (minimap.getMinimapWriter().getLoadedBlocks() != null && level >= 0) {
            int loadedLevels = minimap.getMinimapWriter().getLoadedLevels();
            chunkGridAlphaMultiplier = loadedLevels <= 1 ? 1.0f : 0.375f + 0.625f * (1.0f - (float)level / (float)(loadedLevels - 1));
            int loadedMapChunkX = minimap.getMinimapWriter().getLoadedMapChunkX();
            int loadedMapChunkZ = minimap.getMinimapWriter().getLoadedMapChunkZ();
            int loadedWidth = minimap.getMinimapWriter().getLoadedBlocks().length;
            boolean slimeChunks = this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager());
            minX = Math.max(minX, loadedMapChunkX);
            minZ = Math.max(minZ, loadedMapChunkZ);
            maxX = Math.min(maxX, loadedMapChunkX + loadedWidth - 1);
            maxZ = Math.min(maxZ, loadedMapChunkZ + loadedWidth - 1);
            for (int X = minX; X <= maxX; ++X) {
                int canvasX = X - minimap.getMinimapWriter().getLoadedMapChunkX();
                for (int Z = minZ; Z <= maxZ; ++Z) {
                    int canvasZ = Z - minimap.getMinimapWriter().getLoadedMapChunkZ();
                    MinimapChunk mchunk = minimap.getMinimapWriter().getLoadedBlocks()[canvasX][canvasZ];
                    if (mchunk == null) continue;
                    mchunk.bindTexture(level);
                    if (!mchunk.isHasSomething() || level >= mchunk.getLevelsBuffered() || mchunk.getGlTexture(level) == 0) continue;
                    if (!zooming) {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    } else {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    }
                    int drawX = (X - playerChunkX) * 64 - offsetX;
                    int drawZ = (Z - playerChunkZ) * 64 - offsetZ;
                    GlStateManager.func_179147_l();
                    GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                    this.helper.drawMyTexturedModalRect(drawX, drawZ, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    if (slimeChunks) {
                        for (int t = 0; t < 16; ++t) {
                            if (mchunk.getTile(t % 4, t / 4) == null || !mchunk.getTile(t % 4, t / 4).isSlimeChunk()) continue;
                            int slimeDrawX = drawX + 16 * (t % 4);
                            int slimeDrawZ = drawZ + 16 * (t / 4);
                            Gui.func_73734_a((int)slimeDrawX, (int)slimeDrawZ, (int)(slimeDrawX + 16), (int)(slimeDrawZ + 16), (int)-2142047936);
                        }
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        }
        if (this.modMain.getSettings().chunkGrid > -1) {
            int i;
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
            int r = grid >> 16 & 0xFF;
            int g = grid >> 8 & 0xFF;
            int b = grid & 0xFF;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            vertexBuffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            float red = (float)r / 255.0f;
            float green = (float)g / 255.0f;
            float blue = (float)b / 255.0f;
            float alpha = 0.8f;
            float colorMultiplier = chunkGridAlphaMultiplier;
            red *= colorMultiplier;
            green *= colorMultiplier;
            blue *= colorMultiplier;
            GlStateManager.func_187441_d((float)this.modMain.getSettings().chunkGridLineWidth);
            int bias = (int)Math.ceil(this.zoom);
            for (int X = minX; X <= maxX; ++X) {
                int drawX = (X - playerChunkX + 1) * 64 - offsetX;
                for (i = 0; i < 4; ++i) {
                    float lineX = (float)drawX + (float)(-16 * i);
                    this.helper.addColoredLineToExistingBuffer(vertexBuffer, lineX, -((float)halfMaxVisibleLength), lineX, (float)halfMaxVisibleLength + (float)bias, red, green, blue, alpha);
                }
            }
            for (int Z = minZ; Z <= maxZ; ++Z) {
                int drawZ = (Z - playerChunkZ + 1) * 64 - offsetZ;
                for (i = 0; i < 4; ++i) {
                    float lineZ = (float)drawZ + (float)((double)(-16 * i) - 1.0 / this.zoom);
                    this.helper.addColoredLineToExistingBuffer(vertexBuffer, -((float)halfMaxVisibleLength), lineZ, (float)halfMaxVisibleLength + (float)bias, lineZ, red, green, blue, alpha);
                }
            }
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179098_w();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        }
        this.scalingFramebuffer.func_147609_e();
        this.rotationFramebuffer.func_147610_a(false);
        GL11.glClear((int)16640);
        this.scalingFramebuffer.func_147612_c();
        GlStateManager.func_179096_D();
        if (this.modMain.getSettings().getAntiAliasing()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_179109_b((float)halfWView, (float)halfWView, (float)-2980.0f);
        GL11.glPushMatrix();
        if (!lockedNorth) {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179137_b((double)(-xInsidePixel * this.zoom), (double)(-zInsidePixel * this.zoom), (double)0.0);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(this.modMain.getSettings().minimapOpacity / 100.0)));
        this.helper.drawMyTexturedModalRect(-256.0f, -256.0f, 0, 0, 512.0f, 512.0f, 512.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        before = System.currentTimeMillis();
        GlStateManager.func_179118_c();
        GlStateManager.func_179092_a((int)516, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)1);
        GlStateManager.func_179143_c((int)519);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179144_i((int)1);
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179094_E();
        this.minimapElementMapRendererHandler.render(renderEntity, player, playerX, renderEntity.field_70163_u, playerZ, ps, pc, this.zoom, cave, partial, this.rotationFramebuffer, this.modMain, this.helper, this.mc.field_71466_p, scaledRes, halfWView);
        GlStateManager.func_179121_F();
        this.rotationFramebuffer.func_147609_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179128_n((int)5889);
        Misc.minecraftOrtho(scaledRes);
        GlStateManager.func_179128_n((int)5888);
        GL11.glPopMatrix();
    }

    public void deleteFramebuffers() {
        this.scalingFramebuffer.func_147608_a();
        this.rotationFramebuffer.func_147608_a();
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public boolean isLoadedFBO() {
        return this.loadedFBO;
    }

    public void setLoadedFBO(boolean loadedFBO) {
        this.loadedFBO = loadedFBO;
    }

    public boolean isTriedFBO() {
        return this.triedFBO;
    }

    public void resetEntityIcons() {
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public void resetEntityIconsResources() {
        if (this.entityIconManager != null) {
            this.entityIconManager.resetResources();
        }
    }

    public void onEntityIconsModelPartRenderDetection(ModelRenderer modelRenderer) {
        this.entityIconManager.onModelPartRenderDetection(modelRenderer);
    }

    public void renderMainEntityDot(MinimapProcessor minimap, EntityPlayer p, Entity renderEntity, double ps, double pc, double playerX, double playerZ, float partial, MinimapRadar minimapRadar, boolean lockedNorth, int style, boolean smooth, boolean debug, boolean cave, double dotNameScale, ModSettings settings, ScaledResolution scaledRes) {
        EntityRadarCategory mainEntityCategory = minimapRadar.getEntityCategoryManager().getRuleResolver().resolve(minimapRadar.getEntityCategoryManager().getRootCategory(), renderEntity, p);
        if (mainEntityCategory == null) {
            mainEntityCategory = minimapRadar.getEntityCategoryManager().getRootCategory();
        }
        int dotSize = settings.mainDotSize;
        this.radarRenderer.renderEntityDotToFBO(1, false, minimap, p, renderEntity, renderEntity, partial, false, false, minimapRadar, style, smooth, debug, false, cave, dotNameScale, 0, false, 100, false, 100, 1.0, dotSize, mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue(), false, mainEntityCategory, this.getHelper(), this.mc.field_71466_p, this.rotationFramebuffer, scaledRes);
    }

    public RadarRenderer getRadarRenderer() {
        return this.radarRenderer;
    }
}

