/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.api.caps.abilities;

import com.sofodev.armorplus.api.caps.abilities.AbilityDataHandler;
import com.sofodev.armorplus.api.caps.abilities.AbilityPotion;
import com.sofodev.armorplus.api.caps.abilities.EquipmentSlot;
import com.sofodev.armorplus.api.caps.abilities.ISpecialItem;
import com.sofodev.armorplus.api.caps.abilities.ImplementedAbilities;
import com.sofodev.armorplus.api.caps.abilities.MaterialType;
import com.sofodev.armorplus.common.util.PotionUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AbilityData
extends IForgeRegistryEntry.Impl<AbilityData> {
    private final String name;
    private final EntityEquipmentSlot[] slot;
    private final MaterialType[] materials;
    private boolean isPotion = false;

    public AbilityData(ResourceLocation rl, String translatableName, EquipmentSlot slot, MaterialType ... materials) {
        this.setRegistryName(rl);
        this.name = new TextComponentTranslation(translatableName, new Object[0]).func_150254_d();
        this.slot = slot.getSlots();
        this.materials = materials;
    }

    public AbilityData(String rl, String translatableName, EquipmentSlot slot, MaterialType ... materials) {
        this(new ResourceLocation(rl), translatableName, slot, materials);
    }

    public AbilityData(String rl, String translatableName, EntityEquipmentSlot a, EntityEquipmentSlot b, EntityEquipmentSlot c, EntityEquipmentSlot d, MaterialType ... materials) {
        this(rl, translatableName, new EquipmentSlot(a, b, c, d), materials);
    }

    public AbilityData(String rl, String translatableName, EntityEquipmentSlot a, EntityEquipmentSlot b, EntityEquipmentSlot c, MaterialType ... materials) {
        this(rl, translatableName, new EquipmentSlot(a, b, c), materials);
    }

    public AbilityData(String rl, String translatableName, EntityEquipmentSlot a, EntityEquipmentSlot b, MaterialType ... materials) {
        this(rl, translatableName, new EquipmentSlot(a, b), materials);
    }

    public AbilityData(String rl, String translatableName, EntityEquipmentSlot a, MaterialType ... materials) {
        this(rl, translatableName, new EquipmentSlot(a), materials);
    }

    public String getName() {
        return this.name;
    }

    public String getSafeName() {
        return this.getName().toLowerCase().replace(" ", "_");
    }

    public EntityEquipmentSlot[] getSlots() {
        return this.slot;
    }

    public MaterialType[] getMaterials() {
        return this.materials;
    }

    public AbilityData getData() {
        return this;
    }

    public boolean isPotion() {
        return this.isPotion;
    }

    public AbilityData setPotion(boolean potion) {
        this.isPotion = potion;
        return this;
    }

    public AbilityData applyPotionToPlayer(EntityPlayer player) {
        Potion actualPotion;
        AbilityPotion potion = new AbilityPotion().setResourceLocation(this.getRegistryName());
        if (this.isPotion() && this.getRegistryName() != null && ((actualPotion = PotionUtils.getPotion(potion.getResourceLocation())) != null || !player.func_70644_a(MobEffects.field_76428_l))) {
            PotionUtils.addPotion((EntityLivingBase)player, (Object)actualPotion, potion.getDuration(), potion.getAmplifier(), potion.isAmbientIn(), potion.getType());
        }
        return this;
    }

    public void onSpecialArmorTick(ItemStack stack, World world, EntityPlayer player) {
    }

    public void onArmorTick(ItemStack stack, World world, EntityPlayer player) {
    }

    public void onPlayerKillEntity(ItemStack stack, LivingDeathEvent event) {
    }

    public void onPlayerBreakBlock(ItemStack stack, BlockEvent.BreakEvent event) {
    }

    public void onPlayerPreDamaged(ItemStack stack, LivingHurtEvent event) {
    }

    public void onPlayerDamaged(ItemStack stack, LivingDamageEvent event) {
    }

    public void onPlayerJump(ItemStack stack, LivingEvent.LivingJumpEvent event) {
    }

    public static AbilityData getData(ResourceLocation resourceLocation) {
        return (AbilityData)ImplementedAbilities.ABILITY_REGISTRY.getValue(resourceLocation);
    }

    public static AbilityData getData(String safeID) {
        return ImplementedAbilities.ABILITY_REGISTRY.getValuesCollection().stream().filter(dataEntry -> dataEntry.getSafeName().equals(safeID)).findFirst().orElse(ImplementedAbilities.NONE);
    }

    public static ResourceLocation getResourceLocation(AbilityData data) {
        return ImplementedAbilities.ABILITY_REGISTRY.getKey((IForgeRegistryEntry)data);
    }

    public static boolean canProvide(ItemStack stack, AbilityData abilityData) {
        Item item = stack.func_77973_b();
        if (!(item instanceof ISpecialItem)) {
            return false;
        }
        ISpecialItem special = (ISpecialItem)item;
        if (!special.isSpecial(stack)) {
            return false;
        }
        if (special.isSpecialArmor(stack)) {
            if (special.hasSpecialMaterial()) {
                return AbilityData.hasEqualMaterials(abilityData, special, AbilityData.hasEqualSlots(abilityData, special));
            }
            return AbilityData.hasEqualSlots(abilityData, special);
        }
        if (special.hasSpecialMaterial()) {
            return AbilityData.hasEqualMaterials(abilityData, special, true);
        }
        return false;
    }

    private static boolean hasEqualMaterials(AbilityData abilityData, ISpecialItem special, boolean additionalChecks) {
        for (MaterialType mat : abilityData.getMaterials()) {
            if (mat == null || mat != special.getMaterial()) continue;
            return additionalChecks;
        }
        return false;
    }

    private static boolean hasEqualSlots(AbilityData abilityData, ISpecialItem armor) {
        return Arrays.stream(abilityData.getSlots()).anyMatch(equipmentSlot -> equipmentSlot != null && equipmentSlot == armor.getSlot());
    }

    public static boolean canProvide(ItemStack stack, ResourceLocation rl) {
        return AbilityData.canProvide(stack, AbilityData.getData(rl));
    }

    public static boolean canProvide(ItemStack stack, String safeID) {
        return AbilityData.canProvide(stack, AbilityData.getData(safeID));
    }

    public static boolean hasAbilities(AbilityDataHandler.IAbilityHandler handler) {
        return !handler.getAbilities().isEmpty();
    }

    public static boolean hasRoomForAbilities(AbilityDataHandler.IAbilityHandler handler) {
        return handler.getAbilities().size() < handler.getLimit();
    }

    public static boolean contains(AbilityDataHandler.IAbilityHandler handler, ResourceLocation rl) {
        List<AbilityData> list = handler.getAbilities();
        return list.contains((Object)AbilityData.getData(rl));
    }

    public static boolean contains(AbilityDataHandler.IAbilityHandler handler, AbilityData data) {
        return AbilityData.contains(handler, data.getRegistryName());
    }

    public static boolean contains(AbilityDataHandler.IAbilityHandler handler, String safeID) {
        return AbilityData.contains(handler, AbilityData.getData(safeID));
    }

    public static void provideArmorAbilities(ItemStack stack, World world, EntityPlayer player) {
        boolean hasAbilities;
        AbilityDataHandler.IAbilityHandler handler = AbilityDataHandler.getHandler(stack);
        boolean bl = hasAbilities = handler != null && AbilityData.hasAbilities(handler);
        if (!hasAbilities) {
            return;
        }
        for (AbilityData data : handler.getAbilities()) {
            if (!AbilityData.contains(handler, data)) continue;
            if (AbilityData.canProvide(stack, data)) {
                if (data.isPotion()) {
                    data.applyPotionToPlayer(player);
                }
                data.onArmorTick(stack, world, player);
            }
            data.onSpecialArmorTick(stack, world, player);
        }
    }
}

