/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.compat.jei;

import com.sofodev.armorplus.api.crafting.IRecipe;
import com.sofodev.armorplus.api.crafting.base.BaseCraftingManager;
import com.sofodev.armorplus.api.crafting.base.BaseShapedOreRecipe;
import com.sofodev.armorplus.api.crafting.base.BaseShapedRecipe;
import com.sofodev.armorplus.api.crafting.base.BaseShapelessOreRecipe;
import com.sofodev.armorplus.api.crafting.base.BaseShapelessRecipe;
import com.sofodev.armorplus.client.gui.GuiChampionBench;
import com.sofodev.armorplus.client.gui.GuiHighTechBench;
import com.sofodev.armorplus.client.gui.GuiLavaInfuser;
import com.sofodev.armorplus.client.gui.GuiUltiTechBench;
import com.sofodev.armorplus.client.gui.GuiWorkbench;
import com.sofodev.armorplus.common.compat.crafttweaker.lavainfuser.LavaInfuserRecipe;
import com.sofodev.armorplus.common.compat.jei.base.AdvancedRecipeTransferInfo;
import com.sofodev.armorplus.common.compat.jei.base.CategoryBase;
import com.sofodev.armorplus.common.compat.jei.base.CategoryBaseAdvanced;
import com.sofodev.armorplus.common.compat.jei.base.ShapedOreRecipeWrapper;
import com.sofodev.armorplus.common.compat.jei.base.ShapedRecipeWrapper;
import com.sofodev.armorplus.common.compat.jei.base.ShapelessOreRecipeWrapper;
import com.sofodev.armorplus.common.compat.jei.base.ShapelessRecipeWrapper;
import com.sofodev.armorplus.common.compat.jei.lavainfuser.InfuserRecipeMaker;
import com.sofodev.armorplus.common.compat.jei.lavainfuser.LavaInfuserCategory;
import com.sofodev.armorplus.common.compat.jei.lavainfuser.LavaInfuserRecipeWrapper;
import com.sofodev.armorplus.common.compat.jei.misc.OutputSlot;
import com.sofodev.armorplus.common.compat.jei.misc.UVData;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.container.ContainerChampionBench;
import com.sofodev.armorplus.common.container.ContainerHighTechBench;
import com.sofodev.armorplus.common.container.ContainerLavaInfuser;
import com.sofodev.armorplus.common.container.ContainerUltiTechBench;
import com.sofodev.armorplus.common.container.ContainerWorkbench;
import com.sofodev.armorplus.common.registry.ModBlocks;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.registry.constants.APItems;
import com.sofodev.armorplus.common.registry.items.ItemFragment;
import com.sofodev.armorplus.common.util.TextUtils;
import com.sofodev.armorplus.common.util.Utils;
import java.util.Arrays;
import java.util.stream.IntStream;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

@Optional.Interface(iface="mezz.jei.api.ingredients.IIngredientBlacklist", modid="jei", striprefs=true)
@JEIPlugin
public class ArmorPlusPlugin
implements IModPlugin {
    public static final String JEI_CATEGORY_WORKBENCH = Utils.setLocation("workbench");
    public static final String JEI_CATEGORY_HIGH_TECH_BENCH = Utils.setLocation("high_tech_bench");
    public static final String JEI_CATEGORY_ULTI_TECH_BENCH = Utils.setLocation("ulti_tech_bench");
    public static final String JEI_CATEGORY_CHAMPION_BENCH = Utils.setLocation("champion_bench");
    public static final String JEI_CATEGORY_LAVA_INFUSER = Utils.setLocation("lava_infuser_infusing");
    public static final String[] JEI_CATEGORIES = new String[]{JEI_CATEGORY_WORKBENCH, JEI_CATEGORY_HIGH_TECH_BENCH, JEI_CATEGORY_ULTI_TECH_BENCH, JEI_CATEGORY_CHAMPION_BENCH};
    public static IJeiHelpers jeiHelper;

    public static void setJeiHelper(IJeiHelpers jeiHelper) {
        ArmorPlusPlugin.jeiHelper = jeiHelper;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        ArmorPlusPlugin.setJeiHelper(registry.getJeiHelpers());
        registry.addRecipeCategories(new IRecipeCategory[]{new CategoryBase("workbench", new UVData(0, 0, 116, 54), new OutputSlot(94, 18), 3, JEI_CATEGORY_WORKBENCH), new CategoryBase("high_tech_bench", new UVData(0, 0, 144, 90), new OutputSlot(122, 37), 5, JEI_CATEGORY_HIGH_TECH_BENCH), new CategoryBaseAdvanced("ulti_tech_bench", new UVData(0, 0, 180, 126), new OutputSlot(158, 55), 7, JEI_CATEGORY_ULTI_TECH_BENCH, 160, 85), new CategoryBaseAdvanced("champion_bench", new UVData(0, 0, 162, 197), new OutputSlot(72, 179), 9, JEI_CATEGORY_CHAMPION_BENCH, 100, 182), new LavaInfuserCategory()});
    }

    public void register(IModRegistry registry) {
        ArmorPlusPlugin.setJeiHelper(registry.getJeiHelpers());
        if (ModConfig.IntegrationsConfig.enableJEIIntegration) {
            IIngredientBlacklist blacklist = jeiHelper.getIngredientBlacklist();
            this.registerDescriptions(registry);
            this.blackListIngredients(blacklist, ModItems.moddedCityItem, ModItems.jonBamsItem, ItemStackUtils.getItemStack((Object)ModItems.jonBamsItem, (int)1), ModItems.theDragonTeamItem, ModItems.twitchItem, ModItems.beamItem, ModItems.btmMoon, ModItems.m1Jordan, ModItems.teamRapture);
        }
        registry.handleRecipes(LavaInfuserRecipe.class, LavaInfuserRecipeWrapper::new, JEI_CATEGORY_LAVA_INFUSER);
        this.handleRecipes(registry, JEI_CATEGORY_WORKBENCH);
        this.handleRecipes(registry, JEI_CATEGORY_HIGH_TECH_BENCH);
        this.handleRecipes(registry, JEI_CATEGORY_ULTI_TECH_BENCH);
        this.handleRecipes(registry, JEI_CATEGORY_CHAMPION_BENCH);
        registry.addRecipeClickArea(GuiWorkbench.class, 61, 33, 22, 15, new String[]{JEI_CATEGORY_WORKBENCH});
        registry.addRecipeClickArea(GuiHighTechBench.class, 100, 33, 22, 15, new String[]{JEI_CATEGORY_HIGH_TECH_BENCH});
        registry.addRecipeClickArea(GuiUltiTechBench.class, 136, 70, 22, 15, new String[]{JEI_CATEGORY_ULTI_TECH_BENCH});
        registry.addRecipeClickArea(GuiChampionBench.class, 184, 24, 21, 23, new String[]{JEI_CATEGORY_CHAMPION_BENCH});
        registry.addRecipeClickArea(GuiLavaInfuser.class, 105, 35, 22, 16, new String[]{JEI_CATEGORY_LAVA_INFUSER});
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerWorkbench.class, JEI_CATEGORY_WORKBENCH, 1, 9, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerHighTechBench.class, JEI_CATEGORY_HIGH_TECH_BENCH, 1, 25, 26, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerUltiTechBench.class, JEI_CATEGORY_ULTI_TECH_BENCH, 1, 49, 50, 36);
        recipeTransferRegistry.addRecipeTransferHandler(new AdvancedRecipeTransferInfo<ContainerChampionBench>(ContainerChampionBench.class, JEI_CATEGORY_CHAMPION_BENCH, 1, 81, 82, 36));
        recipeTransferRegistry.addRecipeTransferHandler(ContainerLavaInfuser.class, JEI_CATEGORY_LAVA_INFUSER, 0, 1, 3, 36);
        registry.addRecipeCatalyst((Object)ItemStackUtils.getItemStack((Object)ModBlocks.lavaInfuser), new String[]{JEI_CATEGORY_LAVA_INFUSER});
        IntStream.range(0, JEI_CATEGORIES.length).forEach(i -> registry.addRecipeCatalyst((Object)ItemStackUtils.getItemStack((Object)ModBlocks.benches[i]), new String[]{JEI_CATEGORIES[i]}));
        registry.addRecipes(BaseCraftingManager.getWBInstance().getRecipeList(), JEI_CATEGORY_WORKBENCH);
        registry.addRecipes(BaseCraftingManager.getHTBInstance().getRecipeList(), JEI_CATEGORY_HIGH_TECH_BENCH);
        registry.addRecipes(BaseCraftingManager.getUTBInstance().getRecipeList(), JEI_CATEGORY_ULTI_TECH_BENCH);
        registry.addRecipes(BaseCraftingManager.getCBInstance().getRecipeList(), JEI_CATEGORY_CHAMPION_BENCH);
        registry.addRecipes(InfuserRecipeMaker.getInfuserRecipes(), JEI_CATEGORY_LAVA_INFUSER);
    }

    private void handleRecipes(IModRegistry registry, String category) {
        registry.handleRecipes(BaseShapedRecipe.class, recipe -> new ShapedRecipeWrapper((IRecipe)recipe, recipe.input, recipe.getRecipeWidth(), recipe.getRecipeHeight()), category);
        registry.handleRecipes(BaseShapelessRecipe.class, recipe -> new ShapelessRecipeWrapper((IRecipe)recipe, recipe.input), category);
        registry.handleRecipes(BaseShapelessOreRecipe.class, recipe -> new ShapelessOreRecipeWrapper(jeiHelper, (IRecipe)recipe, recipe.getInput()), category);
        registry.handleRecipes(BaseShapedOreRecipe.class, recipe -> new ShapedOreRecipeWrapper(jeiHelper, (IRecipe)recipe, recipe.getInput(), recipe.getRecipeWidth(), recipe.getRecipeHeight()), category);
    }

    private void blackListIngredients(IIngredientBlacklist blacklist, Object ... stacks) {
        Arrays.stream(stacks).forEachOrdered(stack -> {
            ItemStack ingredient;
            if ((stack instanceof ItemStack || stack instanceof Block || stack instanceof Item) && !(ingredient = ItemStackUtils.getItemStack((Object)stack)).func_190926_b()) {
                blacklist.addIngredientToBlacklist((Object)ingredient);
            }
        });
    }

    private void registerDescriptions(IModRegistry registry) {
        this.registerDescriptions(registry, this.createDesc(APItems.guardianScale, "armorplus.jei.guardian_scale.desc"), this.createDesc(APItems.witherBone, "armorplus.jei.wither_bone.desc"), this.createDesc(APItems.enderDragonScale, "armorplus.jei.ender_dragon_scale.desc"), this.createDesc(ItemStackUtils.getItemStack((Object)ModBlocks.lavaInfuser), "armorplus.jei.lava_infuser.desc"));
        for (ItemFragment fragment : ModItems.fragments) {
            this.registerDescriptions(registry, this.createDesc(ItemStackUtils.getItemStack((Object)fragment), "armorplus.jei.fragment.desc", " " + fragment.getHolderEntry().getName()));
        }
    }

    private void registerDescriptions(IModRegistry registry, EntryDescription entry) {
        registry.addIngredientInfo((Object)entry.getStack(), VanillaTypes.ITEM, new String[]{TextUtils.translatedText(entry.getDesc(), entry.getArgs())});
    }

    private void registerDescriptions(IModRegistry registry, EntryDescription ... entries) {
        Arrays.stream(entries).forEachOrdered(entry -> this.registerDescriptions(registry, (EntryDescription)entry));
    }

    private EntryDescription createDesc(ItemStack stack, String desc) {
        return new EntryDescription(stack, desc);
    }

    private EntryDescription createDesc(ItemStack stack, String desc, String args) {
        return new EntryDescription(stack, desc, args);
    }

    private static class EntryDescription {
        private final ItemStack stack;
        private final String desc;
        private final String args;

        public EntryDescription(ItemStack stack, String desc, String args) {
            this.stack = stack;
            this.desc = desc;
            this.args = args;
        }

        public EntryDescription(ItemStack stack, String desc) {
            this.stack = stack;
            this.desc = desc;
            this.args = "";
        }

        public String getDesc() {
            return this.desc;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String getArgs() {
            return this.args;
        }
    }
}

