/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.compat.jei.base;

import com.sofodev.armorplus.common.compat.jei.ArmorPlusPlugin;
import com.sofodev.armorplus.common.compat.jei.JEIUtils;
import com.sofodev.armorplus.common.compat.jei.misc.OutputSlot;
import com.sofodev.armorplus.common.compat.jei.misc.UVData;
import com.sofodev.armorplus.common.util.Utils;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;

public class CategoryBase
implements IRecipeCategory {
    private static final int OUTPUT_SLOT = 0;
    private static final int INPUT_SLOT = 1;
    private final IDrawable background;
    private final String localizedName;
    private final ICraftingGridHelper craftingGridHelper;
    private final int xPos;
    private final int yPos;
    private final int xy;
    private final String category;

    public CategoryBase(String name, UVData uvData, OutputSlot oSlot, int xy, String category) {
        this(name, uvData.getU(), uvData.getV(), uvData.getWidthU(), uvData.getHeightV(), oSlot.getX(), oSlot.getY(), xy, category);
    }

    public CategoryBase(String name, int u, int v, int widthU, int heightV, int outputXPos, int outputYPos, int xy, String category) {
        this.xPos = outputXPos;
        this.yPos = outputYPos;
        this.xy = xy;
        this.category = category;
        ResourceLocation location = Utils.setRL(String.format("textures/gui/container/jei/%s_jei.png", name));
        this.background = ArmorPlusPlugin.jeiHelper.getGuiHelper().createDrawable(location, u, v, widthU, heightV);
        this.localizedName = new TextComponentTranslation("gui.jei.category." + name, new Object[0]).func_150254_d();
        this.craftingGridHelper = ArmorPlusPlugin.jeiHelper.getGuiHelper().createCraftingGridHelper(1, 0);
    }

    @Nonnull
    public String getUid() {
        return this.category;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "ArmorPlus";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        JEIUtils.setRecipe(recipeLayout, recipeWrapper, ingredients, this.craftingGridHelper, new JEIUtils.XYProperties(this.xPos, this.yPos, this.xy), 1, 0);
    }
}

