/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.compat.projecte;

import com.google.common.collect.ImmutableMap;
import com.sofodev.armorplus.common.compat.CompatibilityProjectE;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.ModBlocks;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.registry.constants.APBlocks;
import com.sofodev.armorplus.common.registry.constants.APItems;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public class ProjectEEMCIntegration {
    public static void registerEasyEMC() {
        ItemStack guardianScale = ItemStackUtils.getItemStack((Object)ModItems.materials, (int)1);
        ItemStack witherBone = ItemStackUtils.getItemStack((Object)ModItems.materials, (int)2);
        ItemStack enderDragonScale = ItemStackUtils.getItemStack((Object)ModItems.materials, (int)3);
        if (ModConfig.getRD() == ModConfig.RecipesDifficulty.EASY) {
            ProjectEEMCIntegration.registerEasyArmorEMC(guardianScale, APItems.guardianHelmet, APItems.guardianChestplate, APItems.guardianLeggings, APItems.guardianBoots);
            ProjectEEMCIntegration.registerEasyArmorEMC(witherBone, APItems.superStarHelmet, APItems.superStarChestplate, APItems.superStarLeggings, APItems.superStarBoots);
            ProjectEEMCIntegration.registerEasyArmorEMC(enderDragonScale, APItems.enderDragonHelmet, APItems.enderDragonChestplate, APItems.enderDragonLeggings, APItems.enderDragonBoots);
            ProjectEEMCIntegration.registerEasyMeleeEMC(guardianScale, APItems.guardianSword, APItems.guardianBattleAxe);
            ProjectEEMCIntegration.registerEasyMeleeEMC(witherBone, APItems.superStarSword, APItems.superStarBattleAxe);
            ProjectEEMCIntegration.registerEasyMeleeEMC(enderDragonScale, APItems.enderDragonSword, APItems.enderDragonBattleAxe);
            ProjectEEMCIntegration.registerEasyRangedEMC(guardianScale, Items.field_179562_cC, APItems.guardianBow);
            ProjectEEMCIntegration.registerEasyRangedEMC(witherBone, Items.field_151007_F, APItems.superStarBow);
            ProjectEEMCIntegration.registerEasyRangedEMC(enderDragonScale, Items.field_151007_F, APItems.enderDragonBow);
        }
    }

    private static void registerEasyMeleeEMC(ItemStack material, Item sword, Item battleAxe) {
        CompatibilityProjectE.addConversion(sword, (Map<Object, Integer>)ImmutableMap.of((Object)material, (Object)7, (Object)Items.field_151055_y, (Object)6));
        CompatibilityProjectE.addConversion(battleAxe, (Map<Object, Integer>)ImmutableMap.of((Object)material, (Object)12, (Object)Items.field_151055_y, (Object)6));
    }

    private static void registerEasyRangedEMC(ItemStack materialA, Item materialB, Item bow) {
        CompatibilityProjectE.addConversion(bow, (Map<Object, Integer>)ImmutableMap.of((Object)materialA, (Object)11, (Object)ItemStackUtils.getItemStack((Object)materialB), (Object)7));
    }

    private static void registerEasyArmorEMC(ItemStack material, Item head, Item chest, Item legs, Item feet) {
        ProjectEEMCIntegration.createArmorEMC(material, head, 11, chest, 34, legs, 24, feet, 6);
    }

    public static void registerExpertEMC() {
        ItemStack guardianScale = ItemStackUtils.getItemStack((Object)ModItems.materials, (int)1);
        ItemStack witherBone = ItemStackUtils.getItemStack((Object)ModItems.materials, (int)2);
        ItemStack enderDragonScale = ItemStackUtils.getItemStack((Object)ModItems.materials, (int)3);
        ItemStack theUltimateMaterial = ItemStackUtils.getItemStack((Object)ModItems.materials, (int)4);
        ItemStack infusedLavaCrystal = ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1);
        CompatibilityProjectE.addConversion(ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedObsidian), (Map<Object, Integer>)ImmutableMap.of((Object)Blocks.field_150343_Z, (Object)9));
        CompatibilityProjectE.addConversion(APBlocks.highTechBench, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)infusedLavaCrystal), (Object)3, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_150451_bX), (Object)5, (Object)ItemStackUtils.getItemStack((Object)ModBlocks.benches[0]), (Object)1));
        CompatibilityProjectE.addConversion(APBlocks.ultiTechBench, (Map<Object, Integer>)ImmutableMap.of((Object)infusedLavaCrystal, (Object)2, (Object)theUltimateMaterial, (Object)6, (Object)ItemStackUtils.getItemStack((Object)ModBlocks.benches[0]), (Object)1, (Object)ItemStackUtils.getItemStack((Object)ModBlocks.benches[1]), (Object)1, (Object)ModBlocks.blockCompressedObsidian, (Object)8));
        if (ModConfig.getRD() == ModConfig.RecipesDifficulty.EXPERT || ModConfig.getRD() == ModConfig.RecipesDifficulty.HELLISH) {
            ProjectEEMCIntegration.createWorkbenchArmorEMC(Blocks.field_150402_ci, APItems.coalHelmet, APItems.coalChestplate, APItems.coalLeggings, APItems.coalBoots);
            ProjectEEMCIntegration.createWorkbenchArmorEMC(Blocks.field_150368_y, APItems.lapisHelmet, APItems.lapisChestplate, APItems.lapisLeggings, APItems.lapisBoots);
            ProjectEEMCIntegration.createWorkbenchArmorEMC(Blocks.field_150451_bX, APItems.redstoneHelmet, APItems.redstoneChestplate, APItems.redstoneLeggings, APItems.redstoneBoots);
            ProjectEEMCIntegration.createWorkbenchArmorEMC(Blocks.field_180399_cE, APItems.slimeHelmet, APItems.slimeChestplate, APItems.slimeLeggings, APItems.slimeBoots);
            ProjectEEMCIntegration.createHighTechArmorEMC(Blocks.field_150475_bE, Items.field_151166_bC, APItems.emeraldHelmet, APItems.emeraldChestplate, APItems.emeraldLeggings, APItems.emeraldBoots);
            ProjectEEMCIntegration.createHighTechArmorEMC(ModBlocks.blockCompressedObsidian, Blocks.field_150343_Z, APItems.obsidianHelmet, APItems.obsidianChestplate, APItems.obsidianLeggings, APItems.obsidianBoots);
            ProjectEEMCIntegration.createHighTechArmorEMC(ModBlocks.blockInfusedLavaCrystal, infusedLavaCrystal, APItems.lavaHelmet, APItems.lavaChestplate, APItems.lavaLeggings, APItems.lavaBoots);
            CompatibilityProjectE.addConversion(APItems.chickenHelmet, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)Items.field_151008_G), (Object)3, (Object)ItemStackUtils.getItemStack((Object)Items.field_151110_aK), (Object)2));
            CompatibilityProjectE.addConversion(APItems.chickenChestplate, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)Items.field_151008_G), (Object)5, (Object)ItemStackUtils.getItemStack((Object)Items.field_151110_aK), (Object)3));
            CompatibilityProjectE.addConversion(APItems.chickenLeggings, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)Items.field_151008_G), (Object)5, (Object)ItemStackUtils.getItemStack((Object)Items.field_151110_aK), (Object)2));
            CompatibilityProjectE.addConversion(APItems.chickenBoots, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)Items.field_151008_G), (Object)2, (Object)ItemStackUtils.getItemStack((Object)Items.field_151110_aK), (Object)2));
            ProjectEEMCIntegration.createOriginWeaponsEMC(Blocks.field_150402_ci, APItems.coalSword, APItems.coalBattleAxe, APItems.coalBow);
            ProjectEEMCIntegration.createOriginWeaponsEMC(Blocks.field_150368_y, APItems.lapisSword, APItems.lapisBattleAxe, APItems.lapisBow);
            ProjectEEMCIntegration.createOriginWeaponsEMC(Blocks.field_150451_bX, APItems.redstoneSword, APItems.redstoneBattleAxe, APItems.redstoneBow);
            ProjectEEMCIntegration.createHighTechWeaponsEMC(Blocks.field_150475_bE, APItems.emeraldSword, APItems.emeraldBattleAxe, APItems.emeraldBow);
            ProjectEEMCIntegration.createHighTechWeaponsEMC(ModBlocks.blockCompressedObsidian, APItems.obsidianSword, APItems.obsidianBattleAxe, APItems.obsidianBow);
            ProjectEEMCIntegration.createHighTechWeaponsEMC(infusedLavaCrystal, APItems.lavaSword, APItems.lavaBattleAxe, APItems.lavaBow);
            ProjectEEMCIntegration.registerGuardianEMC(guardianScale);
            ProjectEEMCIntegration.registerSuperStarEMC(witherBone);
            ProjectEEMCIntegration.registerEnderDragonEMC(enderDragonScale);
            ProjectEEMCIntegration.registerUltimateEMC();
        }
    }

    private static void createHighTechWeaponsEMC(Object material, Item sword, Item battleAxe, Item bow) {
        CompatibilityProjectE.addConversion(sword, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)material), (Object)4, (Object)ItemStackUtils.getItemStack((Object)Items.field_151055_y), (Object)1));
        CompatibilityProjectE.addConversion(battleAxe, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)material), (Object)8, (Object)ItemStackUtils.getItemStack((Object)Items.field_151055_y), (Object)4));
        CompatibilityProjectE.addConversion(bow, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)material), (Object)7, (Object)ItemStackUtils.getItemStack((Object)Items.field_151007_F), (Object)5));
    }

    private static void createHighTechArmorEMC(Object materialA, Object materialB, Item head, Item chest, Item legs, Item feet) {
        CompatibilityProjectE.addConversion(head, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)materialA), (Object)4, (Object)ItemStackUtils.getItemStack((Object)materialB), (Object)5));
        CompatibilityProjectE.addConversion(chest, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)materialA), (Object)13, (Object)ItemStackUtils.getItemStack((Object)materialB), (Object)7));
        CompatibilityProjectE.addConversion(legs, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)materialA), (Object)7, (Object)ItemStackUtils.getItemStack((Object)materialB), (Object)9));
        CompatibilityProjectE.addConversion(feet, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)materialA), (Object)4, (Object)ItemStackUtils.getItemStack((Object)materialB), (Object)2));
    }

    private static void createOriginWeaponsEMC(Object material, Item sword, Item battleAxe, Item bow) {
        CompatibilityProjectE.addConversion(sword, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)material), (Object)2, (Object)ItemStackUtils.getItemStack((Object)Items.field_151055_y), (Object)1));
        CompatibilityProjectE.addConversion(battleAxe, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)material), (Object)4, (Object)ItemStackUtils.getItemStack((Object)Items.field_151055_y), (Object)2));
        CompatibilityProjectE.addConversion(bow, (Map<Object, Integer>)ImmutableMap.of((Object)ItemStackUtils.getItemStack((Object)material), (Object)3, (Object)ItemStackUtils.getItemStack((Object)Items.field_151007_F), (Object)3));
    }

    private static void createWorkbenchArmorEMC(Object material, Item head, Item chest, Item legs, Item feet) {
        ProjectEEMCIntegration.createArmorEMC(ItemStackUtils.getItemStack((Object)material), head, 5, chest, 8, legs, 7, feet, 4);
    }

    private static void createArmorEMC(ItemStack material, Item head, int headAmount, Item chest, int chestAmount, Item legs, int legsAmount, Item feet, int feetAmount) {
        CompatibilityProjectE.addConversion(head, (Map<Object, Integer>)ImmutableMap.of((Object)material, (Object)headAmount));
        CompatibilityProjectE.addConversion(chest, (Map<Object, Integer>)ImmutableMap.of((Object)material, (Object)chestAmount));
        CompatibilityProjectE.addConversion(legs, (Map<Object, Integer>)ImmutableMap.of((Object)material, (Object)legsAmount));
        CompatibilityProjectE.addConversion(feet, (Map<Object, Integer>)ImmutableMap.of((Object)material, (Object)feetAmount));
    }

    private static void registerUltimateEMC() {
        ProjectEEMCIntegration.registerUltimatePartsEMC(0, 1, 2, APItems.guardianHelmet, APItems.enderDragonHelmet, APItems.superStarHelmet);
        CompatibilityProjectE.addConversion(APItems.theUltimateHelmet, (Map<Object, Integer>)ImmutableMap.of((Object)APItems.theUltimateMaterial, (Object)26, (Object)APItems.infusedLavaCrystal, (Object)12, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)0), (Object)1, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)1), (Object)1, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)2), (Object)1));
        ProjectEEMCIntegration.registerUltimatePartsEMC(3, 4, 5, APItems.guardianChestplate, APItems.enderDragonChestplate, APItems.superStarChestplate);
        CompatibilityProjectE.addConversion(APItems.theUltimateChestplate, (Map<Object, Integer>)ImmutableMap.of((Object)APItems.theUltimateMaterial, (Object)26, (Object)APItems.infusedLavaCrystal, (Object)12, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)3), (Object)1, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)4), (Object)1, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)5), (Object)1));
        ProjectEEMCIntegration.registerUltimatePartsEMC(6, 7, 8, APItems.guardianLeggings, APItems.enderDragonLeggings, APItems.superStarLeggings);
        CompatibilityProjectE.addConversion(APItems.theUltimateLeggings, (Map<Object, Integer>)ImmutableMap.of((Object)APItems.theUltimateMaterial, (Object)26, (Object)APItems.infusedLavaCrystal, (Object)12, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)6), (Object)1, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)7), (Object)1, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)8), (Object)1));
        ProjectEEMCIntegration.registerUltimatePartsEMC(9, 10, 11, APItems.guardianBoots, APItems.enderDragonBoots, APItems.superStarBoots);
        CompatibilityProjectE.addConversion(APItems.theUltimateBoots, (Map<Object, Integer>)ImmutableMap.of((Object)APItems.theUltimateMaterial, (Object)26, (Object)APItems.infusedLavaCrystal, (Object)12, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)9), (Object)1, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)10), (Object)1, (Object)ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)11), (Object)1));
    }

    private static void registerUltimatePartsEMC(int right, int middle, int left, Item itemRight, Item itemMid, Item itemLeft) {
        CompatibilityProjectE.addConversion(ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)right), (Map<Object, Integer>)new ImmutableMap.Builder().put((Object)APItems.theUltimateMaterial, (Object)28).put((Object)APItems.infusedLavaCrystal, (Object)12).put((Object)APItems.guardianScale, (Object)2).put((Object)Blocks.field_150360_v, (Object)2).put((Object)Items.field_179562_cC, (Object)2).put((Object)Items.field_179563_cD, (Object)2).put((Object)itemRight, (Object)1).build());
        CompatibilityProjectE.addConversion(ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)middle), (Map<Object, Integer>)new ImmutableMap.Builder().put((Object)APItems.theUltimateMaterial, (Object)28).put((Object)APItems.infusedLavaCrystal, (Object)12).put((Object)APItems.enderDragonScale, (Object)2).put((Object)Items.field_185158_cP, (Object)2).put((Object)Items.field_151061_bv, (Object)2).put((Object)Items.field_151079_bi, (Object)2).put((Object)itemMid, (Object)1).build());
        CompatibilityProjectE.addConversion(ItemStackUtils.getItemStack((Object)ModItems.theUltimateParts, (int)left), (Map<Object, Integer>)new ImmutableMap.Builder().put((Object)APItems.theUltimateMaterial, (Object)28).put((Object)APItems.infusedLavaCrystal, (Object)12).put((Object)APItems.witherBone, (Object)2).put((Object)Blocks.field_150385_bj, (Object)2).put((Object)Blocks.field_150425_aM, (Object)2).put((Object)Blocks.field_150424_aL, (Object)2).put((Object)itemLeft, (Object)1).build());
    }

    private static void registerGuardianEMC(ItemStack guardianScale) {
        CompatibilityProjectE.addConversion(APItems.guardianHelmet, (Map<Object, Integer>)ImmutableMap.of((Object)guardianScale, (Object)8, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_180398_cJ), (Object)3, (Object)ItemStackUtils.getItemStack((Object)Items.field_179563_cD), (Object)3, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_180397_cI), (Object)2));
        CompatibilityProjectE.addConversion(APItems.guardianChestplate, (Map<Object, Integer>)ImmutableMap.of((Object)guardianScale, (Object)20, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_180398_cJ), (Object)4, (Object)ItemStackUtils.getItemStack((Object)Items.field_179563_cD), (Object)4, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_180397_cI), (Object)6));
        CompatibilityProjectE.addConversion(APItems.guardianLeggings, (Map<Object, Integer>)ImmutableMap.of((Object)guardianScale, (Object)15, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_180398_cJ), (Object)1, (Object)ItemStackUtils.getItemStack((Object)Items.field_179563_cD), (Object)4, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_180397_cI), (Object)4));
        CompatibilityProjectE.addConversion(APItems.guardianBoots, (Map<Object, Integer>)ImmutableMap.of((Object)guardianScale, (Object)6, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_150360_v), (Object)2));
        CompatibilityProjectE.addConversion(APItems.guardianSword, (Map<Object, Integer>)ImmutableMap.of((Object)guardianScale, (Object)7, (Object)ItemStackUtils.getItemStack((Object)Items.field_179562_cC), (Object)6));
        CompatibilityProjectE.addConversion(APItems.guardianBattleAxe, (Map<Object, Integer>)ImmutableMap.of((Object)guardianScale, (Object)12, (Object)ItemStackUtils.getItemStack((Object)Items.field_179562_cC), (Object)6));
        CompatibilityProjectE.addConversion(APItems.guardianBow, (Map<Object, Integer>)ImmutableMap.of((Object)guardianScale, (Object)11, (Object)ItemStackUtils.getItemStack((Object)Items.field_179562_cC), (Object)7));
    }

    private static void registerSuperStarEMC(ItemStack witherBone) {
        CompatibilityProjectE.addConversion(APItems.superStarHelmet, (Map<Object, Integer>)ImmutableMap.of((Object)witherBone, (Object)8, (Object)ItemStackUtils.getItemStack((Object)Items.field_151156_bN), (Object)5, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_150425_aM), (Object)2));
        CompatibilityProjectE.addConversion(APItems.superStarChestplate, (Map<Object, Integer>)ImmutableMap.of((Object)witherBone, (Object)19, (Object)ItemStackUtils.getItemStack((Object)Items.field_151156_bN), (Object)10, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_150425_aM), (Object)4, (Object)ItemStackUtils.getItemStack((Object)Items.field_151144_bL, (int)1), (Object)1));
        CompatibilityProjectE.addConversion(APItems.superStarLeggings, (Map<Object, Integer>)ImmutableMap.of((Object)witherBone, (Object)6, (Object)ItemStackUtils.getItemStack((Object)Items.field_151156_bN), (Object)7, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_150425_aM), (Object)4));
        CompatibilityProjectE.addConversion(APItems.superStarBoots, (Map<Object, Integer>)ImmutableMap.of((Object)witherBone, (Object)4, (Object)ItemStackUtils.getItemStack((Object)Items.field_151156_bN), (Object)2, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_150425_aM), (Object)2));
        CompatibilityProjectE.addConversion(APItems.superStarSword, (Map<Object, Integer>)ImmutableMap.of((Object)witherBone, (Object)6, (Object)ItemStackUtils.getItemStack((Object)Items.field_151156_bN), (Object)6, (Object)ItemStackUtils.getItemStack((Object)Items.field_151144_bL, (int)1), (Object)1));
        CompatibilityProjectE.addConversion(APItems.superStarBattleAxe, (Map<Object, Integer>)ImmutableMap.of((Object)witherBone, (Object)12, (Object)ItemStackUtils.getItemStack((Object)Items.field_151156_bN), (Object)5, (Object)ItemStackUtils.getItemStack((Object)Items.field_151144_bL, (int)1), (Object)1));
        CompatibilityProjectE.addConversion(APItems.superStarBow, (Map<Object, Integer>)ImmutableMap.of((Object)witherBone, (Object)6, (Object)ItemStackUtils.getItemStack((Object)Items.field_151156_bN), (Object)5, (Object)ItemStackUtils.getItemStack((Object)Items.field_151007_F), (Object)7));
    }

    private static void registerEnderDragonEMC(ItemStack enderDragonScale) {
        CompatibilityProjectE.addConversion(APItems.enderDragonHelmet, (Map<Object, Integer>)ImmutableMap.of((Object)enderDragonScale, (Object)11, (Object)ItemStackUtils.getItemStack((Object)Items.field_151061_bv), (Object)2, (Object)ItemStackUtils.getItemStack((Object)Items.field_185158_cP), (Object)2));
        CompatibilityProjectE.addConversion(APItems.enderDragonChestplate, (Map<Object, Integer>)ImmutableMap.of((Object)enderDragonScale, (Object)18, (Object)ItemStackUtils.getItemStack((Object)Items.field_151061_bv), (Object)6, (Object)ItemStackUtils.getItemStack((Object)Items.field_185158_cP), (Object)6, (Object)ItemStackUtils.getItemStack((Object)Blocks.field_150377_bs), (Object)4));
        CompatibilityProjectE.addConversion(APItems.enderDragonLeggings, (Map<Object, Integer>)ImmutableMap.of((Object)enderDragonScale, (Object)17, (Object)ItemStackUtils.getItemStack((Object)Items.field_151061_bv), (Object)3, (Object)ItemStackUtils.getItemStack((Object)Items.field_185158_cP), (Object)6));
        CompatibilityProjectE.addConversion(APItems.enderDragonBoots, (Map<Object, Integer>)ImmutableMap.of((Object)enderDragonScale, (Object)4, (Object)ItemStackUtils.getItemStack((Object)Items.field_151061_bv), (Object)2, (Object)ItemStackUtils.getItemStack((Object)Items.field_185158_cP), (Object)2));
        CompatibilityProjectE.addConversion(APItems.enderDragonSword, (Map<Object, Integer>)ImmutableMap.of((Object)enderDragonScale, (Object)6, (Object)ItemStackUtils.getItemStack((Object)Items.field_185157_bK), (Object)6));
        CompatibilityProjectE.addConversion(APItems.enderDragonBattleAxe, (Map<Object, Integer>)ImmutableMap.of((Object)enderDragonScale, (Object)12, (Object)ItemStackUtils.getItemStack((Object)Items.field_185157_bK), (Object)6));
        CompatibilityProjectE.addConversion(APItems.enderDragonBow, (Map<Object, Integer>)ImmutableMap.of((Object)enderDragonScale, (Object)6, (Object)ItemStackUtils.getItemStack((Object)Items.field_185157_bK), (Object)5, (Object)ItemStackUtils.getItemStack((Object)Items.field_151007_F), (Object)7));
    }
}

