/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.compat.tinkers;

import com.sofodev.armorplus.common.compat.tinkers.TiCMaterials;
import com.sofodev.armorplus.common.compat.tinkers.modifiers.TiCModifiers;
import com.sofodev.armorplus.common.config.ModConfig;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.tools.AbstractToolPulse;
import slimeknights.tconstruct.tools.TinkerMaterials;

public class TiC
extends AbstractToolPulse {
    private static final TiC INSTANCE = new TiC();
    public static final TiCMaterials tinkersMaterials = new TiCMaterials();
    public static final TiCModifiers tiCModifiers = new TiCModifiers();
    public static final MaterialIntegration lavacrystalInt = new MaterialIntegration(TiCMaterials.INFUSED_LAVA_CRYSTAL);
    public static final MaterialIntegration steelInt = new MaterialIntegration(TinkerMaterials.steel, (Fluid)TinkerFluids.steel);
    public static final MaterialIntegration obsidianInt = new MaterialIntegration(TiCMaterials.COMPRESSED_OBSIDIAN);
    public static final MaterialIntegration infusedObsidianInt = new MaterialIntegration(TiCMaterials.LAVA_INFUSED_OBSIDIAN);
    public static final MaterialIntegration guardianInt = new MaterialIntegration(TiCMaterials.GUARDIAN);
    public static final MaterialIntegration superStarInt = new MaterialIntegration(TiCMaterials.SUPER_STAR);
    public static final MaterialIntegration enderDragonInt = new MaterialIntegration(TiCMaterials.ENDER_DRAGON);

    public static TiC instance() {
        return INSTANCE;
    }

    public static void initRepresentativeItem(MaterialIntegration material, String oreDictItem) {
        material.setRepresentativeItem(oreDictItem);
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.initMaterials(lavacrystalInt);
        this.initMaterials(infusedObsidianInt);
        this.initMaterials(obsidianInt);
        if (TinkerRegistry.getMaterial((String)"steel") == null) {
            this.initMaterials(steelInt);
        }
        tinkersMaterials.setupMaterialStats(event);
        if (ModConfig.IntegrationsConfig.tConstruct.enableGuardianScaleMaterial) {
            this.initMaterials(guardianInt);
        }
        if (ModConfig.IntegrationsConfig.tConstruct.enableWitherBoneMaterial) {
            this.initMaterials(superStarInt);
        }
        if (ModConfig.IntegrationsConfig.tConstruct.enableEnderDragonMaterial) {
            this.initMaterials(enderDragonInt);
        }
    }

    public void init(FMLInitializationEvent event) {
        tiCModifiers.init(event);
        tinkersMaterials.setupMaterials(event);
    }

    public void postInit(FMLPostInitializationEvent event) {
        TiC.initRepresentativeItem(lavacrystalInt, "blockInfusedLavaCrystal");
        TiC.initRepresentativeItem(obsidianInt, "blockCompressedObsidian");
        TiC.initRepresentativeItem(infusedObsidianInt, "blockLavaInfusedObsidian");
        if (ModConfig.IntegrationsConfig.tConstruct.enableGuardianScaleMaterial) {
            TiC.initRepresentativeItem(guardianInt, "guardianScale");
        }
        if (ModConfig.IntegrationsConfig.tConstruct.enableWitherBoneMaterial) {
            TiC.initRepresentativeItem(superStarInt, "witherBone");
        }
        if (ModConfig.IntegrationsConfig.tConstruct.enableEnderDragonMaterial) {
            TiC.initRepresentativeItem(enderDragonInt, "enderDragonScale");
        }
        tinkersMaterials.postInit(event);
    }

    public void initMaterials(MaterialIntegration material) {
        TinkerRegistry.addMaterial((Material)material.material);
        TinkerRegistry.integrate((MaterialIntegration)material);
    }
}

