/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.config;

import com.sofodev.armorplus.api.properties.AbilityProvider;
import com.sofodev.armorplus.api.properties.Armor;
import com.sofodev.armorplus.api.properties.CombinedArmor;
import com.sofodev.armorplus.api.properties.CombinedTool;
import com.sofodev.armorplus.api.properties.CombinedWeapon;
import com.sofodev.armorplus.api.properties.Tool;
import com.sofodev.armorplus.api.properties.ToolSet;
import com.sofodev.armorplus.api.properties.Weapon;
import com.sofodev.armorplus.api.properties.WeaponSet;
import com.sofodev.armorplus.common.config.Abilities;
import com.sofodev.armorplus.common.registry.blocks.HarvestProps;
import com.sofodev.armorplus.common.registry.blocks.base.ToolType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="armorplus")
public class ModConfig {
    public static void sync() {
        ConfigManager.sync((String)"armorplus", (Config.Type)Config.Type.INSTANCE);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("armorplus")) {
            ModConfig.sync();
        }
    }

    public static RecipesDifficulty getRD() {
        switch (MainConfig.global.gameMode) {
            case -1: {
                return RecipesDifficulty.DISABLED;
            }
            case 0: {
                return RecipesDifficulty.EASY;
            }
            case 1: {
                return RecipesDifficulty.EXPERT;
            }
            case 2: {
                return RecipesDifficulty.HELLISH;
            }
        }
        return RecipesDifficulty.EXPERT;
    }

    public static enum RecipesDifficulty {
        DISABLED(false){

            @Override
            public boolean isItemRepairable(ItemStack repair, ItemStack expert) {
                return false;
            }
        }
        ,
        EASY(true){

            @Override
            public boolean isItemRepairable(ItemStack repair, ItemStack expert) {
                return ItemStack.func_179545_c((ItemStack)repair, (ItemStack)expert);
            }
        }
        ,
        EXPERT(true){

            @Override
            public boolean isItemRepairable(ItemStack repair, ItemStack expert) {
                return ItemStack.func_179545_c((ItemStack)repair, (ItemStack)expert);
            }
        }
        ,
        HELLISH(true){

            @Override
            public boolean isItemRepairable(ItemStack repair, ItemStack expert) {
                return false;
            }
        };

        private final boolean hasRecipes;

        private RecipesDifficulty(boolean hasRecipes) {
            this.hasRecipes = hasRecipes;
        }

        public boolean hasRecipes() {
            return this.hasRecipes;
        }

        public abstract boolean isItemRepairable(ItemStack var1, ItemStack var2);
    }

    @Config(modid="armorplus", name="armorplus/registry", category="")
    public static class RegistryConfig {
        public static Blocks blocks = new Blocks();
        @Config.Comment(value={"Configurations for the Coal MaterialType"})
        public static OriginMaterial coal = new OriginMaterial(new CombinedArmor("gray", "night_vision", false, new Armor(1, 1, 2, 1)), new CombinedWeapon("gray", "blindness", new WeaponSet(0.5, -2.0, 24)), new CombinedTool("gray", new ToolSet(2.0, 24)));
        @Config.Comment(value={"Configurations for the Lapis MaterialType"})
        public static OriginMaterial lapis = new OriginMaterial(new CombinedArmor("blue", "water_breathing", false, new Armor(1, 2, 3, 2)), new CombinedWeapon("blue", "nausea", 1, new WeaponSet(1.0, -1.5, 200)), new CombinedTool("blue", new ToolSet(6.0, 200)));
        @Config.Comment(value={"Configurations for the Redstone MaterialType"})
        public static OriginMaterial redstone = new OriginMaterial(new CombinedArmor("dark_red", "haste", 1, new Armor(1, 2, 3, 2)), new CombinedWeapon("dark_red", "mining_fatigue", 1, new WeaponSet(1.0, -1.5, 200)), new CombinedTool("dark_red", new ToolSet(6.0, 200)));
        @Config.Comment(value={"Configurations for the Emerald MaterialType"})
        public static OriginMaterial emerald = new OriginMaterial(new CombinedArmor("dark_green", "speed", 1, new Armor(1.0, 3, 6, 8, 3)), new CombinedWeapon("dark_green", "slowness", 1, new WeaponSet(1.5, -0.5, 1561)), new CombinedTool("dark_green", new ToolSet(8.0, 1561)));
        @Config.Comment(value={"Configurations for the Obsidian MaterialType"})
        public static OriginMaterial obsidian = new OriginMaterial(new CombinedArmor("dark_gray", "resistance", false, new Armor(1.0, 3, 6, 7, 3)), new CombinedWeapon("dark_gray", "weakness", 1, new WeaponSet(4.0, 0.0, 1500)), new CombinedTool("dark_gray", new ToolSet(4.0, 5000)));
        @Config.Comment(value={"Configurations for the Lava MaterialType"})
        public static OriginMaterial lava = new OriginMaterial(new CombinedArmor("gold", "fire_resistance", false, new Armor(1.0, 3, 6, 8, 3)), true, new CombinedWeapon("gold", new WeaponSet(4.5, 0.5, 1750)), true, 8, new CombinedTool("gold", new ToolSet(12.0, 1750)));
        @Config.Comment(value={"Configurations for the Guardian MaterialType"})
        public static OriginMaterial guardian = new OriginMaterial(new CombinedArmor("blue", "water_breathing", false, new Armor(2.0, 4, 7, 8, 3)), new CombinedWeapon("blue", "nausea", 1, new WeaponSet(6.0, 1.5, 1800)), new CombinedTool("blue", new ToolSet(15.0, 1800)));
        @Config.Comment(value={"Configurations for the Super Star MaterialType"})
        public static OriginMaterial super_star = new OriginMaterial(new CombinedArmor("white", "wither", "regeneration", 1, new Armor(2.0, 4, 7, 8, 3)), new CombinedWeapon("white", "wither", 1, new WeaponSet(7.0, 1.5, 1950)), new CombinedTool("white", new ToolSet(15.0, 1950)));
        @Config.Comment(value={"Configurations for the Ender Dragon MaterialType"})
        public static OriginMaterial ender_dragon = new OriginMaterial(new CombinedArmor("dark_purple", "wither", true, new Armor(2.0, 4, 7, 8, 3)), new CombinedWeapon("dark_purple", "wither", 3, new WeaponSet(8.0, 1.5, 2310)), new CombinedTool("dark_purple", new ToolSet(25.0, 2310)));
        @Config.Comment(value={"Configurations for the Ultimate MaterialType"})
        public static UltimateMaterial ultimate = new UltimateMaterial();
        @Config.Comment(value={"Configurations for the Chicken MaterialType"})
        public static ArmorProperties chicken = new ArmorProperties(new CombinedArmor("aqua", "speed", 4, new Armor(1, 1, 2, 1)), false);
        @Config.Comment(value={"Configurations for the Slime MaterialType"})
        public static ArmorProperties slime = new ArmorProperties(new CombinedArmor("green", "jump_boost", 2, new Armor(1, 1, 2, 1)), false);
        @Config.Comment(value={"Configurations for the Ardite MaterialType"})
        public static ArmorProperties ardite = new ArmorProperties(new CombinedArmor("dark_red", "fire_resistance", false, new Armor(1.0, 2, 3, 4, 2)), false);
        @Config.Comment(value={"Configurations for the Cobalt MaterialType"})
        public static ArmorProperties cobalt = new ArmorProperties(new CombinedArmor("blue", "haste", 2, new Armor(1.0, 2, 3, 4, 2)), false);
        @Config.Comment(value={"Configurations for the Manyullyn MaterialType"})
        public static ArmorProperties manyullyn = new ArmorProperties(new CombinedArmor("dark_purple", "strength", 1, new Armor(2.0, 3, 5, 5, 3)), false);
        @Config.Comment(value={"Configurations for the Pig Iron MaterialType"})
        public static ArmorProperties pig_iron = new ArmorProperties(new CombinedArmor("light_purple", "saturation", false, new Armor(1.0, 2, 3, 4, 3)), false);
        @Config.Comment(value={"Configurations for the Knight Slime MaterialType"})
        public static ArmorProperties knight_slime = new ArmorProperties(new CombinedArmor("dark_purple", "jump_boost", 1, new Armor(1.0, 2, 3, 4, 3)), false);
        public static RegistryRecipes recipes = new RegistryRecipes();
        @Config.Comment(value={"Configurations for the Enhanced Chainmail MaterialType"})
        public static EnhancedMaterial chain = new EnhancedMaterial(new Armor(1.0, 2, 5, 6, 3));
        @Config.Comment(value={"Configurations for the Enhanced Iron MaterialType"})
        public static EnhancedMaterial iron = new EnhancedMaterial(new Armor(1.0, 3, 6, 8, 3));
        @Config.Comment(value={"Configurations for the Enhanced Gold MaterialType"})
        public static EnhancedMaterial gold = new EnhancedMaterial(new Armor(1.0, 2, 4, 6, 3));
        @Config.Comment(value={"Configurations for the Enhanced Diamond MaterialType"})
        public static EnhancedMaterial diamond = new EnhancedMaterial(new Armor(3.0, 4, 7, 9, 4));
        public static Enchantments enchantments = new Enchantments();

        public static class RegistryRecipes {
            @Config.Comment(value={"Enable/Disable The Steel Ingot Recipes"})
            public boolean enableSteelIngotRecipes = true;
            @Config.Comment(value={"Enable/Disable The Electrical Ingot Recipes"})
            public boolean enableElectricalIngotRecipes = true;
            @Config.Comment(value={"Enable/Disable The Redstone Apple Recipes"})
            public boolean enableRedstoneAppleRecipes = true;
            @Config.Comment(value={"Enable/Disable The Elytra Recipe"})
            public boolean enableElytraRecipe = false;
            @Config.Comment(value={"Enable/Disable the armorplus arrow recipes"})
            public boolean enableArrowRecipes = true;
            @Config.Comment(value={"Enable/Disable The Coal armor Recipes"})
            public boolean enableCoalArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Charcoal Coal armor Recipes"})
            public boolean enableCharcoalCoalArmorRecipe = false;
            @Config.Comment(value={"Enable/Disable The Lapis armor Recipes"})
            public boolean enableLapisArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Redstone armor Recipes"})
            public boolean enableRedstoneArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Emerald armor Recipes"})
            public boolean enableEmeraldArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Obsidian armor Recipes"})
            public boolean enableObsidianArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable the armor Recipes"})
            public boolean enableLavaArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Super Star armor Recipes"})
            public boolean enableSuperStarArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Ender Dragon armor Recipes"})
            public boolean enableEnderDragonArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Guardian armor Recipes"})
            public boolean enableGuardianArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Ultimate armor Recipes"})
            public boolean enableTheUltimateArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Chain armor Recipes"})
            public boolean enableChainArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Ardite armor Recipes"})
            public boolean enableArditeArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Cobalt armor Recipes"})
            public boolean enableCobaltArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Manyullyn armor Recipes"})
            public boolean enableManyullynArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Pig Iron armor Recipes"})
            public boolean enablePigIronArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Knight Slime armor Recipes"})
            public boolean enableKnightSlimeArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Slime armor Recipes"})
            public boolean enableSlimeArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable The Chicken armor Recipes"})
            public boolean enableChickenArmorRecipes = true;
            @Config.Comment(value={"Enable/Disable ArmorPlus Sword's Recipes"})
            public boolean enableSwordsRecipes = true;
            @Config.Comment(value={"Enable/Disable ArmorPlus Battle Axes's Recipes"})
            public boolean enableBattleAxesRecipes = true;
            @Config.Comment(value={"Enable/Disable ArmorPlus Bows's Recipes"})
            public boolean enableBowsRecipes = true;
            @Config.Comment(value={"Enable/Disable ArmorPlus Pickaxe's Recipes"})
            public boolean enablePickaxesRecipes = true;
        }

        public static class UltimateMaterial {
            public Armor armor = new Armor();

            public class Armor {
                @Config.Comment(value={"The potion effect(s) that the armor will be removing (to disable the effect set the effects 'empty')"})
                public String[] removePotionEffects = new String[]{"wither"};
                @Config.Comment(value={"Adds the potion effects the armor will have (to disable the effect set the effects 'false')"})
                public String[] addPotionEffects = new String[]{"regeneration", "water_breathing"};
                @Config.Comment(value={"Set the amplifier level for the effect(s) by the armor. (0 = level 1, 1 = level 2 etc.)"})
                public int[] effectLevels = new int[]{1, 0};
                @Config.Comment(value={"Set the duration for the effect(s) by the armor. (in seconds)"})
                public int[] effectDurations = new int[]{12, 12};
                @Config.Comment(value={"Set the color name the armor will have"})
                public String itemNameColor = "dark_purple";
                @Config.Comment(value={"Set the amount of toughness points the armor will have"})
                public double toughnessPoints = 3.0;
                @Config.Comment(value={"Set the amount of protection points the armor will have (boots, leggings, chestplate, helmet)"})
                public int[] protectionPoints = new int[]{4, 8, 9, 4};
                @Config.Comment(value={"Sets the armor unbreakable"})
                public boolean setUnbreakable = false;
                @Config.Comment(value={"Enable/Disable the armor's invincibility"})
                public boolean setInvincible = false;
                @Config.Comment(value={"Enable/Disable the armor's de-buffs (when a non complete set is equiped)"})
                public boolean enableDeBuffs = true;
            }
        }

        public static class EnhancedMaterial {
            @Config.Comment(value={"Set the amount of toughness points the armor will have"})
            public double toughnessPoints;
            @Config.Comment(value={"Set the amount of protection points the armor will have (boots, leggings, chestplate, helmet)"})
            public int[] protectionPoints;

            public EnhancedMaterial(Armor armor) {
                this.toughnessPoints = armor.getToughnessPoints();
                this.protectionPoints = armor.getArmorPoints();
            }
        }

        public static class Enchantments {
            @Config.Comment(value={"Enable/Disable the ability to 'enhance' vanilla armors (Chainmail, Iron, Gold, Diamond) via the 'enhanced' enchantment"})
            public boolean enableArmorEnhancement = true;
            @Config.Comment(value={"Enable/Disable the `furious` enchantment's functionality"})
            public boolean enableFurious = true;
            @Config.Comment(value={"Enable/Disable the `life steal` enchantment's functionality"})
            public boolean enableLifeSteal = true;
        }

        public static class OriginMaterial {
            public ArmorProperties armor;
            public OriginWeapons weapons;
            public OriginTools tools;

            public OriginMaterial(CombinedArmor armorProperties, CombinedWeapon weaponProperties, CombinedTool toolData) {
                this(armorProperties, false, weaponProperties, toolData);
            }

            public OriginMaterial(CombinedArmor armorProperties, boolean aeowtdb, CombinedWeapon weaponProperties, CombinedTool toolData) {
                this(armorProperties, aeowtdb, weaponProperties, false, 0, toolData);
            }

            public OriginMaterial(CombinedArmor combinedArmor, boolean aeowtdb, CombinedWeapon combinedWeapon, boolean wsaf, int wofs, CombinedTool toolData) {
                this.armor = new ArmorProperties(combinedArmor, aeowtdb);
                this.weapons = new OriginWeapons(combinedWeapon, wsaf, wofs);
                this.tools = new OriginTools(toolData);
            }

            public class OriginWeapons {
                public OriginSword sword;
                public OriginBattleAxe battle_axe;
                public OriginBow bow;
                @Config.Comment(value={"Set the color name the weapons will have"})
                public String itemNameColor;
                @Config.Comment(value={"Adds the potion effect the weapons will have (to disable the effect set the effects 'false')"})
                public Abilities abilities;
                @Config.Comment(value={"Enable/Disable the potion effect the weapons will have"})
                public boolean enableEffects;
                @Config.Comment(value={"Enable/Disable the ability for the weapons to set entities on fire"})
                public boolean shouldApplyFire;
                @Config.Comment(value={"Sets the amount of seconds the entities will be set on fire after being hit"})
                public int onFireSeconds;

                public OriginWeapons(CombinedWeapon properties) {
                    this(properties, false, 0);
                }

                public OriginWeapons(CombinedWeapon properties, boolean wsaf, int wofs) {
                    AbilityProvider abilityProperties = properties.getAbilityProvider();
                    this.itemNameColor = properties.getColor();
                    this.abilities = abilityProperties.getAbilities();
                    this.enableEffects = abilityProperties.isEnabled();
                    this.shouldApplyFire = wsaf;
                    this.onFireSeconds = wofs;
                    WeaponSet weaponProperties = properties.getWeaponSet();
                    this.sword = new OriginSword(weaponProperties.getSword());
                    this.battle_axe = new OriginBattleAxe(weaponProperties.getBattleAxe());
                    this.bow = new OriginBow(weaponProperties.getBow());
                }

                public class OriginBow {
                    @Config.Comment(value={"Set the amount of bonus arrow damage the bow will do"})
                    public double arrowBonusDamage;
                    @Config.Comment(value={"Set the amount of durability the bow have"})
                    public int durability;

                    OriginBow(Weapon bow) {
                        this.arrowBonusDamage = bow.getDmg();
                        this.durability = bow.getDurability(false);
                    }
                }

                public class OriginBattleAxe {
                    @Config.Comment(value={"Set the amount of damage the battle axe will do (Additional +4 damage will be added automatically by minecraft)"})
                    public double damage;
                    @Config.Comment(value={"Set the amount of durability the battle axe will have"})
                    public int durability;

                    OriginBattleAxe(Weapon battleAxe) {
                        this.damage = battleAxe.getDmg();
                        this.durability = battleAxe.getDurability(false);
                    }
                }

                public class OriginSword {
                    @Config.Comment(value={"Set the amount of damage the sword will do (Additional +4 damage will be added automatically by minecraft)"})
                    public double damage;
                    @Config.Comment(value={"Set the amount of durability the sword will have"})
                    public int durability;

                    OriginSword(Weapon sword) {
                        this.damage = sword.getDmg();
                        this.durability = sword.getDurability(false);
                    }
                }
            }

            public class OriginTools {
                public OriginPickaxe pickaxe;
                @Config.Comment(value={"Set the color name the tools will have"})
                public String itemNameColor;

                public OriginTools(CombinedTool properties) {
                    this.itemNameColor = properties.getColor();
                    this.pickaxe = new OriginPickaxe(properties.getToolSet().getPickaxe());
                }

                public class OriginPickaxe {
                    @Config.Comment(value={"Set the breaking speed of the pickaxe"})
                    public double efficiency;
                    @Config.Comment(value={"Set the amount of durability the pickaxe have"})
                    public int durability;

                    OriginPickaxe(Tool tool) {
                        this.efficiency = tool.getEfficiency();
                        this.durability = tool.getDurability(false);
                    }
                }
            }
        }

        public static class ArmorProperties {
            @Config.Comment(value={"Set the color name the armor will have"})
            public String itemNameColor;
            @Config.Comment(value={"The potion effect(s) that the armor will be removing (to disable the effect set the effects 'empty')"})
            public String[] removePotionEffects;
            @Config.Comment(value={"Adds the potion effect the armor will have (to disable the effect set the effects 'false')"})
            public Abilities abilities;
            @Config.Comment(value={"Enable/Disable the set effect(s)"})
            public boolean enableSetEffects;
            @Config.Comment(value={"Set the amount of toughness points the armor will have"})
            public double toughnessPoints;
            @Config.Comment(value={"Set the amount of protection points the armor will have (boots, leggings, chestplate, helmet)"})
            public int[] protectionPoints;
            @Config.Comment(value={"Enable/Disable the piece effect(s) (Boots, Leggings, Chestplate, Helmet)"})
            public boolean[] enablePieceEffects;
            @Config.Comment(value={"Sets the armor unbreakable"})
            public boolean setUnbreakable;
            @Config.Comment(value={"Enables/Disables the de-buffs that the armor will get when touching water without Water Breathing potion", "a.k.a nothing happens when player wears this armor while in water.", "CURRENTLY ONLY WORKS FOR THE INFUSED LAVA ARMOR"})
            public boolean enableOnWaterTouchDeBuff;

            public ArmorProperties(CombinedArmor properties, boolean enableOnWaterTouchDeBuff) {
                this.itemNameColor = properties.getColor();
                this.removePotionEffects = properties.getAbility().getAbilityCanceller().getAbilities();
                AbilityProvider abilityProperties = properties.getAbility().getAbilityProvider();
                this.abilities = abilityProperties.getAbilities();
                this.enableSetEffects = abilityProperties.isEnabled();
                Armor armor = properties.getArmor();
                this.toughnessPoints = armor.getToughnessPoints();
                this.protectionPoints = armor.getArmorPoints();
                this.enablePieceEffects = new boolean[4];
                this.setUnbreakable = false;
                this.enableOnWaterTouchDeBuff = enableOnWaterTouchDeBuff;
            }
        }

        public static class Blocks {
            @Config.Comment(value={"This includes all benches: [Workbench, High-Tech Bench, Ulti-Tech Bench, Champion Bench]"})
            public BlockRegistry benches = new BlockRegistry(new HarvestProps(ToolType.PICKAXE, 2));
            public BlockRegistry stone_bricks = new BlockRegistry(new HarvestProps(ToolType.PICKAXE));
            public BlockRegistry ore_lava_crystal = new BlockRegistry(new HarvestProps(ToolType.PICKAXE, 3));
            public BlockRegistry lava_cactus = new BlockRegistry(new HarvestProps(ToolType.PICKAXE));
            public BlockRegistry lava_infuser = new BlockRegistry(new HarvestProps(ToolType.PICKAXE, 1));
            @Config.Comment(value={"This includes: Block Lava Crystal, Block Infused Lava Crystal, Block Compressed Lava Crystal, Block Compressed Infused Lava Crystal & Block Lava Infused Obsidian"})
            public BlockRegistry lava_material = new BlockRegistry(new HarvestProps(ToolType.PICKAXE, 2));
            public BlockRegistry lava_nether_brick = new BlockRegistry(new HarvestProps(ToolType.PICKAXE, 1));
            public BlockRegistry block_compressed_obsidian = new BlockRegistry(new HarvestProps(ToolType.PICKAXE, 3));
            public BlockRegistry block_trophy = new BlockRegistry(new HarvestProps(ToolType.PICKAXE, 1));
            public BlockRegistry block_metal = new BlockRegistry(new HarvestProps(ToolType.PICKAXE, 1));

            public class BlockRegistry {
                @Config.Ignore
                public HarvestProps props;
                @Config.Comment(value={"The tool type required to mine this block", "Available tool types are: 'pickaxe', 'axe', 'shovel'"})
                public String toolType;
                @Config.Comment(value={"The harvest level of the tool required to mine this block", "Wood: 0, Stone: 1, Iron: 2, Diamond: 3, Gold: 0"})
                public int harvestLevel;
                @Config.Comment(value={"Sets whether the block can be mined or not (Like bedrock)"})
                public boolean isUnbreakable;

                public BlockRegistry(HarvestProps props) {
                    this.props = props;
                    this.toolType = props.getType().getTool();
                    this.harvestLevel = props.getHarvestLevel();
                    this.isUnbreakable = props.isUnbreakable();
                }
            }
        }
    }

    @Config(modid="armorplus", name="armorplus/misc", category="misc")
    public static class Misc {
        @Config.Comment(value={"Enable/Disable the armor Flight"})
        public static boolean enableFlightAbility = true;
    }

    @Config(modid="armorplus", name="armorplus/worldgen", category="")
    public static class WorldGenConfig {
        public static OreLavaCrystal lava_crystal = new OreLavaCrystal();
        public static Tower tower = new Tower();

        public static class Tower {
            @Config.Comment(value={"Set the spawn chance need of the Tower Generation in the Overworld"})
            public int chanceNeededForSpawning = 7000;
            @Config.Comment(value={"Set the spawn chance of the Tower Generation in the Overworld"})
            public int spawnChance = 1;
            @Config.Comment(value={"Enable/Disable the Tower Generation"})
            public boolean enable = true;
            @Config.Comment(value={"Enable/Disable the tower generation outside the overworld"})
            public boolean shouldOnlyGenerateInTheOverworld = true;
        }

        public static class OreLavaCrystal {
            @Config.Comment(value={"Configuration for the 'Overworld' dimension"})
            public DimensionOre overworld = new DimensionOre(true, 10, 6, 16, 4);
            @Config.Comment(value={"Configuration for the 'The Nether' dimension"})
            public DimensionOre the_nether = new DimensionOre(false, 0, 0, 0, 0);
            @Config.Comment(value={"Configuration for the 'The End' dimension"})
            public DimensionOre the_end = new DimensionOre(false, 0, 0, 0, 0);

            public static class DimensionOre {
                @Config.Comment(value={"Enable/Disable the lava crystal world generation"})
                public boolean enable;
                @Config.Comment(value={"Set the rarity level of the lava crystal world gen"})
                public int rarity;
                @Config.Comment(value={"Set the minimum y getExactRandPos level of the lava crystal world gen"})
                public int minYSpawn;
                @Config.Comment(value={"Set the maximum y getExactRandPos level of the lava crystal world gen"})
                public int maxYSpawn;
                @Config.Comment(value={"Set the vein amount of the lava crystal world gen"})
                public int veinAmount;

                public DimensionOre(boolean enable, int rarity, int minYSpawn, int maxYSpawn, int veinAmount) {
                    this.enable = enable;
                    this.rarity = rarity;
                    this.minYSpawn = minYSpawn;
                    this.maxYSpawn = maxYSpawn;
                    this.veinAmount = veinAmount;
                }
            }
        }
    }

    @Config(modid="armorplus", name="armorplus/debug", category="debug")
    public static class DebugConfig {
        @Config.Comment(value={"Enable/Disable Debug Mode"})
        public static boolean debugMode = false;
        @Config.Comment(value={"Enable/Disable Debug Mode for the Ender Dragon Zombie"})
        public static boolean debugModeEnderDragonZombie = false;
        @Config.Comment(value={"Enable/Disable Debug Mode for the Gift Of The Gods"})
        public static boolean debugModeTGOTG = false;
        @Config.Comment(value={"Enable/Disable Debug Mode for the Enchantments"})
        public static boolean debugModeEnchantments = false;
    }

    @Config(modid="armorplus", name="armorplus/integrations", category="integrations")
    public static class IntegrationsConfig {
        public static TConstruct tConstruct = new TConstruct();
        @Config.Comment(value={"Enable/Disable the Tinkers' Construct integration"})
        public static boolean enableTConstructIntegration = true;
        @Config.Comment(value={"Enable/Disable the JEI integration"})
        public static boolean enableJEIIntegration = true;
        @Config.Comment(value={"Enable/Disable the The One Probe integration"})
        public static boolean enableTOPIntegration = true;
        @Config.Comment(value={"Enable/Disable the ProjectE integration"})
        public static boolean enableProjectEIntegration = false;
        @Config.Comment(value={"Draconic Evolution: Set the chaos resistance of the [Ender Dragon, Guardian, Super Star] armor"})
        @Config.RangeDouble(min=0.8999999761581421, max=0.9900000095367432)
        public static double normalChaosResistance = 0.9f;
        @Config.Comment(value={"Draconic Evolution: enable/disable the chaos immunity of the [Ultimate] armor"})
        public static boolean ultimateChaosImmunity = true;

        public static class TConstruct {
            @Config.Comment(value={"Enable/Disable guardian scale material."})
            public boolean enableGuardianScaleMaterial = true;
            @Config.Comment(value={"Enable/Disable wither bone material."})
            public boolean enableWitherBoneMaterial = true;
            @Config.Comment(value={"Enable/Disable ender dragon scale material."})
            public boolean enableEnderDragonMaterial = true;
        }
    }

    @Config(modid="armorplus", name="armorplus/entities", category="")
    public static class EntitiesConfig {
        public static EnderDragonZombieMob ender_dragon_zombie = new EnderDragonZombieMob();
        public static SkeletalKingMob skeletal_king = new SkeletalKingMob();
        public static MobDrops mob_drops = new MobDrops();

        public static class MobDrops {
            public Trophy trophy = new Trophy();
            public EnderDragonScales ender_dragon_scale = new EnderDragonScales();
            public WitherBones wither_bone = new WitherBones();
            public GuardianScales guardian_scale = new GuardianScales();
            public SkeletalKing skeletal_king = new SkeletalKing();

            public class SkeletalKing {
                @Config.Comment(value={"Enable/Disable the drops from the Skeletal King"})
                public boolean skeletalKingDrop = true;
            }

            public class GuardianScales {
                @Config.Comment(value={"Set the amount that the Elder Guardian will drop"})
                public int dropAmount = 6;
                @Config.Comment(value={"Enable/Disable the drop from the Elder Guardian"})
                public boolean elderDrop = true;
                @Config.Comment(value={"Enable/Disable the drop from the Guardian"})
                public boolean guardianDrop = true;
            }

            public class WitherBones {
                @Config.Comment(value={"Set the amount that the Wither Boss will drop"})
                public int dropAmount = 6;
                @Config.Comment(value={"Enable/Disable the drop from the Wither Boss"})
                public boolean bossDrop = true;
                @Config.Comment(value={"Enable/Disable the drop from the Wither Skeleton"})
                public boolean witherSkeletonDrop = true;
            }

            public class EnderDragonScales {
                @Config.Comment(value={"Set the amount that the Ender Dragon will drop"})
                public int dropAmount = 12;
                @Config.Comment(value={"Enable/Disable the drop from the Ender Dragon"})
                public boolean drop = true;
            }

            public class Trophy {
                @Config.Comment(value={"Enable/Disable the trophy dropped when killing a boss (vanilla bosses)"})
                public boolean enableVanillaTrophyDrops = true;
                @Config.Comment(value={"Enable/Disable the trophy dropped when killing a boss (some of the wip armorplus bosses)"})
                public boolean enableAPBossTrophyDrops = true;
            }
        }

        public static class SkeletalKingMob {
            @Config.Comment(value={"Set the Skeletal King's Health", "Max value 1024"})
            public double bossHealth = 1024.0;
            @Config.Comment(value={"Set the Skeletal King's Armor"})
            public double armor = 8.0;
            @Config.Comment(value={"Set the Skeletal King's Movement Speed"})
            public double movementSpeed = 0.6f;
            @Config.Comment(value={"Enable/Disable the Skeletal King's resistance buff effect"})
            public boolean enableResistance = true;
            @Config.Comment(value={"Set the Skeletal King's resistance effect Level (0 = lvl 1)"})
            public int resistanceAmplifier = 0;
        }

        public static class EnderDragonZombieMob {
            @Config.Comment(value={"Enable/Disable the Ender Dragon Zombie to spawn in the End"})
            public boolean enableSpawnEnd = false;
            @Config.Comment(value={"Set the Ender Dragon Zombie's Health"})
            public double health = 40.0;
            @Config.Comment(value={"Set the Ender Dragon Zombie's Armor"})
            public double armor = 2.0;
            @Config.Comment(value={"Set the Ender Dragon Zombie's Attack Damage"})
            public double attackDamage = 3.0;
            @Config.Comment(value={"Set the Ender Dragon Zombie's Movement Speed"})
            public double movementSpeed = 0.23f;
            @Config.Comment(value={"Enable/Disable the Ender Dragon Zombie's Withering Effect"})
            public boolean enableWithering = true;
            @Config.Comment(value={"Set the Ender Dragon Zombie's Withering effect Duration"})
            public int witheringEffectDuration = 20;
            @Config.Comment(value={"Set the Ender Dragon Zombie's Withering effect Level"})
            public int witheringEffectLevel = 4;
        }
    }

    @Config(modid="armorplus", name="armorplus/config", category="")
    public static class MainConfig {
        public static final Global global = new Global();
        public static final TheGiftOfTheGods tgotg = new TheGiftOfTheGods();
        public static final InfusedLavaPickaxe lavaPickaxe = new InfusedLavaPickaxe();
        public static final CombinedMap maps = new CombinedMap();

        public static class TheGiftOfTheGods {
            @Config.Comment(value={"Enable/Disable the WhiteList"})
            public boolean enableWhiteList = false;
            @Config.Comment(value={"Add WhiteListed Items to the \"The Gift Of The Gods\"", "If You add want to add an item to the whitelist", "You will need to replace 1 from \"minecraft:dirt\" to the item you want to add"})
            public String[] whiteListedItems = new String[]{"minecraft:dirt"};
            @Config.Comment(value={"Enable/Disable the BlackList"})
            public boolean enableBlackList = false;
            @Config.Comment(value={"Add Blacklisted Items to the \"The Gift Of The Gods\"", "If You add want to add an item to the blacklist", "You will need to replace 1 from \"minecraft:dirt\" to the item you want to add"})
            public String[] blackListedItems = new String[]{"minecraft:dirt"};
            @Config.Comment(value={"Enable/Disable The Gift Of The Gods"})
            public boolean enable = true;
            @Config.Comment(value={"Set the cooldown ticks until you can use The Gift Of The Gods (1 second = 20 ticks)"})
            public int cooldownTicks = 600;
            @Config.Comment(value={"Set the max amount of uses for the item"})
            public int maxUses = 2;
        }

        public static class Global {
            @Config.Comment(value={"Will make ArmorPlus use the Crafting Table 3x3 for all the recipes instead of the tiered benches"})
            public boolean useJsonRecipes = false;
            @Config.RangeInt(min=-1, max=2)
            @Config.Comment(value={"Sets the Recipe Difficulty", "-1 Disables almost all in-game recipes from the mod (can be used with the 'useJsonRecipes' property to only enable vanilla crafting table recipes),", "0 = easy (All recipes are extremely easy),", "1 = expert (default, All Recipes Are Harder),", "2 = hellish (Repairing for A+ items is DISABLED)"})
            public int gameMode = 1;
        }

        public static class CombinedMap {
            @Config.Comment(value={"Enable/Disable the ability of the maps to spawn bosses, suck as the \"Skeletal King\" from the \"Map of Sacrifice\""})
            public boolean allowSpawnOfBosses = true;
        }

        public static class InfusedLavaPickaxe {
            @Config.Comment(value={"Add blocks to the smelting blacklist of \"Infused Lava Pickaxe\"", "If You add want to add an item to the blacklist", "Add it in the following format: \"<namespace>:<name>\"", "Examples can be found inside the list itself"})
            public String[] blacklist = new String[]{"minecraft:wet_sponge", "minecraft:sponge", "minecraft:obsidian"};
        }
    }

    @Config(modid="armorplus", name="armorplus/dimensions", category="dimensions")
    public static class DimensionConfig {
        @Config.Comment(value={"The numeral id of the armorplus:arena dimension"})
        public static int arenaDimensionID = 120;
        @Config.Comment(value={"The numeral id of the armorplus:realm_of_insanity dimension"})
        public static int realmDimensionID = 121;
        @Config.Comment(value={"Too unstable, unfinished to be enabled by default."})
        public static boolean enableTheArenaDimension = false;
        @Config.Comment(value={"Enable/Disable the realm of insanity"})
        public static boolean enableRealmOfInsanity = false;
    }

    @Config(modid="armorplus", name="armorplus/experimental", category="experimental")
    public static class Experimental {
        @Config.Comment(value={"This will enable experimental features that the mod provides, use with caution can corrupt/destroy/break your worlds"})
        public static boolean enableExperimentalMode = false;
    }
}

