/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.blocks.lava;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.iface.IModdedBlock;
import com.sofodev.armorplus.common.registry.ModBlocks;
import com.sofodev.armorplus.common.tileentity.TileLavaInfuser;
import com.sofodev.armorplus.common.util.Utils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public class BlockLavaInfuser
extends BlockContainer
implements IModdedBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static boolean keepInventory;
    private boolean isInfusing;

    public BlockLavaInfuser(String name, boolean isInfusing) {
        super(Material.field_151576_e);
        this.isInfusing = isInfusing;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setRegistryName(Utils.setRL(name));
        this.func_149663_c(Utils.setName(name));
        this.func_149752_b(10000.0f);
        this.func_149711_c(2.5f);
        this.setHarvestLevel(ModConfig.RegistryConfig.blocks.lava_infuser.toolType, ModConfig.RegistryConfig.blocks.lava_infuser.harvestLevel);
        this.func_149647_a(ArmorPlus.tabArmorPlusBlocks);
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            worldIn.func_180501_a(pos, BlockLavaInfuser.getNeededState((Block)ModBlocks.lavaInfuserInfusing, iblockstate), 3);
            worldIn.func_180501_a(pos, BlockLavaInfuser.getNeededState((Block)ModBlocks.lavaInfuserInfusing, iblockstate), 3);
        } else {
            worldIn.func_180501_a(pos, BlockLavaInfuser.getNeededState((Block)ModBlocks.lavaInfuser, iblockstate), 3);
            worldIn.func_180501_a(pos, BlockLavaInfuser.getNeededState((Block)ModBlocks.lavaInfuser, iblockstate), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public static IBlockState getNeededState(Block block, IBlockState other) {
        return block.func_176223_P().func_177226_a((IProperty)FACING, other.func_177229_b((IProperty)FACING));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemStackUtils.getItem((Object)ModBlocks.lavaInfuser);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (world != null && state != null && pos != null) {
            this.setDefaultFacing(world, pos, state);
        }
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.isInfusing) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            this.spawnParticles(worldIn, d0, d1, d2, d4, enumfacing);
        }
    }

    private void spawnParticles(World worldIn, double d0, double d1, double d2, double d4, EnumFacing facing) {
        double xSpeed;
        double d = facing == EnumFacing.WEST ? -0.5 : (facing == EnumFacing.EAST ? 0.5 : (xSpeed = facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? 0.0 : 0.0));
        double zSpeed = facing == EnumFacing.WEST || facing == EnumFacing.EAST ? 0.0 : (facing == EnumFacing.NORTH ? -0.5 : (facing == EnumFacing.SOUTH ? 0.5 : 0.0));
        worldIn.func_175688_a(EnumParticleTypes.LAVA, d0, d1 + 1.0, d2 + d4, xSpeed, 0.5, zSpeed, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1 + 1.0, d2 + d4, xSpeed, 0.5, zSpeed, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1 + 1.0, d2 + d4, xSpeed, 0.5, zSpeed, new int[0]);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)ArmorPlus.instance, 9, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileLavaInfuser();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileLavaInfuser) {
            ((TileLavaInfuser)tileentity).setCustomInventoryName(stack.func_82833_r());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = worldIn.func_175625_s(pos)) instanceof TileLavaInfuser) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileLavaInfuser)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return super.getPickBlock(state, target, world, pos, player);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        this.initModel(0);
    }
}

