/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.blocks.special.decorative;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.common.iface.IModdedBlock;
import com.sofodev.armorplus.common.registry.blocks.BlockProperties;
import com.sofodev.armorplus.common.registry.blocks.base.BlockBase;
import com.sofodev.armorplus.common.registry.items.base.special.Swords;
import com.sofodev.armorplus.common.tileentity.TileSwordDisplay;
import com.sofodev.armorplus.common.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSwordDisplay
extends BlockBase
implements IModdedBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final BlockProperties PROPERTIES = new BlockProperties(1000.0f, 10.0f);
    protected static final AxisAlignedBB PEDESTAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockSwordDisplay(Swords type) {
        super(Material.field_151573_f, type.getName() + "_sword_display", PROPERTIES);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(ArmorPlus.tabArmorPlusBlocks);
    }

    public BlockSwordDisplay(Material material, String name, BlockProperties prop) {
        super(material, name, prop);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(ArmorPlus.tabArmorPlusBlocks);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PEDESTAL_AABB;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileSwordDisplay) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileSwordDisplay te;
            if (player.func_70093_af() && player.func_184600_cs() == EnumHand.MAIN_HAND && player.func_184614_ca().func_190926_b() && (te = (TileSwordDisplay)world.func_175625_s(pos)) != null) {
                ItemStack toDrop = te.getSword().func_77946_l();
                te.setSword(ItemStack.field_190927_a);
                player.func_71019_a(toDrop, false);
            }
            if (!player.func_70093_af()) {
                ItemStack stack = player.func_184586_b(hand);
                TileSwordDisplay te2 = (TileSwordDisplay)world.func_175625_s(pos);
                if (te2 != null && te2.getSword().func_190926_b() && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() == this.getItem("draconicevolution:wyvern_sword") || stack.func_77973_b() == this.getItem("draconicevolution:draconic_sword") || stack.func_77973_b() == this.getItem("tconstruct:longsword") || stack.func_77973_b() == this.getItem("tconstruct:broadsword") || stack.func_77973_b() == this.getItem("tconstruct:cleaver") || stack.func_77973_b() == this.getItem("tconstruct:rapier") || stack.func_77973_b() == this.getItem("projecte:item.pe_dm_sword") || stack.func_77973_b() == this.getItem("projecte:item.pe_rm_sword")) && hand == EnumHand.MAIN_HAND) {
                    ItemStack copy = stack.func_77946_l();
                    te2.setSword(copy);
                    stack.func_190918_g(1);
                }
            }
        }
        return false;
    }

    public Item getItem(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemstack = super.getPickBlock(state, target, world, pos, player);
        TileSwordDisplay tileTrophy = (TileSwordDisplay)world.func_175625_s(pos);
        NBTTagCompound nbttagcompound = tileTrophy.saveToNbt(new NBTTagCompound());
        tileTrophy.func_70296_d();
        if (!nbttagcompound.func_82582_d()) {
            itemstack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        }
        return itemstack;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileSwordDisplay) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((TileSwordDisplay)tileentity).getSword().func_77946_l());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSwordDisplay();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        this.initModel(Utils.setRL("empty_sword_display"), "", "", 0, "normal");
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
        return iblockstate;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }
}

